/*
 * Decompiled with CFR 0.152.
 */
package turtlekit2.tools;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import turtlekit2.kernel.Patch;
import turtlekit2.kernel.Viewer;

public class EnvironmentPatchEditor
extends Viewer
implements MouseListener,
MouseMotionListener,
ActionListener,
MouseWheelListener {
    static final int RECTANGLE = 0;
    static final int CIRCLE = 1;
    static final int POINT = 2;
    static final int FILL = 3;
    static final int LINE = 4;
    static final int SOLIDCIRCLE = 5;
    static final int ELLIPSE = 6;
    static final int TINY = 0;
    static final int MEDIUM = 1;
    static final int BIG = 2;
    static final int HUGE = 3;
    int drawing = 2;
    boolean mouseClc = false;
    boolean ellipse = false;
    int radius = 0;
    int radiusSecond = 0;
    int xFirstClick;
    int yFirstClick;
    int xSecondClick;
    int ySecondClick;
    int size = 2;
    Color markColor;
    JLabel lb;
    JLabel actionClick;
    private JPanel panel;

    public void init() {
    }

    public void initGUI() {
        super.initGUI();
        this.createFrame();
        this.getOnScreen().addMouseWheelListener(this);
        this.getOnScreen().addMouseListener(this);
        this.getOnScreen().addMouseMotionListener(this);
    }

    public void createFrame() {
        JFrame jFrame = new JFrame("Environnement Edition");
        jFrame.setTitle("TurtleKit Environnement Editor");
        jFrame.setSize(350, 100);
        this.panel = new JPanel();
        jFrame.getContentPane().add((Component)this.panel, "Center");
        ColorAction colorAction = new ColorAction("Yellow", (Icon)new ImageIcon("images\\jaune.gif"), Color.yellow);
        ColorAction colorAction2 = new ColorAction("Green", (Icon)new ImageIcon("images\\vert.gif"), Color.green);
        ColorAction colorAction3 = new ColorAction("Red", (Icon)new ImageIcon("images\\rouge.gif"), Color.red);
        ColorAction colorAction4 = new ColorAction("Black", (Icon)new ImageIcon("images\\noir.gif"), Color.black);
        ColorAction colorAction5 = new ColorAction("Blue", (Icon)new ImageIcon("images\\bleu.gif"), Color.blue);
        ColorAction colorAction6 = new ColorAction("Grey", (Icon)new ImageIcon("images\\gris.gif"), Color.gray);
        ColorAction colorAction7 = new ColorAction("White", (Icon)new ImageIcon("images\\blanc.gif"), Color.white);
        ColorAction colorAction8 = new ColorAction("Tiny", (Icon)new ImageIcon("images\\tiny.gif"), 0);
        ColorAction colorAction9 = new ColorAction("Medium", (Icon)new ImageIcon("images\\medium.gif"), 1);
        ColorAction colorAction10 = new ColorAction("Big", (Icon)new ImageIcon("images\\big.gif"), 2);
        ColorAction colorAction11 = new ColorAction("Huge", (Icon)new ImageIcon("images\\huge.gif"), 3);
        this.lb = new JLabel("Coord X - Y", 0);
        this.actionClick = new JLabel("Click", 0);
        this.panel.add(this.actionClick);
        this.panel.add(this.lb);
        JToolBar jToolBar = new JToolBar("Faites votre choix");
        jToolBar.add(colorAction);
        jToolBar.add(colorAction2);
        jToolBar.add(colorAction3);
        jToolBar.add(colorAction4);
        jToolBar.add(colorAction5);
        jToolBar.add(colorAction6);
        jToolBar.add(colorAction7);
        jToolBar.addSeparator();
        jToolBar.add(colorAction8);
        jToolBar.add(colorAction9);
        jToolBar.add(colorAction10);
        jToolBar.add(colorAction11);
        jFrame.getContentPane().add((Component)jToolBar, "North");
        JMenu jMenu = new JMenu("Pattern");
        JMenuItem jMenuItem = new JMenuItem("Rectangle");
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(this);
        jMenuItem = new JMenuItem("Circle");
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(this);
        jMenuItem = new JMenuItem("SolidCircle");
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(this);
        jMenuItem = new JMenuItem("Ellipse");
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(this);
        jMenuItem = new JMenuItem("Point");
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(this);
        jMenuItem = new JMenuItem("Fill");
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(this);
        jMenuItem = new JMenuItem("Line");
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(this);
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(jMenu);
        jFrame.setJMenuBar(jMenuBar);
        jFrame.setVisible(true);
    }

    public void paintPatch(Graphics graphics, Patch patch, int n, int n2, int n3) {
        try {
            graphics.setColor(patch.getColor());
            graphics.fillRect(n, n2, n3, n3);
        }
        catch (Exception exception) {
            System.err.println("Error Viewer " + exception);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("Rectangle")) {
            this.drawing = 0;
        } else if (actionEvent.getActionCommand().equals("Circle")) {
            this.drawing = 1;
        } else if (actionEvent.getActionCommand().equals("Point")) {
            this.drawing = 2;
        } else if (actionEvent.getActionCommand().equals("Fill")) {
            this.fill(0, 0, this.envHeight, this.envHeight);
        } else if (actionEvent.getActionCommand().equals("Line")) {
            this.drawing = 4;
        } else if (actionEvent.getActionCommand().equals("SolidCircle")) {
            this.drawing = 5;
        } else if (actionEvent.getActionCommand().equals("Ellipse")) {
            this.drawing = 6;
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        int n;
        int n2;
        boolean bl = this.mouseClc = !this.mouseClc;
        if (this.mouseClc) {
            this.xFirstClick = mouseEvent.getX() / this.getCellSize();
            this.yFirstClick = mouseEvent.getY() / this.getCellSize();
            this.actionClick.setText("X1:" + this.xFirstClick + " Y1:" + this.yFirstClick);
        } else {
            this.xSecondClick = mouseEvent.getX() / this.getCellSize();
            this.ySecondClick = mouseEvent.getY() / this.getCellSize();
            this.actionClick.setText("X2:" + this.xSecondClick + " Y2:" + this.ySecondClick);
        }
        if (this.drawing == 0 && !this.mouseClc) {
            this.fill(this.xFirstClick, this.yFirstClick, this.xSecondClick, this.ySecondClick);
        }
        if (this.drawing == 4 && !this.mouseClc) {
            this.line(this.xFirstClick, this.yFirstClick, this.xSecondClick, this.ySecondClick);
        }
        if (this.drawing == 1 && !this.mouseClc) {
            n2 = Math.abs(this.xSecondClick - this.xFirstClick);
            n = Math.abs(this.ySecondClick - this.yFirstClick);
            this.radius = (int)Math.sqrt(n2 * n2 + n * n);
            this.circle(this.radius, this.xFirstClick, -this.yFirstClick);
        }
        if (this.drawing == 5 && !this.mouseClc) {
            n2 = Math.abs(this.xSecondClick - this.xFirstClick);
            n = Math.abs(this.ySecondClick - this.yFirstClick);
            this.radius = (int)Math.sqrt(n2 * n2 + n * n);
            this.solidCircle(this.radius, this.xFirstClick, -this.yFirstClick);
        }
        if (this.drawing == 6 && !this.mouseClc) {
            if (!this.ellipse) {
                n2 = Math.abs(this.xSecondClick - this.xFirstClick);
                n = Math.abs(this.ySecondClick - this.yFirstClick);
                this.radius = (int)Math.sqrt(n2 * n2 + n * n);
                this.mouseClc = true;
                this.ellipse = true;
            } else {
                n2 = Math.abs(this.xSecondClick - this.xFirstClick);
                n = Math.abs(this.ySecondClick - this.yFirstClick);
                this.radiusSecond = (int)Math.sqrt(n2 * n2 + n * n);
                this.ellipse = false;
                this.ellipse(this.radius, this.radiusSecond, this.xFirstClick, -this.yFirstClick);
            }
        }
    }

    void ellipse(int n, int n2, int n3, int n4) {
        for (int i = 0; i <= n; ++i) {
            for (int j = n2; j <= n2; ++j) {
                int n5 = 0;
                int n6 = j;
                double d = j * j - i * i * j + i * i / 4;
                this.colorPoint(n5 + n3, n6 - n4);
                this.colorPoint(n5 + n3, -n6 - n4);
                this.colorPoint(-n5 + n3, n6 - n4);
                this.colorPoint(-n5 + n3, -n6 - n4);
                while ((double)(i * i) * ((double)n6 - 0.5) > (double)(j * j * (n5 + 1))) {
                    if (d < 0.0) {
                        d += (double)(j * j * (2 * n5 + 3));
                        ++n5;
                    } else {
                        d += (double)(j * j * (2 * n5 + 3) + i * i * (-2 * n6 + 2));
                        ++n5;
                        --n6;
                    }
                    this.colorPoint(n5 + n3, n6 - n4);
                    this.colorPoint(n5 + n3, -n6 - n4);
                    this.colorPoint(-n5 + n3, n6 - n4);
                    this.colorPoint(-n5 + n3, -n6 - n4);
                }
                double d2 = (double)(j * j) * ((double)n5 + 0.5) * ((double)n5 + 0.5) + (double)(i * i * (n6 - 1) * (n6 - 1)) - (double)(i * i * j * j);
                while (n6 > 0) {
                    if (d2 < 0.0) {
                        d2 += (double)(j * j * (2 * n5 + 2) + i * i * (-2 * n6 + 3));
                        --n6;
                        ++n5;
                    } else {
                        d2 += (double)(i * i * (-2 * n6 + 3));
                        --n6;
                    }
                    this.colorPoint(n5 + n3, n6 - n4);
                    this.colorPoint(n5 + n3, -n6 - n4);
                    this.colorPoint(-n5 + n3, n6 - n4);
                    this.colorPoint(-n5 + n3, -n6 - n4);
                }
            }
        }
    }

    void solidCircle(int n, int n2, int n3) {
        for (int i = 0; i <= n; ++i) {
            int n4 = 0;
            int n5 = i;
            int n6 = 1 - i;
            this.colorPoint(n4 + n2, -n5 - n3);
            this.colorPoint(n4 + n2, n5 - n3);
            this.colorPoint(-n4 + n2, n5 - n3);
            this.colorPoint(-n4 + n2, -n5 - n3);
            this.colorPoint(n5 + n2, n4 - n3);
            this.colorPoint(n5 + n2, -n4 - n3);
            this.colorPoint(-n5 + n2, n4 - n3);
            this.colorPoint(-n5 + n2, -n4 - n3);
            while (n5 > n4) {
                if (n6 < 0) {
                    n6 += 2 * n4 + 3;
                } else {
                    n6 += 2 * (n4 - n5) + 5;
                    --n5;
                }
                this.colorPoint(++n4 + n2, -n5 - n3);
                this.colorPoint(n4 + n2, n5 - n3);
                this.colorPoint(-n4 + n2, n5 - n3);
                this.colorPoint(-n4 + n2, -n5 - n3);
                this.colorPoint(n5 + n2, n4 - n3);
                this.colorPoint(n5 + n2, -n4 - n3);
                this.colorPoint(-n5 + n2, n4 - n3);
                this.colorPoint(-n5 + n2, -n4 - n3);
            }
        }
    }

    void circle(int n, int n2, int n3) {
        int n4 = 0;
        int n5 = n;
        int n6 = 1 - n;
        this.colorPoint(n4 + n2, -n5 - n3);
        this.colorPoint(n4 + n2, n5 - n3);
        this.colorPoint(-n4 + n2, n5 - n3);
        this.colorPoint(-n4 + n2, -n5 - n3);
        this.colorPoint(n5 + n2, n4 - n3);
        this.colorPoint(n5 + n2, -n4 - n3);
        this.colorPoint(-n5 + n2, n4 - n3);
        this.colorPoint(-n5 + n2, -n4 - n3);
        while (n5 > n4) {
            if (n6 < 0) {
                n6 += 2 * n4 + 3;
            } else {
                n6 += 2 * (n4 - n5) + 5;
                --n5;
            }
            this.colorPoint(++n4 + n2, -n5 - n3);
            this.colorPoint(n4 + n2, n5 - n3);
            this.colorPoint(-n4 + n2, n5 - n3);
            this.colorPoint(-n4 + n2, -n5 - n3);
            this.colorPoint(n5 + n2, n4 - n3);
            this.colorPoint(n5 + n2, -n4 - n3);
            this.colorPoint(-n5 + n2, n4 - n3);
            this.colorPoint(-n5 + n2, -n4 - n3);
        }
    }

    void colorize(int n, int n2) {
        if (n < this.envWidth && n > -1 && n2 < this.envHeight && n2 > -1) {
            this.patchGrid[n][this.envHeight - 1 - n2].setColor(this.markColor);
        }
    }

    void colorPoint(int n, int n2) {
        if (this.size == 0) {
            this.colorize(n, n2);
        } else {
            for (int i = n - this.size; i <= n + this.size; ++i) {
                for (int j = n2 - this.size; j <= n2 + this.size; ++j) {
                    this.colorize(i, j);
                }
            }
        }
    }

    void line(int n, int n2, int n3, int n4) {
        int n5 = n;
        int n6 = n2;
        int n7 = n3 - n;
        int n8 = n4 - n2;
        int n9 = n7 > 0 ? 1 : -1;
        int n10 = n8 > 0 ? 1 : -1;
        n7 = Math.abs(n7);
        n8 = Math.abs(n8);
        this.colorPoint(n5, n6);
        if (n7 > n8) {
            int n11 = n7 / 2;
            for (int i = 1; i <= n7; ++i) {
                n5 += n9;
                if ((n11 += n8) >= n7) {
                    n11 -= n7;
                    n6 += n10;
                }
                this.colorPoint(n5, n6);
            }
        } else {
            int n12 = n8 / 2;
            for (int i = 1; i <= n8; ++i) {
                n6 += n10;
                if ((n12 += n7) >= n8) {
                    n12 -= n8;
                    n5 += n9;
                }
                this.colorPoint(n5, n6);
            }
        }
    }

    public void fill(int n, int n2, int n3, int n4) {
        int n5;
        if (n > n3) {
            n5 = n;
            n = n3;
            n3 = n5;
        }
        if (n2 > n4) {
            n5 = n2;
            n2 = n4;
            n4 = n5;
        }
        this.lb.setText(n + " " + n2 + " " + n3 + " " + n4);
        for (n5 = n; n5 < n3; ++n5) {
            for (int i = n2; i < n4; ++i) {
                this.colorPoint(n5, i);
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.drawing == 2) {
            int n = mouseEvent.getX() / this.getCellSize();
            int n2 = mouseEvent.getY() / this.getCellSize();
            this.colorPoint(n, n2);
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.lb.setText("X:" + mouseEvent.getX() / this.getCellSize() + " Y:" + mouseEvent.getY() / this.getCellSize());
    }

    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
    }

    class ColorAction
    extends AbstractAction {
        public ColorAction(String string, Icon icon, Color color) {
            this.putValue("Name", string);
            this.putValue("SmallIcon", icon);
            this.putValue("ShortDescription", "The color is " + string);
            this.putValue("Color", color);
        }

        public ColorAction(String string, Icon icon, int n) {
            this.putValue("Name", string);
            this.putValue("SmallIcon", icon);
            this.putValue("ShortDescription", "The color is " + string);
            this.putValue("Size", new Integer(n));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object[] objectArray = this.getKeys();
            for (int i = 0; i < objectArray.length; ++i) {
                System.out.println(objectArray[i]);
                if (objectArray[i].equals("Color")) {
                    EnvironmentPatchEditor.this.markColor = (Color)this.getValue("Color");
                }
                if (!objectArray[i].equals("Size")) continue;
                EnvironmentPatchEditor.this.size = (Integer)this.getValue("Size");
            }
            System.out.println(EnvironmentPatchEditor.this.markColor + " " + EnvironmentPatchEditor.this.size);
            EnvironmentPatchEditor.this.panel.repaint();
        }
    }
}

