/*
 * Decompiled with CFR 0.152.
 */
package turtlekit2.kernel;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilderFactory;
import madkit.boot.Madkit;
import madkit.kernel.AbstractAgent;
import madkit.kernel.Agent;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import turtlekit2.genetic.GTurtle;
import turtlekit2.genetic.MetaManager;
import turtlekit2.kernel.LauncherGui;
import turtlekit2.kernel.Observer;
import turtlekit2.kernel.PatchVariable;
import turtlekit2.kernel.PythonCommandCenter;
import turtlekit2.kernel.TopMessage;
import turtlekit2.kernel.Turtle;
import turtlekit2.kernel.TurtleEnvironment;
import turtlekit2.kernel.TurtleScheduler;
import turtlekit2.kernel.Viewer;
import turtlekit2.kernel.XMLAttributes;

public class Launcher
extends Agent {
    boolean standAloneMode = false;
    boolean geneticMode = false;
    LauncherGui onScreen;
    TurtleEnvironment playGround = null;
    TurtleScheduler sch = null;
    MetaManager metamanager = null;
    String simulationName = "TurtleKit Simulation";
    int cellSize = 2;
    int cyclePause = 0;
    int cycleDisplayEvery = 1000;
    int envWidth = 100;
    int envHeight = 100;
    int defaultRefresh = 0;
    Vector<PatchVariable> flavors = null;
    ArrayList<PatchVariable> volatileVariables = new ArrayList();
    ArrayList<Turtle> initialPopulation = new ArrayList();
    ArrayList<AbstractAgent> launchedObservers = new ArrayList();
    NodeList simulationsNodes;
    NodeList flavorsList;
    NodeList viewersList;
    NodeList observersList;
    NodeList agentsList;
    NodeList poolsList;
    NodeList managersList;
    Element simulationNode;
    public String simulationFilePath;
    Class<? extends Viewer> preferedViewer;
    public static final String COMMUNITY = "Tkit";
    boolean run = false;
    boolean start = false;
    boolean wrap = true;
    boolean diffusion = false;
    boolean pythonOn = false;

    public Launcher() {
        this.simulationFilePath = "simulation.xml";
        this.standAloneMode = true;
    }

    public Launcher(String string) {
        this.simulationFilePath = string;
        this.standAloneMode = false;
    }

    public Launcher(Node node) {
        this.standAloneMode = false;
        this.simulationNode = (Element)node;
    }

    public void loadConfigFile() {
        if (this.simulationFilePath != null) {
            try {
                FileInputStream fileInputStream = new FileInputStream(new File(this.simulationFilePath));
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                Document document = documentBuilderFactory.newDocumentBuilder().parse(fileInputStream);
                this.simulationNode = document.getDocumentElement();
            }
            catch (IOException iOException) {
                System.err.println("File read error with !\n" + this.simulationFilePath);
            }
            catch (SAXException sAXException) {
                System.err.println("Load file: Parsing error of the file !\n" + this.simulationFilePath);
            }
            catch (Exception exception) {
                System.err.println("Load file error !\n" + this.simulationFilePath);
            }
        }
    }

    public void setSimulationNode(Element element) {
        this.simulationNode = element;
    }

    private void initializeNodes() {
        try {
            this.flavorsList = this.simulationNode.getElementsByTagName("Flavors");
            this.viewersList = this.simulationNode.getElementsByTagName("Viewers");
            this.observersList = this.simulationNode.getElementsByTagName("Observers");
            this.agentsList = this.simulationNode.getElementsByTagName("Agents");
            this.managersList = this.simulationNode.getElementsByTagName("Managers");
            NodeList nodeList = this.simulationNode.getElementsByTagName("Pools");
            if (nodeList.getLength() > 0) {
                this.geneticMode = true;
                Node node = nodeList.item(0);
                this.poolsList = ((Element)node).getElementsByTagName("Pool");
            }
        }
        catch (Exception exception) {
            System.err.println("Nodes initialisation error" + exception);
        }
    }

    protected void initializeSimulationParameters() {
        try {
            int n;
            boolean bl;
            int n2;
            int n3;
            int n4;
            if (this.simulationNode.hasAttribute("Name")) {
                this.simulationName = this.simulationNode.getAttribute("Name");
            }
            if (this.simulationNode.hasAttribute("Width")) {
                n4 = Integer.parseInt(this.simulationNode.getAttribute("Width"));
            } else {
                this.println("width default: 100");
                n4 = 100;
            }
            if (this.simulationNode.hasAttribute("Height")) {
                n3 = Integer.parseInt(this.simulationNode.getAttribute("Height"));
            } else {
                this.println("height default: 100");
                n3 = 100;
            }
            if (this.simulationNode.hasAttribute("CellSize")) {
                n2 = Integer.parseInt(this.simulationNode.getAttribute("CellSize"));
            } else {
                this.println("cellSize default: 3");
                n2 = 3;
            }
            if (this.simulationNode.hasAttribute("TorusMode")) {
                bl = this.simulationNode.getAttribute("TorusMode").equals("on");
            } else {
                this.println("wrapMode default: true");
                bl = true;
            }
            if (this.simulationNode.hasAttribute("Refresh")) {
                this.defaultRefresh = Integer.parseInt(this.simulationNode.getAttribute("Refresh"));
            } else {
                this.println("defaultRefresh default: 0");
                this.defaultRefresh = 0;
            }
            if (this.simulationNode.hasAttribute("CyclePause")) {
                n = Integer.parseInt(this.simulationNode.getAttribute("CyclePause"));
            } else {
                this.println("cyclePause default: 1");
                n = 1;
            }
            this.setWidth(n4);
            this.setHeight(n3);
            this.setCellSize(n2);
            this.setCyclePause(n);
            this.setWrapModeOn(bl);
        }
        catch (Exception exception) {
            System.err.println("Simulation init: Parsing Error" + exception);
        }
    }

    public void thisCreateInitPopulation() {
        for (int i = 0; i < this.agentsList.getLength(); ++i) {
            Node node = this.agentsList.item(i);
            NodeList nodeList = ((Element)node).getElementsByTagName("Agent");
            this.createInitialPopulation(nodeList, i);
        }
    }

    protected void createInitialPopulation(NodeList nodeList, int n) {
        try {
            System.out.println("AGENT NODE " + nodeList.getLength());
            if (nodeList.getLength() > 0) {
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Element element = (Element)nodeList.item(i);
                    String string = "";
                    string = element.hasAttribute("AgentClass") ? element.getAttribute("AgentClass") : "turtlekit2.tools.RandomMovingTurtle";
                    int n2 = 1;
                    if (element.hasAttribute("NbAgents")) {
                        n2 = Integer.parseInt(element.getAttribute("NbAgents"));
                    }
                    NodeList nodeList2 = element.getElementsByTagName("Parameters");
                    Element element2 = (Element)nodeList2.item(0);
                    NamedNodeMap namedNodeMap = element2.getAttributes();
                    int n3 = namedNodeMap.getLength();
                    XMLAttributes xMLAttributes = new XMLAttributes();
                    for (int j = 0; j < n3; ++j) {
                        xMLAttributes.put(namedNodeMap.item(j).getNodeName(), element2.getAttribute(namedNodeMap.item(j).getNodeName()));
                    }
                    String string2 = new Integer(n).toString() + new Integer(i).toString();
                    xMLAttributes.put("Node", string2);
                    xMLAttributes.put("GroupNode", new Integer(n).toString());
                    xMLAttributes.put("AgentClass", string);
                    if (element.hasAttribute("x")) {
                        xMLAttributes.put("x", element.getAttribute("x"));
                    }
                    if (element.hasAttribute("y")) {
                        xMLAttributes.put("y", element.getAttribute("y"));
                    }
                    this.newAgents(xMLAttributes, n2);
                }
            } else {
                String string = "turtlekit2.tools.RandomMovingTurtle";
                int n4 = 10;
                XMLAttributes xMLAttributes = new XMLAttributes();
                xMLAttributes.put("Node", "0");
                xMLAttributes.put("GroupNode", "0");
                xMLAttributes.put("AgentClass", string);
                this.newAgents(xMLAttributes, n4);
            }
        }
        catch (Exception exception) {
            System.err.println("Agent Initialisation problem !\n" + exception);
        }
    }

    public void newAgents(XMLAttributes xMLAttributes, int n) {
        String string = xMLAttributes.getString("AgentClass");
        try {
            Class clazz = Madkit.getClassLoader().loadClass(string);
            for (int i = 0; i < n; ++i) {
                Turtle turtle = (Turtle)((Object)clazz.newInstance());
                turtle.setAttributes(xMLAttributes);
                if (turtle.getAttributes().containsKey("x") && turtle.getAttributes().containsKey("y")) {
                    this.addTurtle(turtle, turtle.getAttributes().getInt("x"), turtle.getAttributes().getInt("y"));
                } else {
                    this.addTurtle(turtle);
                }
                this.initialPopulation.add(turtle);
            }
        }
        catch (Exception exception) {
            System.err.println("Agent Initialisation problem: " + xMLAttributes + "\n" + exception);
        }
    }

    public void thisInitViewers() {
        for (int i = 0; i < this.viewersList.getLength(); ++i) {
            Node node = this.viewersList.item(i);
            NodeList nodeList = ((Element)node).getElementsByTagName("Viewer");
            this.initializeViewers(nodeList);
        }
    }

    public void initializeViewers(NodeList nodeList) {
        try {
            if (nodeList.getLength() > 0) {
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Element element = (Element)nodeList.item(i);
                    NamedNodeMap namedNodeMap = element.getAttributes();
                    int n = namedNodeMap.getLength();
                    XMLAttributes xMLAttributes = new XMLAttributes();
                    for (int j = 0; j < n; ++j) {
                        xMLAttributes.put(namedNodeMap.item(j).getNodeName(), element.getAttribute(namedNodeMap.item(j).getNodeName()));
                    }
                    this.newViewer(xMLAttributes);
                }
            } else {
                XMLAttributes xMLAttributes = new XMLAttributes();
                this.newViewer(xMLAttributes);
            }
        }
        catch (Exception exception) {
            System.err.println("Viewers Groups Initialisation problem !\n" + exception);
        }
    }

    public void newViewer(XMLAttributes xMLAttributes) {
        String string = "";
        string = xMLAttributes.containsKey("ViewerClass") ? xMLAttributes.getString("ViewerClass") : "turtlekit2.kernel.Viewer";
        try {
            Class clazz = Madkit.getClassLoader().loadClass(string);
            Viewer viewer = (Viewer)((Object)clazz.newInstance());
            viewer.setAttrib(xMLAttributes);
            this.addViewer(viewer);
        }
        catch (Exception exception) {
            System.err.println("Viewer Initialisation problem: " + string + "\n" + exception);
        }
    }

    public void thisInitObservers() {
        for (int i = 0; i < this.observersList.getLength(); ++i) {
            Node node = this.observersList.item(i);
            NodeList nodeList = ((Element)node).getElementsByTagName("Observer");
            this.initializeObservers(nodeList);
        }
    }

    public void initializeObservers(NodeList nodeList) {
        try {
            if (nodeList.getLength() > 0) {
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Element element = (Element)nodeList.item(i);
                    NamedNodeMap namedNodeMap = element.getAttributes();
                    int n = namedNodeMap.getLength();
                    XMLAttributes xMLAttributes = new XMLAttributes();
                    for (int j = 0; j < n; ++j) {
                        xMLAttributes.put(namedNodeMap.item(j).getNodeName(), element.getAttribute(namedNodeMap.item(j).getNodeName()));
                    }
                    this.newObserver(xMLAttributes);
                }
            }
        }
        catch (Exception exception) {
            System.err.println("Observer Instanciation problem !\n" + exception);
        }
    }

    public void newObserver(XMLAttributes xMLAttributes) {
        String string = xMLAttributes.getString("ObserverClass");
        try {
            Class clazz = Madkit.getClassLoader().loadClass(string);
            Observer observer = (Observer)((Object)clazz.newInstance());
            observer.setAttrib(xMLAttributes);
            this.addObserver(observer, false);
        }
        catch (Exception exception) {
            System.err.println("Observer Instanciation problem: " + string + "\n" + exception);
        }
        System.out.println("Observer init:" + xMLAttributes);
    }

    public void launch(Node node) {
        System.out.println(node.getNodeName());
    }

    public void thisInitPatchVariables() {
        for (int i = 0; i < this.flavorsList.getLength(); ++i) {
            NodeList nodeList;
            Node node = this.flavorsList.item(i);
            NodeList nodeList2 = ((Element)node).getElementsByTagName("Flavor");
            if (nodeList2.getLength() != 0) {
                this.initializePatchVariables(nodeList2);
            }
            if ((nodeList = ((Element)node).getElementsByTagName("RandomFlavors")).getLength() == 0) continue;
            this.initializeRandomVariables(nodeList);
        }
    }

    public void initializeRandomVariables(NodeList nodeList) {
        try {
            if (nodeList.getLength() > 0) {
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Element element = (Element)nodeList.item(i);
                    String string = "RandomFlavor";
                    if (element.hasAttribute("Name")) {
                        string = element.getAttribute("Name");
                    }
                    int n = 1;
                    if (element.hasAttribute("Number")) {
                        n = Integer.parseInt(element.getAttribute("Number"));
                    }
                    for (int j = 0; j < n; ++j) {
                        double d = element.hasAttribute("Diffusion") ? Double.parseDouble(element.getAttribute("Diffusion")) : Math.random();
                        double d2 = element.hasAttribute("Evaporation") ? Double.parseDouble(element.getAttribute("Evaporation")) : Math.random();
                        double d3 = element.hasAttribute("Quantity") ? Double.parseDouble(element.getAttribute("Quantity")) : Math.random() * 10000.0;
                        PatchVariable patchVariable = new PatchVariable(string + j);
                        if (element.hasAttribute("Volatile")) {
                            this.volatileVariables.add(patchVariable);
                        }
                        patchVariable.setDiffuseCoef(d);
                        patchVariable.setEvapCoef(d2);
                        patchVariable.setDefaultValue(d3);
                        this.addPatchVariable(patchVariable);
                    }
                }
            }
        }
        catch (Exception exception) {
            System.err.println("RandomFlavors Initialisation problem: \n" + exception);
        }
    }

    public void initializePatchVariables(NodeList nodeList) {
        try {
            int n = 0;
            if (nodeList.getLength() > 0) {
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Element element = (Element)nodeList.item(i);
                    String string = "Flavor";
                    if (element.hasAttribute("Name")) {
                        string = element.getAttribute("Name");
                    } else {
                        string = string + n;
                        ++n;
                    }
                    double d = element.hasAttribute("Diffusion") ? Double.parseDouble(element.getAttribute("Diffusion")) : Math.random();
                    double d2 = element.hasAttribute("Evaporation") ? Double.parseDouble(element.getAttribute("Evaporation")) : Math.random();
                    double d3 = element.hasAttribute("Quantity") ? Double.parseDouble(element.getAttribute("Quantity")) : Math.random() * 10000.0;
                    PatchVariable patchVariable = new PatchVariable(string);
                    if (element.hasAttribute("Volatile")) {
                        this.volatileVariables.add(patchVariable);
                    }
                    patchVariable.setDiffuseCoef(d);
                    patchVariable.setEvapCoef(d2);
                    patchVariable.setDefaultValue(d3);
                    this.addPatchVariable(patchVariable);
                }
            }
        }
        catch (Exception exception) {
            System.err.println("Flavors Initialisation problem: \n" + exception);
        }
    }

    public void initializeGenetic() {
        if (this.metamanager == null) {
            this.metamanager = new MetaManager(this, this.poolsList, this.managersList, this.flavors, this.defaultRefresh);
        } else {
            this.killAgent((AbstractAgent)this.metamanager);
            this.metamanager = new MetaManager(this, this.poolsList, this.managersList, this.flavors, this.defaultRefresh);
        }
        this.addObserver(this.metamanager, false, "MetaManager");
    }

    public void activate() {
        this.println("activated");
        if (this.onScreen != null) {
            this.onScreen.initialisation();
        }
        this.loadConfigFile();
        this.initializeNodes();
        this.initializeSimulationParameters();
        int n = 2;
        if (this.isGroup(COMMUNITY, this.simulationName)) {
            while (this.isGroup(COMMUNITY, this.simulationName + " " + n)) {
                ++n;
            }
            this.simulationName = this.simulationName + " " + n;
        }
        this.createGroup(false, COMMUNITY, this.simulationName, null, null);
        this.requestRole(COMMUNITY, this.simulationName, "launcher", null);
        if (this.onScreen != null) {
            this.onScreen.setName(this.simulationName);
        }
        this.launchScheduler(new TurtleScheduler(this.simulationName));
        this.thisInitPatchVariables();
        this.launchedObservers = new ArrayList();
        if (this.geneticMode) {
            this.initializeGenetic();
        }
        this.createLogoWorld();
        if (this.simulationFilePath == null) {
            this.addSimulationAgents();
        } else {
            this.initialPopulation = new ArrayList();
            this.thisCreateInitPopulation();
            this.thisInitObservers();
            this.thisInitViewers();
        }
        this.println("Simulation is initialized !!");
        this.println("Click to begin...");
        while (true) {
            this.pause(50);
            if (this.start) break;
            if (this.nextMessage() == null) continue;
            this.onScreen.startStop.doClick();
        }
        this.start = true;
        this.run = true;
        this.sendMessage(this.sch.getAddress(), new TopMessage(1));
        if (!this.standAloneMode) {
            this.disposeMyGUI();
        }
    }

    public final void live() {
        int n = -1;
        while (true) {
            this.pause(this.cycleDisplayEvery);
            if (this.sch == null || !this.start || n == this.sch.iteration) continue;
            n = this.sch.iteration;
            this.println("step " + n);
        }
    }

    public final void end() {
        this.println("Closing simulation");
        this.println("Please wait...");
        this.sendMessage(this.sch.getAddress(), new TopMessage(-1));
        this.killAgent((AbstractAgent)this.sch);
        if (this.playGround != null) {
            this.killAgent(this.playGround);
        }
        Iterator<AbstractAgent> iterator = this.launchedObservers.iterator();
        while (iterator.hasNext()) {
            this.killAgent(iterator.next());
        }
        this.leaveGroup(this.simulationName);
        System.gc();
        System.runFinalization();
    }

    public final LauncherGui getOnScreen() {
        return this.onScreen;
    }

    public final void setWidth(int n) {
        this.envWidth = n;
    }

    public final int getWidth() {
        return this.envWidth;
    }

    public final void setCellSize(int n) {
        this.cellSize = n;
    }

    public final int getCellSize() {
        return this.cellSize;
    }

    public final void setHeight(int n) {
        this.envHeight = n;
    }

    public final int getHeight() {
        return this.envHeight;
    }

    public final String getSimulationName() {
        return this.simulationName;
    }

    public final void setSimulationName(String string) {
        this.simulationName = string;
    }

    public final void setCyclePause(int n) {
        this.cyclePause = n;
        if (this.sch != null) {
            this.sch.delay = this.cyclePause;
        }
    }

    public final void setReset() {
        this.sendMessage(this.sch.getAddress(), new TopMessage(3));
        this.start = false;
        this.println("Reseting: Please wait ...");
        this.run = false;
        this.playGround.clearAllTurtles();
        this.playGround.initGrid();
        this.initializeNodes();
        this.initializeSimulationParameters();
        this.killAgent(this.playGround);
        this.createLogoWorld();
        this.flavors = null;
        this.thisInitPatchVariables();
        this.launchedObservers.clear();
        if (this.geneticMode) {
            this.initializeGenetic();
        }
        if (this.simulationFilePath == null) {
            this.addSimulationAgents();
        } else {
            this.initialPopulation = new ArrayList();
            this.thisCreateInitPopulation();
            this.launchedObservers = new ArrayList();
            this.thisInitObservers();
            this.thisInitViewers();
        }
        this.start = true;
        this.run = true;
        this.sendMessage(this.sch.getAddress(), new TopMessage(1));
    }

    public void newPopulation() {
        if (!this.geneticMode) {
            this.setReset();
        } else {
            this.sendMessage(this.sch.getAddress(), new TopMessage(3));
            this.start = false;
            this.println("Reseting: Please wait ...");
            this.run = false;
            this.playGround.clearAllTurtles();
            this.playGround.clearVariables(this.volatileVariables);
            if (this.simulationFilePath == null) {
                this.addSimulationAgents();
            } else {
                this.initialPopulation = new ArrayList();
                this.thisCreateInitPopulation();
            }
            this.start = true;
            this.run = true;
            this.sendMessage(this.sch.getAddress(), new TopMessage(1));
        }
    }

    public final void setWrapModeOn(boolean bl) {
        if (this.run) {
            this.pauseSimulation();
        }
        this.wrap = bl;
        if (this.playGround != null) {
            this.playGround.wrap = bl;
            if (this.diffusion) {
                this.playGround.initNeighborhood();
            }
        }
        if (this.run) {
            this.sendMessage(this.sch.getAddress(), new TopMessage(1));
        }
    }

    void setStop() {
        if (this.run) {
            this.run = false;
            this.pauseSimulation();
            this.println("Simulation paused");
        } else {
            this.sendMessage(this.sch.getAddress(), new TopMessage(1));
            this.println("Simulation running");
            this.run = true;
        }
    }

    public final void stepByStep() {
        this.sendMessage(this.sch.getAddress(), new TopMessage(4));
        this.run = false;
    }

    final void initializeVariables() {
        Enumeration<PatchVariable> enumeration = this.flavors.elements();
        while (enumeration.hasMoreElements()) {
            PatchVariable patchVariable = enumeration.nextElement();
            this.playGround.addGridVariable(patchVariable);
        }
        this.playGround.initNeighborhood();
    }

    final void launchSimulation() {
        this.println("Launching simulation !");
        this.println("Please wait...");
        this.sendMessage(this.sch.getAddress(), new TopMessage(1));
    }

    final void createLogoWorld() {
        this.playGround = new TurtleEnvironment(this.envWidth, this.envHeight, this.simulationName);
        this.playGround.wrap = this.wrap;
        this.launchAgent(this.playGround, this.simulationName + " world", false);
        if (this.flavors != null) {
            this.initializeVariables();
        }
    }

    final void initViewer(Viewer viewer, int n, String string) {
        this.preferedViewer = ((Object)((Object)viewer)).getClass();
        viewer.cellSize = n;
        this.addObserver(viewer, true, string);
    }

    protected final void addTurtle(Turtle turtle) {
        if (this.geneticMode) {
            this.metamanager.manage((GTurtle)turtle);
            ((GTurtle)turtle).setFlavors(this.flavors);
        }
        this.playGround.addAgent(turtle);
    }

    protected final void addTurtle(Turtle turtle, int n, int n2) {
        if (this.geneticMode) {
            this.metamanager.manage((GTurtle)turtle);
            ((GTurtle)turtle).setFlavors(this.flavors);
        }
        this.playGround.addAgent(turtle, n, n2);
    }

    public final void addObserver(Observer observer, boolean bl, String string) {
        observer.simulationGroup = this.simulationName;
        observer.envWidth = this.envWidth;
        observer.envHeight = this.envHeight;
        observer.setFlavors(this.flavors);
        this.launchAgent((AbstractAgent)observer, string, bl);
        this.launchedObservers.add((AbstractAgent)observer);
    }

    public final void addObserver(Observer observer, boolean bl) {
        this.addObserver(observer, bl, this.simulationName + " Observer");
    }

    public final void addViewer() {
        this.addViewer(this.cellSize);
    }

    public final void addViewer(int n) {
        try {
            this.addViewer(this.preferedViewer.newInstance(), n);
        }
        catch (Exception exception) {
            this.addViewer(new Viewer(), n);
        }
    }

    public final void addViewer(Viewer viewer, int n, String string) {
        this.initViewer(viewer, n, string);
    }

    public final void addViewer(Viewer viewer, int n) {
        this.initViewer(viewer, n, this.simulationName + " Observer");
    }

    public final void addViewer(Viewer viewer, String string) {
        this.initViewer(viewer, this.cellSize, string);
    }

    public final void addViewer(Viewer viewer) {
        this.addViewer(viewer, this.cellSize);
    }

    protected void launchScheduler(TurtleScheduler turtleScheduler) {
        this.sch = turtleScheduler;
        this.sch.group = this.simulationName;
        this.launchAgent((AbstractAgent)this.sch, this.simulationName + " scheduler", false);
        this.waitNextMessage();
    }

    protected final void addPatchVariable(PatchVariable patchVariable) {
        if (this.flavors == null) {
            this.flavors = new Vector();
        }
        this.flavors.addElement(patchVariable);
    }

    public void addSimulationAgents() {
    }

    public final void initGUI() {
        this.onScreen = new LauncherGui(this);
        if (this.standAloneMode) {
            this.setGUIObject(this.onScreen);
        }
    }

    public void launchPython() throws Exception {
        PythonCommandCenter pythonCommandCenter = new PythonCommandCenter(this.simulationName);
        this.launchAgent((AbstractAgent)pythonCommandCenter, "Python command center", true);
        this.launchedObservers.add((AbstractAgent)pythonCommandCenter);
    }

    public void stopOrResumeSimulation() {
        this.onScreen.startStop.doClick();
    }

    public void pauseSimulation() {
        this.sendMessage(this.sch.getAddress(), new TopMessage(2));
        this.waitNextMessage();
    }

    public void runSimulation() {
    }

    public void stopSimulation() {
    }
}

