/*
 * Decompiled with CFR 0.152.
 */
package turtlekit2.genetic;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import madkit.boot.Madkit;
import madkit.kernel.AbstractAgent;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import turtlekit2.genetic.GTurtle;
import turtlekit2.genetic.Genome;
import turtlekit2.genetic.Manager;
import turtlekit2.genetic.MetaManagerGUI;
import turtlekit2.genetic.Pool;
import turtlekit2.kernel.Flavor;
import turtlekit2.kernel.Launcher;
import turtlekit2.kernel.Observer;
import turtlekit2.kernel.Turtle;
import turtlekit2.kernel.TurtleProbe;
import turtlekit2.kernel.XMLAttributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaManager
extends Observer {
    ArrayList<GTurtle> managedTurtles = new ArrayList();
    Launcher launcher;
    MetaManagerGUI myGui;
    Hashtable<Manager, Integer> activationTable = new Hashtable();
    Hashtable<Comparable, Genome> genomeAllocation = new Hashtable();
    Hashtable<String, Pool> poolTable = new Hashtable();
    Vector flavors;
    ArrayList<Manager> managersList = new ArrayList();
    NodeList poolsNodes;
    NodeList managersNodes;
    double stopWeight = 0.0;
    TurtleProbe probe;
    int simulationDuration = 0;
    int defaultRefresh = 0;
    String path = "";

    public MetaManager(Launcher launcher, NodeList nodeList, NodeList nodeList2, Vector vector, int n) {
        this.launcher = launcher;
        this.flavors = vector;
        this.initializeGenomePools(nodeList);
        this.initAllManagers(nodeList2);
        this.defaultRefresh = n;
        this.createFrame();
        System.out.println("MetaManager Created");
    }

    @Override
    public void setup() {
    }

    @Override
    public void activate() {
        super.activate();
    }

    public void createFrame() {
        this.myGui = new MetaManagerGUI("Metamanager", this.poolTable, this);
        this.myGui.setVisible(true);
    }

    public void clear() {
        for (Map.Entry<Manager, Integer> entry : this.activationTable.entrySet()) {
            this.killAgent((AbstractAgent)((Manager)((Object)entry.getValue())));
        }
    }

    public void manage(GTurtle gTurtle) {
        XMLAttributes xMLAttributes = gTurtle.getAttributes();
        String string = xMLAttributes.getString("Pool");
        int n = 0;
        if (xMLAttributes.containsKey("GeneticMode")) {
            n = xMLAttributes.getInt("GeneticMode");
        }
        Genome genome = null;
        if (n == 0) {
            genome = this.poolTable.get(string).pop();
        } else if (n == 1) {
            if (this.genomeAllocation.containsKey(new Integer(xMLAttributes.getInt("Node")))) {
                genome = this.genomeAllocation.get(new Integer(xMLAttributes.getInt("Node")));
            } else {
                genome = this.poolTable.get(string).pop();
                this.genomeAllocation.put(new Integer(xMLAttributes.getInt("Node")), genome);
            }
        } else if (n == 2) {
            if (this.genomeAllocation.containsKey(xMLAttributes.getString("Role"))) {
                genome = this.genomeAllocation.get(xMLAttributes.getString("Role"));
                if (!genome.getPoolName().equals(string)) {
                    genome = this.poolTable.get(string).pop();
                    this.genomeAllocation.put((Comparable)((Object)xMLAttributes.getString("Role")), genome);
                }
            } else {
                genome = this.poolTable.get(string).pop();
                this.genomeAllocation.put((Comparable)((Object)xMLAttributes.getString("Role")), genome);
            }
        } else if (n == 3) {
            if (this.genomeAllocation.containsKey(string)) {
                genome = this.genomeAllocation.get(string);
            } else {
                genome = this.poolTable.get(string).pop();
                this.genomeAllocation.put((Comparable)((Object)string), genome);
            }
        } else if (n == 4) {
            if (this.genomeAllocation.containsKey(xMLAttributes.getString("GroupNode"))) {
                genome = this.genomeAllocation.get(xMLAttributes.getString("GroupNode"));
                if (!genome.getPoolName().equals(string)) {
                    genome = this.poolTable.get(string).pop();
                    this.genomeAllocation.put((Comparable)((Object)xMLAttributes.getString("GroupNode")), genome);
                }
            } else {
                genome = this.poolTable.get(string).pop();
                this.genomeAllocation.put((Comparable)((Object)xMLAttributes.getString("GroupNode")), genome);
            }
        }
        System.out.println(genome);
        gTurtle.setGenome((Genome)genome.clone());
        for (int i = 0; i < this.managersList.size(); ++i) {
            Manager manager = this.managersList.get(i);
            String string2 = "all";
            if (manager.getAttrib().containsKey("Monitor")) {
                string2 = manager.getAttrib().getString("Monitor");
            }
            if (string2.equals("all")) {
                manager.addAgentToMonitor(gTurtle, genome);
                continue;
            }
            if (string2.equals("pool")) {
                if (!manager.getAttrib().getString("Monitored").equals(string)) continue;
                manager.addAgentToMonitor(gTurtle, genome);
                continue;
            }
            if (string2.equals("role")) {
                if (!manager.getAttrib().getString("Monitored").equals(xMLAttributes.getString("Role"))) continue;
                manager.addAgentToMonitor(gTurtle, genome);
                continue;
            }
            if (string2.equals("node")) {
                if (!manager.getAttrib().getString("Monitored").equals(xMLAttributes.getString("Node"))) continue;
                manager.addAgentToMonitor(gTurtle, genome);
                continue;
            }
            if (!string2.equals("group") || !manager.getAttrib().getString("Monitored").equals(xMLAttributes.getString("GroupNode"))) continue;
            manager.addAgentToMonitor(gTurtle, genome);
        }
        this.managedTurtles.add(gTurtle);
    }

    protected void initializeGenomePools(NodeList nodeList) {
        try {
            if (nodeList.getLength() > 0) {
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Hashtable<Integer, XMLAttributes> hashtable = new Hashtable<Integer, XMLAttributes>();
                    Element element = (Element)nodeList.item(i);
                    String string = "GenomePool";
                    if (element.hasAttribute("Name")) {
                        string = element.getAttribute("Name");
                    }
                    int n = 10;
                    if (element.hasAttribute("Population")) {
                        n = Integer.parseInt(element.getAttribute("Population"));
                    }
                    NodeList nodeList2 = element.getElementsByTagName("Gene");
                    String string2 = "turtlekit2.genetic.BitGene";
                    for (int j = 0; j < nodeList2.getLength(); ++j) {
                        Element element2 = (Element)nodeList2.item(j);
                        NamedNodeMap namedNodeMap = element2.getAttributes();
                        int n2 = namedNodeMap.getLength();
                        if (element2.hasAttribute("GeneClass")) {
                            string2 = element2.getAttribute("GeneClass");
                        }
                        int n3 = 1;
                        if (element2.hasAttribute("NbGenes")) {
                            n3 = Integer.parseInt(element2.getAttribute("NbGenes"));
                        }
                        XMLAttributes xMLAttributes = new XMLAttributes();
                        for (int k = 0; k < n2; ++k) {
                            xMLAttributes.put(namedNodeMap.item(k).getNodeName(), element2.getAttribute(namedNodeMap.item(k).getNodeName()));
                        }
                        xMLAttributes.put("nbFlavors", new Integer(this.flavors.size()).toString());
                        hashtable.put(new Integer(j), xMLAttributes);
                    }
                    Pool pool = new Pool(this.path, string);
                    pool.createPool(hashtable, n);
                    this.poolTable.put(string, pool);
                }
            }
        }
        catch (Exception exception) {
            System.err.println("Genome initialisation problem !\n" + exception);
        }
    }

    public void initAllManagers(NodeList nodeList) {
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            NodeList nodeList2 = ((Element)node).getElementsByTagName("Manager");
            this.initializeManagers(nodeList2);
        }
    }

    public void initializeManagers(NodeList nodeList) {
        try {
            if (nodeList.getLength() > 0) {
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Element element = (Element)nodeList.item(i);
                    NamedNodeMap namedNodeMap = element.getAttributes();
                    int n = namedNodeMap.getLength();
                    XMLAttributes xMLAttributes = new XMLAttributes();
                    for (int j = 0; j < n; ++j) {
                        xMLAttributes.put(namedNodeMap.item(j).getNodeName(), element.getAttribute(namedNodeMap.item(j).getNodeName()));
                    }
                    this.newManager(xMLAttributes);
                }
            }
        }
        catch (Exception exception) {
            System.err.println("Manager Initialisation problem !\n" + exception);
        }
    }

    public void newManager(XMLAttributes xMLAttributes) {
        String string = (String)xMLAttributes.get("ManagerClass");
        try {
            Class clazz = Madkit.getClassLoader().loadClass(string);
            Manager manager = (Manager)((Object)clazz.newInstance());
            manager.setManagerAttributes(xMLAttributes);
            manager.setMetaManager(this);
            this.managersList.add(manager);
            if (xMLAttributes.containsKey("Refresh")) {
                this.activationTable.put(manager, new Integer(xMLAttributes.getInt("Refresh")));
            } else {
                this.activationTable.put(manager, new Integer(1));
            }
            System.out.println("Launching " + xMLAttributes);
            this.launcher.addObserver(manager, false);
        }
        catch (Exception exception) {
            System.err.println("Loading manager " + string + "\n" + exception);
        }
        System.out.println("Manager init:" + xMLAttributes);
    }

    @Override
    public synchronized void watch() {
        ++this.simulationDuration;
        for (Map.Entry<Manager, Integer> entry : this.activationTable.entrySet()) {
            if (this.simulationDuration % entry.getValue() != 0) continue;
            entry.getKey().update(this.simulationDuration);
        }
        if (this.defaultRefresh != 0 && this.simulationDuration % this.defaultRefresh == 0) {
            this.askNewPopulation(1.0);
        }
    }

    public void askNewPopulation(double d) {
        this.stopWeight += d;
        if (this.stopWeight >= 1.0) {
            this.managedTurtles.clear();
            for (int i = 0; i < this.managersList.size(); ++i) {
                this.managersList.get(i).clear();
            }
            this.launcher.newPopulation();
            this.stopWeight = 0.0;
        }
    }

    public void clearSimulation() {
        for (int i = 0; i < this.envWidth; ++i) {
            for (int j = 0; j < this.envHeight; ++j) {
                if (this.patchGrid[i][j].getTurtles().length > 0) {
                    Turtle[] turtleArray = this.patchGrid[i][j].getTurtles();
                    for (int k = 0; k < turtleArray.length; ++k) {
                        turtleArray[k].die();
                    }
                }
                for (int k = 0; k < this.flavors.size(); ++k) {
                    this.patchGrid[i][j].setPatchVariable(((Flavor)this.flavors.get(k)).getName(), 0.0);
                }
            }
        }
    }

    public void setPoolsNodes(NodeList nodeList) {
        this.poolsNodes = nodeList;
    }

    public void setManagersNodes(NodeList nodeList) {
        this.managersNodes = nodeList;
    }

    public void setLaunchedTurtles(ArrayList<GTurtle> arrayList) {
        this.managedTurtles = arrayList;
    }

    public void setPath(String string) {
        this.path = string;
    }

    public void setDefaultRefresh(int n) {
        this.defaultRefresh = n;
    }
}

