/*
 * Decompiled with CFR 0.152.
 */
package turtlekit2.genetic;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import turtlekit2.genetic.ExtendedJButton;
import turtlekit2.genetic.GTurtle;
import turtlekit2.genetic.Genome;
import turtlekit2.genetic.MetaManager;
import turtlekit2.kernel.Observer;
import turtlekit2.kernel.XMLAttributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Manager
extends Observer {
    boolean refreshDisplay = true;
    ArrayList<GTurtle> monitoredAgents = new ArrayList();
    MetaManager metaManager;
    double fitness = -10000.0;
    double fitnessMax = 100.0;
    JFrame agentFrame = new JFrame();
    JPanel agentsPan = new JPanel();
    Hashtable<GTurtle, Genome> agentGenome = new Hashtable();

    public void setManagerAttributes(XMLAttributes xMLAttributes) {
        this.attrib = xMLAttributes;
    }

    public void clear() {
        this.monitoredAgents.clear();
        this.agentGenome.clear();
    }

    public void update(int n) {
        System.out.println(this.attrib.getString("Name") + " activated at step: " + n);
        if (this.refreshDisplay && this.attrib.containsKey("Display") && this.attrib.getBool("Display")) {
            this.createFrame();
            this.refreshDisplay = false;
        }
    }

    @Override
    public synchronized void watch() {
    }

    public void setFitnessTo(GTurtle gTurtle, double d) {
        for (int i = 0; i < this.monitoredAgents.size(); ++i) {
            if (!((Object)((Object)this.monitoredAgents.get(i))).equals((Object)gTurtle)) continue;
            this.monitoredAgents.get(i).getGenome().setFitness(d);
        }
    }

    public void createFrame() {
        String string = "FitnessManager";
        if (this.getAttrib().containsKey("Name")) {
            string = this.getAttrib().getString("Name");
        }
        this.agentFrame.setTitle(string);
        this.agentFrame.setSize(650, 300);
        this.agentsPan.removeAll();
        this.agentsPan.setLayout(new GridLayout(this.monitoredAgents.size(), 3, 25, 5));
        for (int i = 0; i < this.monitoredAgents.size(); ++i) {
            ExtendedJButton extendedJButton = new ExtendedJButton(this.monitoredAgents.get(i).getName(), this.monitoredAgents.get(i).getGenome(), i);
            extendedJButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Manager.this.monitoredAgents.get(((ExtendedJButton)actionEvent.getSource()).getIndex()).createFrame();
                }
            });
            JLabel jLabel = new JLabel("Tmp");
            JLabel jLabel2 = new JLabel(this.monitoredAgents.get(i).getGenome().toString());
            this.agentsPan.add(extendedJButton);
            this.agentsPan.add(jLabel);
            this.agentsPan.add(jLabel2);
        }
        this.agentFrame.getContentPane().add((Component)this.agentsPan, "Center");
    }

    public void setFitnessToAll(double d) {
        for (int i = 0; i < this.monitoredAgents.size(); ++i) {
            this.note(this.monitoredAgents.get(i), d);
        }
    }

    public void note(GTurtle gTurtle, double d) {
        double d2 = d / this.getFitnessMax() * 100.0;
        this.agentGenome.get((Object)gTurtle).setFitness(this, d2);
    }

    public void noteAll(int n) {
        for (int i = 0; i < this.getMonitoredAgents().size(); ++i) {
            GTurtle gTurtle = this.getMonitoredAgents().get(i);
            this.note(gTurtle, n);
        }
    }

    public void addAgentToMonitor(GTurtle gTurtle, Genome genome) {
        this.monitoredAgents.add(gTurtle);
        this.agentGenome.put(gTurtle, genome);
        this.refreshDisplay = true;
    }

    public String toString() {
        return this.attrib.toString();
    }

    public double getFitnessMax() {
        return this.fitnessMax;
    }

    public void setFitnessMax(double d) {
        this.fitnessMax = d;
    }

    public ArrayList<GTurtle> getMonitoredAgents() {
        return this.monitoredAgents;
    }

    public void setMonitoredAgents(ArrayList<GTurtle> arrayList) {
        this.monitoredAgents = arrayList;
    }

    public MetaManager getMetaManager() {
        return this.metaManager;
    }

    public void setMetaManager(MetaManager metaManager) {
        this.metaManager = metaManager;
    }
}

