/*
 * Decompiled with CFR 0.152.
 */
package turtlekit2.genetic;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.JLabel;
import javax.swing.JPanel;
import madkit.boot.Madkit;
import turtlekit2.genetic.Gene;
import turtlekit2.genetic.GenomeGUI;
import turtlekit2.genetic.Manager;
import turtlekit2.kernel.XMLAttributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Genome
extends ArrayList<Gene>
implements Serializable {
    static final int WAITING = -1;
    static final int ACTIVATED = 0;
    transient GenomeGUI myGui = null;
    transient JLabel fitnessLabel = null;
    int state = -1;
    transient Hashtable<Object, Double> managerTable = new Hashtable();
    double fitness = 0.0;
    String poolName;

    public void add(XMLAttributes xMLAttributes) {
        try {
            int n = xMLAttributes.getInt("NbGenes");
            System.out.println("Creating " + n + " " + xMLAttributes);
            String string = xMLAttributes.getString("GeneClass");
            Class clazz = Madkit.getClassLoader().loadClass(string);
            for (int i = 0; i < n; ++i) {
                Gene gene = (Gene)clazz.newInstance();
                gene.setAttrib(xMLAttributes);
                gene.init();
                this.add(0, gene);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("Genome: gene class not found !\n" + classNotFoundException);
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println("Genome: gene class access problem !\n" + illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            System.err.println("Genome: gene instantiation problem !\n" + instantiationException);
        }
    }

    @Override
    public boolean add(Gene gene) {
        boolean bl = super.add(gene);
        this.refreshGui();
        return bl;
    }

    public void init() {
        this.state = -1;
    }

    public void reset() {
        this.setFitness(0.0);
        this.state = -1;
        for (int i = 0; i < this.size(); ++i) {
            if (((Gene)this.get(i)).isFixed()) continue;
            ((Gene)this.get(i)).init();
        }
        this.refreshGui();
    }

    @Override
    public Object clone() {
        Genome genome = (Genome)super.clone();
        genome.clear();
        for (int i = 0; i < this.size(); ++i) {
            genome.add(i, (Gene)((Gene)this.get(i)).clone());
        }
        if (this.fitnessLabel != null) {
            genome.setFitnessLabel(new JLabel(new Double(this.fitness).toString()));
        }
        if (this.myGui != null) {
            genome.setMyGui(new GenomeGUI(genome));
        }
        return genome;
    }

    public void evaluateFitness() {
        this.fitness = 0.0;
        if (this.managerTable.size() > 0) {
            for (Double d : this.managerTable.values()) {
                this.fitness += d.doubleValue();
            }
            this.fitness /= (double)this.managerTable.size();
        }
        this.refreshFitnessLabel();
    }

    @Override
    public String toString() {
        String string = "Pool: " + this.poolName + "\n";
        string = string + " fitness " + this.fitness + "\n";
        for (int i = 0; i < this.size(); ++i) {
            string = string + "Gene " + i + ": " + this.get(i);
        }
        return string;
    }

    public Gene get(String string) {
        for (int i = 0; i < this.size(); ++i) {
            if (!((Gene)this.get(i)).getName().equals(string)) continue;
            return (Gene)this.get(i);
        }
        return (Gene)this.get(0);
    }

    public ArrayList<? extends Gene> getAll(String string) {
        ArrayList<Gene> arrayList = new ArrayList<Gene>();
        for (Gene gene : this) {
            if (!string.equals(gene.getName())) continue;
            arrayList.add(gene);
        }
        return arrayList;
    }

    public void setFitness(Manager manager, double d) {
        this.managerTable.put((Object)manager, new Double(d));
        this.evaluateFitness();
    }

    public void setHadocFitness(double d) {
        this.managerTable.put("user", new Double(d));
        this.evaluateFitness();
    }

    public int getNbGenes() {
        return this.size();
    }

    public int getSize() {
        return this.size();
    }

    public double getFitness() {
        return this.fitness;
    }

    public void setFitness(double d) {
        this.fitness = d;
        this.refreshFitnessLabel();
    }

    public Gene getGene(int n) {
        return (Gene)this.get(n);
    }

    public String getPoolName() {
        return this.poolName;
    }

    public void setPoolName(String string) {
        this.poolName = string;
    }

    public String shortToString() {
        String string = "";
        for (int i = 0; i < this.size(); ++i) {
            string = string + "[" + ((Gene)this.get(i)).getAttrib().getString("GeneClass") + "]   ";
        }
        return string;
    }

    public int getState() {
        return this.state;
    }

    public void setState(int n) {
        this.state = n;
        this.refreshGui();
    }

    public void refreshGui() {
        if (this.myGui != null) {
            this.myGui.refresh();
        }
    }

    public void refreshFitnessLabel() {
        if (this.fitnessLabel != null) {
            this.fitnessLabel.setText(new Double(this.fitness).toString());
        }
    }

    public JLabel getFitnessLabel() {
        if (this.fitnessLabel == null) {
            this.fitnessLabel = new JLabel(new Double(this.fitness).toString());
        }
        return this.fitnessLabel;
    }

    public JPanel getPanel() {
        if (this.myGui == null) {
            this.myGui = new GenomeGUI(this);
        }
        return this.myGui;
    }

    public void setFitnessLabel(JLabel jLabel) {
        this.fitnessLabel = jLabel;
    }

    public void setMyGui(GenomeGUI genomeGUI) {
        this.myGui = genomeGUI;
    }

    public boolean isEqual(Genome genome) {
        for (int i = 0; i < this.size(); ++i) {
            if (((Gene)this.get(i)).isEqual((Gene)genome.get(i))) continue;
            return false;
        }
        return true;
    }
}

