/*
 * Decompiled with CFR 0.152.
 */
package turtlekit2.genetic;

import java.util.Random;
import turtlekit2.genetic.Gene;
import turtlekit2.genetic.Genome;
import turtlekit2.genetic.Pool;

public class EvolutionManager {
    static final int WAITING = -1;
    static final int ACTIVATED = 0;
    static final int PARENT = 1;
    int appels = 0;
    Pool managedPool = null;
    Random randomizer = new Random();
    Pool parents = new Pool();
    Pool children = new Pool();
    Pool elites = new Pool();

    public EvolutionManager() {
    }

    public EvolutionManager(Pool pool) {
        this.managedPool = pool;
    }

    public void reproduce(Pool pool) {
        ++this.appels;
        if (pool.size() > 1) {
            System.out.println("Reproduction " + this.appels);
            this.managedPool = pool;
            this.rouletteWheelSelection();
            this.reproduction();
        } else {
            System.out.println("no reproduction with 1 genome");
        }
    }

    public void rouletteWheelSelection() {
        int n;
        this.managedPool.fitSortDesc();
        double d = 0.0;
        int n2 = 0;
        for (n = 0; n < this.managedPool.size(); ++n) {
            d += ((Genome)this.managedPool.get(n)).getFitness();
        }
        block1: while (n2 < this.managedPool.size() / 2) {
            double d2 = this.randomizer.nextDouble();
            double d3 = 0.0;
            for (int i = 0; i < this.managedPool.size(); ++i) {
                if (!((d3 += ((Genome)this.managedPool.get(i)).getFitness() / d) >= d2)) continue;
                if (((Genome)this.managedPool.get(i)).getState() != 1) {
                    ++n2;
                }
                ((Genome)this.managedPool.get(i)).setState(1);
                continue block1;
            }
        }
        this.parents.clear();
        this.elites.clear();
        for (n = 0; n < this.managedPool.size(); ++n) {
            if (n == 0) {
                this.elites.add((Genome)this.managedPool.get(n));
            }
            if (((Genome)this.managedPool.get(n)).getState() != 1) continue;
            this.parents.add((Genome)this.managedPool.get(n));
        }
        System.out.println("Roulette Wheel Selection done.");
    }

    public void reproduction() {
        Genome genome;
        int n;
        int n2;
        int n3;
        this.children.clear();
        System.out.println(" ******* BEST GENOME ****** " + ((Genome)this.managedPool.get(0)).toString());
        for (n3 = 0; n3 < this.parents.size(); ++n3) {
            n2 = this.randomizer.nextInt(this.parents.size());
            n = this.randomizer.nextInt(this.parents.size());
            genome = (Genome)this.parents.get(n);
            Genome genome2 = (Genome)this.parents.get(n2);
            Genome genome3 = (Genome)genome.clone();
            for (int i = 0; i < genome.size(); ++i) {
                Gene gene = (Gene)genome.get(i);
                Gene gene2 = (Gene)genome2.get(i);
                if (gene.isFixed()) {
                    genome3.set(i, (Gene)gene.clone());
                    ((Gene)genome3.get(i)).setFixed(true);
                    continue;
                }
                ((Gene)genome3.get(i)).cross(gene, gene2);
            }
            genome3.setState(-1);
            genome3.setFitness(-1.0);
            this.children.add(genome3);
        }
        n3 = this.managedPool.size();
        this.managedPool.clear();
        this.managedPool.addAll(this.elites);
        System.out.println("**APRES ELITE** " + this.managedPool.size());
        for (n2 = 0; n2 < this.managedPool.size(); ++n2) {
            for (n = 0; n < this.parents.size(); ++n) {
                if (!this.managedPool.getGenome(n2).isEqual(this.parents.getGenome(n))) continue;
                this.parents.remove(n);
                --n;
            }
        }
        while (this.parents.size() >= n3 / 2) {
            this.parents.remove(this.parents.size() - 1);
        }
        this.managedPool.addAll(this.parents);
        for (n2 = 0; n2 < this.managedPool.size(); ++n2) {
            this.managedPool.getGenome(n2).setState(0);
            for (n = 0; n < this.children.size(); ++n) {
                genome = (Genome)this.children.get(n2);
                for (int i = 0; i < genome.size(); ++i) {
                    if (((Gene)genome.get(i)).isFixed()) continue;
                    ((Gene)genome.get(i)).mutate();
                }
                if (!this.managedPool.getGenome(n2).isEqual(this.children.getGenome(n))) continue;
                this.children.getGenome(n).reset();
            }
        }
        this.managedPool.addAll(this.children);
    }

    public void crossGenes1() {
        this.managedPool.fitSortDesc();
        System.out.println(" ******* BEST GENOME ****** " + ((Genome)this.managedPool.get(0)).toString());
        for (int i = 0; i < this.managedPool.size() / 2; ++i) {
            Genome genome = (Genome)this.managedPool.get(i);
            int n = this.managedPool.randomizer.nextInt(this.managedPool.size() / 2);
            Genome genome2 = (Genome)this.managedPool.get(n);
            Genome genome3 = (Genome)this.managedPool.get(i + this.managedPool.size() / 2);
            for (int j = 0; j < genome.size(); ++j) {
                Gene gene = (Gene)genome.get(j);
                Gene gene2 = (Gene)genome2.get(j);
                if (gene.isFixed()) {
                    genome3.set(j, (Gene)gene.clone());
                    ((Gene)genome3.get(j)).setFixed(true);
                    continue;
                }
                ((Gene)genome3.get(j)).cross(gene, gene2);
            }
        }
    }

    public void crossGenes2() {
        this.managedPool.fitSortDesc();
        System.out.println(" ******* BEST GENOME ****** " + ((Genome)this.managedPool.get(0)).toString());
        for (int i = 0; i < this.managedPool.size() / 2; ++i) {
            Genome genome = (Genome)this.managedPool.get(i);
            int n = this.managedPool.randomizer.nextInt(this.managedPool.size() / 2);
            Genome genome2 = (Genome)this.managedPool.get(n);
            Genome genome3 = (Genome)this.managedPool.get(i + this.managedPool.size() / 2);
            for (int j = 0; j < genome.size(); ++j) {
                Gene gene = (Gene)genome.get(j);
                Gene gene2 = (Gene)genome2.get(j);
                if (gene.isFixed()) {
                    genome3.set(j, (Gene)gene.clone());
                    ((Gene)genome3.get(j)).setFixed(true);
                    continue;
                }
                ((Gene)genome3.get(j)).cross(gene, gene2);
            }
        }
    }

    public void setManagedPool(Pool pool) {
        this.managedPool = pool;
    }
}

