/*
 * Decompiled with CFR 0.152.
 */
package warbot.kernel;

import SEdit.SNode;
import SEdit.Structure;
import java.util.Vector;
import madkit.kernel.AbstractAgent;
import madkit.kernel.AgentAddress;
import madkit.kernel.GroupIdentifier;
import madkit.kernel.Message;
import madkit.messages.ACLMessage;
import warbot.kernel.BasicBody;
import warbot.kernel.Entity;
import warbot.kernel.MapViewer;
import warbot.kernel.WarbotEnvironment;
import warbot.kernel.WarbotIdentifier;
import warbot.kernel.WarbotScheduler;

public class WarbotStructure
extends Structure {
    static int cpt = 1;
    AgentAddress schedulerAgent;
    WarbotScheduler scheduler;
    WarbotEnvironment warbotWorld;
    static String groupGenerator = "warbot";
    String simulationGroup = "WarbotApp";
    Entity lastEntity = null;
    int worldWidth = 800;
    int worldHeight = 800;
    boolean isDetecting = false;
    boolean isShowUserMessage = true;
    boolean isShowMessages = true;

    Entity getLastEntity() {
        return this.lastEntity;
    }

    public void setWorldWidth(int n) {
        this.worldWidth = n;
    }

    public int getWorldWidth() {
        return this.worldWidth;
    }

    public void setWorldHeight(int n) {
        this.worldHeight = n;
    }

    public int getWorldHeight() {
        return this.worldHeight;
    }

    public void preactivate() {
        System.out.println("\nLAUNCHING WARBOT......      ");
        System.out.println("Warbot " + WarbotScheduler.VERSION + "  " + WarbotScheduler.DATE);
        System.out.println("by " + WarbotScheduler.AUTHOR);
        System.out.println("(C) Madkit Team - 2002");
        if (this.agent.isGroup(this.simulationGroup)) {
            this.simulationGroup = groupGenerator + "-" + ++cpt;
        }
        this.agent.createGroup(false, this.simulationGroup, null, (GroupIdentifier)new WarbotIdentifier());
        this.agent.requestRole(this.simulationGroup, "mainpanel", (Object)WarbotIdentifier.password);
        if (this.scheduler == null) {
            this.scheduler = new WarbotScheduler(this, this.simulationGroup);
            this.warbotWorld = new WarbotEnvironment(this, this.getWorldWidth(), this.getWorldHeight(), this.simulationGroup);
            this.scheduler.setEnvironment(this.warbotWorld);
            this.agent.launchAgent((AbstractAgent)this.scheduler, "warbot scheduler", false);
            this.agent.pause(500);
            this.agent.launchAgent((AbstractAgent)this.warbotWorld, "warbotWorld", false);
            this.schedulerAgent = this.scheduler.getAddress();
        }
    }

    public void activate() {
        for (SNode sNode : this.getNodes()) {
            Entity entity;
            if (!(sNode instanceof Entity) || this.warbotWorld.contains(entity = (Entity)sNode)) continue;
            this.warbotWorld.addEntity(entity);
        }
    }

    public void addNode(SNode sNode) {
        super.addNode(sNode);
        this.lastEntity = (Entity)sNode;
        this.lastEntity.setSimulationGroup(this.simulationGroup);
        if (this.warbotWorld != null) {
            this.warbotWorld.addEntity(this.lastEntity);
        }
    }

    public void addNode(SNode sNode, String string) {
        super.addNode(sNode, string);
        this.lastEntity = (Entity)sNode;
        this.lastEntity.setSimulationGroup(this.simulationGroup);
        if (this.warbotWorld != null) {
            this.warbotWorld.addEntity(this.lastEntity);
        }
    }

    public void end() {
        this.warbotWorld.deleteEntities();
        this.agent.killAgent((AbstractAgent)this.scheduler);
        System.out.println("deleting the world");
        this.agent.killAgent((AbstractAgent)this.warbotWorld);
    }

    public void mapViewer() {
        int n;
        int n2 = this.getWorldWidth() + 30;
        int n3 = this.getWorldHeight() + 30;
        for (n = 1; n < 100 && (n2 / n >= 500 || n3 / n >= 500); ++n) {
        }
        MapViewer mapViewer = new MapViewer(n2 / n, n3 / n, n, this.simulationGroup);
        this.agent.launchAgent((AbstractAgent)mapViewer, "map viewer", true);
        mapViewer.observe();
    }

    public void showDetect() {
        this.isDetecting = !this.isDetecting;
        Vector vector = this.getNodes();
        for (SNode sNode : vector) {
            if (!(sNode instanceof BasicBody)) continue;
            ((BasicBody)sNode).setShowDetect(this.isDetecting);
        }
    }

    public void showUserMessage() {
        this.isShowUserMessage = !this.isShowUserMessage;
        Vector vector = this.getNodes();
        for (SNode sNode : vector) {
            if (!(sNode instanceof BasicBody)) continue;
            ((BasicBody)sNode).setShowUserMessage(this.isShowUserMessage);
        }
    }

    public void showMessages() {
        this.isShowMessages = !this.isShowMessages;
        Vector vector = this.getNodes();
        for (SNode sNode : vector) {
            if (!(sNode instanceof BasicBody)) continue;
            ((BasicBody)sNode).setShowMessages(this.isShowMessages);
        }
    }

    public void start() {
        System.out.println("starting..");
        this.agent.sendMessage(this.schedulerAgent, (Message)new ACLMessage("START"));
    }

    public void stop() {
        this.agent.sendMessage(this.schedulerAgent, (Message)new ACLMessage("STOP"));
    }

    public void step() {
        this.agent.sendMessage(this.schedulerAgent, (Message)new ACLMessage("STEP"));
    }
}

