/*
 * Decompiled with CFR 0.152.
 */
package warbot.kernel;

import madkit.kernel.Activator;
import madkit.kernel.Message;
import madkit.kernel.Scheduler;
import madkit.messages.ACLMessage;
import madkit.simulation.activators.TurboMethodActivator;
import warbot.kernel.BrainActivator;
import warbot.kernel.TopMessage;
import warbot.kernel.WarbotEnvironment;
import warbot.kernel.WarbotIdentifier;
import warbot.kernel.WarbotStructure;

public final class WarbotScheduler
extends Scheduler {
    public static String VERSION = "2.1b3-d1";
    public static String AUTHOR = "Fabien MICHEL, Jacques FERBER";
    public static String DATE = "10/02/2002";
    String simulationGroup;
    private TurboMethodActivator observers;
    private BrainActivator theAgents;
    private int delay = 16;
    private boolean running = false;
    private float displaySpeed = 1.0f;
    private WarbotEnvironment warbotWorld;
    WarbotStructure theStructure;
    private int nsteps = -1;
    private long cycleNumber = 0L;

    public long getCycleNumber() {
        return this.cycleNumber;
    }

    public void setRunning(boolean bl) {
        this.running = bl;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setEnvironment(WarbotEnvironment warbotEnvironment) {
        this.warbotWorld = warbotEnvironment;
    }

    WarbotScheduler(WarbotStructure warbotStructure, String string) {
        this.simulationGroup = string;
        this.theStructure = warbotStructure;
    }

    private void setDelay(int n) {
        this.delay = this.delay < 1 ? 1 : n;
        System.out.println("delay: " + this.delay);
    }

    public void activate() {
        this.requestRole(this.simulationGroup, "scheduler", WarbotIdentifier.password);
        this.theAgents = new BrainActivator(this.simulationGroup);
        this.addActivator(this.theAgents, WarbotIdentifier.password);
        this.observers = new TurboMethodActivator("observe", this.simulationGroup, "observer");
        this.addActivator((Activator)this.observers, WarbotIdentifier.password);
        this.println("Scheduler is activated");
    }

    public void live() {
        this.observers.execute();
        Thread.currentThread().setPriority(10);
        while (true) {
            Message message;
            if (this.running) {
                ++this.cycleNumber;
                message = this.nextMessage();
                if (message != null) {
                    this.checkMail(message);
                }
                this.pause(this.delay);
                this.theAgents.executeBrains();
                this.warbotWorld.moveWorld();
                if (Math.random() < (double)this.displaySpeed) {
                    this.observers.execute();
                }
                this.theStructure.getEditor().repaint();
                this.warbotWorld.checkMail();
                if (this.nsteps <= 0) continue;
                --this.nsteps;
                if (this.nsteps > 0) continue;
                this.setRunning(false);
                this.theStructure.getEditor().repaint();
                this.nsteps = -1;
                continue;
            }
            this.pause(200);
            this.observers.execute();
            message = this.waitNextMessage();
            this.checkMail(message);
            this.warbotWorld.checkMail();
        }
    }

    public void end() {
        System.out.println("removing the activators");
        this.removeActivator(this.theAgents);
        this.removeActivator((Activator)this.observers);
        System.out.println("scheduler is dying");
    }

    private void checkMail(Message message) {
        if (message instanceof ACLMessage) {
            String string = ((ACLMessage)message).getAct();
            if (string.equalsIgnoreCase("STOP")) {
                this.setRunning(false);
            } else if (string.equalsIgnoreCase("START")) {
                this.setRunning(true);
            } else if (string.equalsIgnoreCase("STEP")) {
                this.setRunning(true);
                this.nsteps = 1;
            }
        } else if (message instanceof TopMessage) {
            TopMessage topMessage = (TopMessage)message;
            if (this.running) {
                if (topMessage.getContent() == -4) {
                    this.displaySpeed /= 2.0f;
                    return;
                }
                if (topMessage.getContent() == -1) {
                    this.displaySpeed = 1.0f;
                    return;
                }
                if (topMessage.getContent() == -3) {
                    this.running = false;
                } else if (topMessage.getContent() >= 0) {
                    this.setDelay(topMessage.getContent());
                    return;
                }
            } else {
                if (topMessage.getContent() >= 0) {
                    this.setDelay(topMessage.getContent());
                    return;
                }
                if (topMessage.getContent() == -4) {
                    this.running = true;
                    this.displaySpeed /= 2.0f;
                    return;
                }
                if (topMessage.getContent() == -1) {
                    this.running = true;
                    this.displaySpeed = 1.0f;
                    return;
                }
            }
        }
    }
}

