/*
 * Decompiled with CFR 0.152.
 */
package warbot.kernel;

import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import madkit.kernel.AbstractAgent;
import madkit.kernel.Agent;
import madkit.kernel.AgentAddress;
import madkit.kernel.Controller;
import madkit.kernel.Message;
import madkit.kernel.OPanel;
import madkit.messages.ControlMessage;
import madkit.system.EditorAgent;
import madkit.utils.agents.LanguageController;
import warbot.kernel.Brain;

public abstract class ScriptedBrain
extends Brain {
    PrintWriter out;
    PrintWriter err;

    PrintWriter getOut() {
        return this.out;
    }

    PrintWriter getErr() {
        return this.err;
    }

    public void initGUI() {
        OPanel oPanel = new OPanel();
        this.setGUIObject(oPanel);
        this.out = new PrintWriter(oPanel.getOut());
        this.err = new PrintWriter(oPanel.getOut());
    }

    public void println(String string) {
        if (this.out != null) {
            this.out.println(string);
        } else {
            super.println(string);
        }
    }

    public void doIt() {
        this.getController().doIt();
    }

    public void edit() {
        Controller controller = this.getController();
        if (!(controller instanceof LanguageController)) {
            System.out.println("Scripted brain not editable...");
            return;
        }
        String string = ((LanguageController)controller).getBehaviorFile();
        System.out.println("Editing : " + string);
        EditorAgent editorAgent = null;
        AgentAddress agentAddress = this.getAgentWithRole("system", "editor");
        System.out.println("Editor: " + agentAddress);
        if (agentAddress != null) {
            System.out.println("Sending message to " + agentAddress);
            this.sendMessage(agentAddress, (Message)new ControlMessage("edit", string));
        } else {
            try {
                Class<?> clazz = Class.forName("jsynedit.JSynEditAgent");
                System.out.println("classe: " + clazz);
                Object[] objectArray = new Class[]{String.class};
                Constructor<?> constructor = clazz.getConstructor((Class<?>[])objectArray);
                System.out.println("cons: " + constructor);
                editorAgent = (Agent)constructor.newInstance(objectArray);
                System.out.println("ed: " + editorAgent);
                this.launchAgent((AbstractAgent)editorAgent, "Edit : " + string, true);
            }
            catch (Exception exception) {
                System.out.println("JSynEdit : " + string);
                editorAgent = new EditorAgent(string);
                this.launchAgent((AbstractAgent)editorAgent, "Edit : " + string, true);
            }
        }
    }
}

