/*
 * Decompiled with CFR 0.152.
 */
package warbot.kernel;

import java.awt.Color;
import java.awt.Graphics;
import warbot.kernel.AbstractViewer;
import warbot.kernel.AwtGridCanvas;
import warbot.kernel.BasicBody;
import warbot.kernel.Entity;
import warbot.kernel.Home;
import warbot.kernel.Wall;

public final class MapViewer
extends AbstractViewer {
    int width = 500;
    int height = 500;
    int ratio = 1;

    MapViewer(int n, int n2, int n3, String string) {
        super(string);
        this.width = n + 5;
        this.height = n2 + 25;
        this.ratio = n3;
    }

    MapViewer(String string) {
        super(string);
    }

    public void initGUI() {
        this.onScreen = new AwtGridCanvas(this.width, this.height, this);
        this.setGUIObject(this.onScreen);
    }

    void paintEntities(Graphics graphics) {
        graphics.setColor(Color.black);
        graphics.drawLine(0, 0, this.width, 0);
        graphics.drawLine(this.width - 1, 0, this.width - 1, this.height - 1);
        graphics.drawLine(this.width - 1, this.height - 1, 0, this.height - 1);
        graphics.drawLine(0, this.height - 1, 0, 0);
        this.entities = this.world.getAllEntities();
        if (this.entities != null) {
            this.nEntities = this.entities.length;
            this.nBasicBodies = 0;
            graphics.setColor(Color.red);
            for (int i = 0; i < this.entities.length; ++i) {
                Entity entity = this.entities[i];
                if (entity instanceof BasicBody) {
                    if (entity.getTeam().equals("green")) {
                        graphics.setColor(Color.green);
                    } else {
                        graphics.setColor(Color.red);
                    }
                    ++this.nBasicBodies;
                } else {
                    graphics.setColor(Color.black);
                }
                int n = entity.getRadius() / this.ratio;
                if (entity instanceof Home || entity instanceof Wall) {
                    graphics.fillOval((entity.xcor() - entity.getRadius()) / this.ratio + 5, (entity.ycor() - entity.getRadius()) / this.ratio + 5, n, n);
                    continue;
                }
                graphics.drawOval((entity.xcor() - entity.getRadius()) / this.ratio + 5, (entity.ycor() - entity.getRadius()) / this.ratio + 5, n, n);
            }
        }
    }

    public void observe() {
        this.checkMail();
        if (this.show) {
            if (this.swing) {
                this.onScreen.repaint();
            } else {
                ((AwtGridCanvas)this.onScreen).display();
            }
        }
    }
}

