/*
 * Decompiled with CFR 0.152.
 */
package madkit.netcomm.rules;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import madkit.netcomm.KnownProtocols;
import madkit.netcomm.rules.NetCommResolver;
import madkit.netcomm.rules.Rule;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class ConnectionRules {
    private Rule defaultRule = new Rule(".*", 0, null);
    private static ConnectionRules INSTANCE = new ConnectionRules();
    private Collection rules;

    public ConnectionRules() {
        this(0, null, new Vector());
    }

    public ConnectionRules(int n, Object object) {
        this(n, object, new Vector());
    }

    public ConnectionRules(Collection collection) {
        this(0, null, collection);
    }

    public ConnectionRules(int n, Object object, Collection collection) {
        this.rules = collection;
        this.setDefaultConnectionRuleAction(n, object);
        this.loadRules();
    }

    public void setDefaultConnectionRuleAction(int n, Object object) {
        Rule rule;
        this.defaultRule = rule = new Rule(".*", n, object);
    }

    public Rule getDefaultConnectionRule() {
        return this.defaultRule;
    }

    public Rule getRule(String string) {
        for (Rule rule : this.rules) {
            if (!rule.matches(string)) continue;
            return rule;
        }
        return this.defaultRule;
    }

    private void loadRules() {
        String string = System.getProperty("madkit.netcomm.rules");
        if (string != null) {
            File file = new File(string);
            if (file.exists() && file.canRead()) {
                this.debug("Loading Rules");
                if (!this.loadXMLRules(file)) {
                    this.debug("Impossible to load Rules");
                }
            } else {
                this.debug("File " + file + " could not be opened." + System.getProperty("line.separator") + " Please check that the file defined in madkit.netcomm.rules exists and has read permissions");
            }
        }
    }

    private boolean loadXMLRules(File file) {
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            documentBuilder.setEntityResolver(new NetCommResolver());
            Document document = documentBuilder.parse(file);
            NodeList nodeList = document.getElementsByTagName("defaultrule");
            if (nodeList.getLength() > 1) {
                this.debug("The connection rule file must contain only one defaultrule");
                return false;
            }
            Element element = (Element)nodeList.item(0);
            int n = this.string2Action(element.getAttribute("action"));
            Object object = this.createProperArgument(element, n);
            nodeList = document.getElementsByTagName("rule");
            Vector<Rule> vector = new Vector<Rule>();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Rule rule = this.handleNode((Element)nodeList.item(i));
                vector.add(rule);
            }
            this.setDefaultConnectionRuleAction(n, object);
            this.rules = (Collection)vector.clone();
            return true;
        }
        catch (SAXException sAXException) {
        }
        catch (IOException iOException) {
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            // empty catch block
        }
        return false;
    }

    private void debug(String string) {
        System.err.println(string);
    }

    private Rule handleNode(Element element) {
        int n = this.string2Action(element.getAttribute("action"));
        String string = element.getAttribute("match");
        Object object = this.createProperArgument(element, n);
        Rule rule = new Rule(string, n, object);
        return rule;
    }

    private Object createProperArgument(Element element, int n) {
        Object object = null;
        switch (n) {
            case 2: {
                object = element.getAttribute("arg");
                break;
            }
            case 0: {
                object = this.parseProtocols(element.getAttribute("arg"));
                break;
            }
        }
        return object;
    }

    private Collection parseProtocols(String string) {
        if (string.equalsIgnoreCase("")) {
            return null;
        }
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":", false);
        while (stringTokenizer.hasMoreTokens()) {
            String string2;
            Collection collection = KnownProtocols.getProtocols();
            if (!collection.contains(string2 = stringTokenizer.nextToken())) continue;
            vector.add(string2);
        }
        if (vector.size() > 0) {
            return vector;
        }
        return null;
    }

    public static ConnectionRules getInstance() {
        return INSTANCE;
    }

    private int string2Action(String string) {
        int n = -1;
        if (string.equalsIgnoreCase("accept")) {
            n = 0;
        } else if (string.equalsIgnoreCase("refuse")) {
            n = 2;
        } else if (string.equalsIgnoreCase("reject")) {
            n = 1;
        }
        return n;
    }

    public void printRules() {
        System.out.println("ConnectionRules");
        System.out.println("=================");
        System.out.println("Default :" + this.defaultRule.toString());
        System.out.println("others:");
        int n = 0;
        for (Rule rule : this.rules) {
            System.out.println("rule " + n + " " + rule.toString());
            ++n;
        }
    }
}

