/*
 * Decompiled with CFR 0.152.
 */
package madkit.netcomm;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import madkit.kernel.AbstractAgent;
import madkit.netcomm.MadkitNetworkAgent;
import madkit.netcomm.NetConfigAgent;
import madkit.netcomm.NetworkMessage;
import madkit.netcomm.SocketKernel;

class TCPServerAgent
extends MadkitNetworkAgent {
    private final SocketKernel myInfo;
    private ServerSocket server;
    private boolean alive = true;

    public TCPServerAgent(int n) {
        this.myInfo = this.createServer(n);
    }

    private SocketKernel createServer(int n) {
        boolean bl = false;
        while (!bl) {
            try {
                this.server = new ServerSocket(n);
                bl = true;
                break;
            }
            catch (IOException iOException) {
                ++n;
            }
        }
        return new SocketKernel(n);
    }

    public void live() {
        while (this.alive) {
            try {
                Socket socket = this.server.accept();
                this.exitImmediatlyOnKill();
                if (!this.alive) break;
                this.launchAgent((AbstractAgent)new NetConfigAgent(socket, this.myInfo, null), "configAgent", false);
            }
            catch (IOException iOException) {}
        }
    }

    public void activate() {
        this.requestRole(community, "networking", "tcpsserveragent", memberCard);
    }

    public void end() {
        try {
            this.server.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.debug("IOException caught : " + iOException.getMessage());
        }
    }

    public SocketKernel getSocketKernel() {
        return this.myInfo;
    }

    protected void handleNetworkMessage(NetworkMessage networkMessage) {
    }
}

