/*
 * Decompiled with CFR 0.152.
 */
package madkit.netcomm;

import madkit.kernel.Message;
import madkit.netcomm.MadkitNetworkAgent;
import madkit.netcomm.NetConfigMessage;
import madkit.netcomm.NetworkMessage;
import madkit.netcomm.StatsAgentGUI;

class StatsAgent
extends MadkitNetworkAgent {
    public static final long DEFAULT_SAMPLE_PERIOD = 400L;
    private boolean alive = true;
    private long samplePeriod = 400L;
    private boolean sample = NetConfigMessage.isEnableStat();
    private StatsAgentGUI gui = null;

    public StatsAgent(boolean bl) {
        this.sample = bl;
    }

    protected void handleNetworkMessage(NetworkMessage networkMessage) {
    }

    protected void handleConfigMessage(NetConfigMessage netConfigMessage) {
        this.setDebug(NetConfigMessage.isDebug());
        this.sample = NetConfigMessage.isEnableStat();
        this.samplePeriod = NetConfigMessage.getSamplePeriod();
    }

    public void activate() {
        super.activate();
        this.requestRole(community, "networking", "statistics", null);
        if (!this.hasGUI() && this.sample) {
            this.redisplayMyGUI();
        }
    }

    public void live() {
        while (this.alive) {
            Message message = this.waitNextMessage(this.samplePeriod);
            this.exitImmediatlyOnKill();
            if (this.sample && this.hasGUI()) {
                this.gui.setReceived(this.getReceivedBytesCount());
                this.gui.setSent(this.getSentBytesCount());
                this.reset();
            }
            if (!(message instanceof NetConfigMessage)) continue;
            this.handleConfigMessage((NetConfigMessage)message);
        }
    }

    public void end() {
        this.leaveRole(community, "networking", "statistics");
    }

    public void initGUI() {
        if (this.gui == null) {
            this.gui = new StatsAgentGUI();
            this.setGUIObject(this.gui);
        }
    }

    long getSamplePeriod() {
        return this.samplePeriod;
    }

    void setSamplePeriod(long l) {
        this.samplePeriod = l;
    }

    void setSample(boolean bl) {
        this.sample = bl;
    }
}

