/*
 * Decompiled with CFR 0.152.
 */
package madkit.netcomm;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Vector;
import madkit.kernel.AbstractAgent;
import madkit.kernel.AgentAddress;
import madkit.kernel.Kernel;
import madkit.kernel.KernelAddress;
import madkit.kernel.KernelMessage;
import madkit.kernel.Message;
import madkit.kernel.NetworkRequest;
import madkit.netcomm.AbstractDynamicConnectionAgent;
import madkit.netcomm.BasicCommAgent;
import madkit.netcomm.Codec;
import madkit.netcomm.DySocketConfigurator;
import madkit.netcomm.DynamicObject;
import madkit.netcomm.InputProcessor;
import madkit.netcomm.NetConfigMessage;
import madkit.netcomm.NetworkMessage;
import madkit.netcomm.SocketKernel;
import madkit.netcomm.handlers.ConnectionHandler;
import madkit.netcomm.handlers.SocketHandler;
import madkit.netcomm.handlers.UnreachableKernel;

class SocketDynamicConnection
extends AbstractDynamicConnectionAgent {
    private static int SERVER_PORT = 22222;
    private int _port = SERVER_PORT;
    private static final int refeshingTime = 100000;
    private static final String REFRESH = "refreshing";
    private static final String DISCONECTION = "DISCONNECTION";
    private static final String START_NORMAL_COMM = "startnormalcomm";
    protected DataOutputStream serverout = null;
    protected DataInputStream serverin = null;
    static final String handledProtocol = "multipleSocketv1";
    static final String ROLE = "multipleSocketv1";
    private InputProcessor input = null;
    private ServerSocket server = null;
    private SocketKernel localSocketKernel;
    private boolean alive = true;
    private Vector _pendingSync = new Vector();

    public SocketDynamicConnection(SocketKernel socketKernel) {
        this.localSocketKernel = socketKernel;
    }

    private void startServer() {
        boolean bl = false;
        while (!bl) {
            try {
                this.server = new ServerSocket(this._port);
                bl = true;
                SERVER_PORT = this._port + 1;
                this.debug("finally listening on " + this._port);
            }
            catch (IOException iOException) {
                ++this._port;
            }
        }
        this.input = new InputProcessor(this);
        this.input.start();
    }

    protected boolean canHandleNormalConnection() {
        return true;
    }

    protected void requestNormalConnection(AgentAddress agentAddress) {
        ConnectionHandler connectionHandler = this.getConnectionHandler(agentAddress.getKernel().getID());
        try {
            Socket socket = ((SocketHandler)connectionHandler).createSocket();
            this.openInputOutputStreams(socket);
            this.sendObject(this.getAddress().getKernel());
            this.sendObject(START_NORMAL_COMM);
            KernelAddress kernelAddress = connectionHandler.getDistantKernel();
            this.launchNormalCommAgent(socket, kernelAddress);
        }
        catch (IOException iOException) {
            this.debug("IOException caught : " + iOException.getMessage());
        }
    }

    private void launchNormalCommAgent(Socket socket, KernelAddress kernelAddress) {
        BasicCommAgent basicCommAgent = new BasicCommAgent(socket, kernelAddress, this._port);
        this.launchAgent((AbstractAgent)basicCommAgent, "basiccommAgent", false);
        Vector<Object> vector = new Vector<Object>();
        vector.add(kernelAddress);
        vector.add(basicCommAgent.getAddress());
        vector.add(basicCommAgent.getProtocol());
        this.sendMessage(this.getAgentWithRole(community, "networking", "router"), new NetworkMessage(11, vector));
    }

    protected void closeSocket() {
        this.debug("calling close socket.. ERROR");
    }

    protected String getProtocol() {
        return "multipleSocketv1";
    }

    protected void handleNetworkMessage(NetworkMessage networkMessage) {
        switch (networkMessage.getType()) {
            case 9: {
                this.informDisconection();
                this.alive = false;
                break;
            }
            case 6: {
                this.sendDistantMessage((Message)networkMessage.getArgument());
                break;
            }
            case 10: {
                this.debug("handling demand!!");
                Vector vector = (Vector)networkMessage.getArgument();
                Socket socket = (Socket)vector.get(0);
                Object e = vector.get(1);
                if (e == null || e instanceof HashSet) {
                    HashSet hashSet = (HashSet)e;
                    if (this.myKernel == null) {
                        this.myKernel = this.getAgentWithRole(Kernel.DEFAULT_COMMUNITY, "communications", "site");
                    }
                    new DySocketConfigurator(this, this._port, this.myKernel, this.localSocketKernel, socket, hashSet).start();
                    break;
                }
                this.debug("Demand malformed");
                break;
            }
            case 1: {
                this.debug("SYNCH_REQUEST_REPLY received");
                this.handlePendingSync(networkMessage);
                break;
            }
            case 12: {
                this.removeConnectionHandler(((KernelAddress)networkMessage.getArgument()).getID());
                break;
            }
        }
    }

    private void informDisconection() {
        Collection<ConnectionHandler> collection = this.getAllHandlers();
        for (ConnectionHandler connectionHandler : collection) {
            this.sendObject(DISCONECTION, connectionHandler);
        }
    }

    private void handlePendingSync(NetworkMessage networkMessage) {
        Vector vector = this.buildSynch('r', (HashSet)networkMessage.getArgument());
        for (int i = 0; i < this._pendingSync.size(); ++i) {
            String string = (String)this._pendingSync.get(i);
            try {
                this.getConnectionHandler(string).sendObject(vector);
            }
            catch (Exception exception) {
                this.debug("Exception caught : " + exception.getMessage());
            }
            this._pendingSync.remove(i);
        }
    }

    public void activate() {
        super.activate();
        if (this.getAgentWithRole(community, "networking", "multipleSocketv1") != null) {
            this.alive = false;
        } else {
            this.requestRole(community, "networking", "multipleSocketv1", memberCard);
            this.startServer();
            AgentAddress agentAddress = this.getAgentWithRole("system", "kernel");
            this.sendMessage(agentAddress, (Message)new KernelMessage(22, 11));
        }
    }

    public void live() {
        while (this.alive) {
            Message message = this.waitNextMessage(100000L);
            this.exitImmediatlyOnKill();
            if (!this.alive) break;
            if (message == null) {
                this.refreshConnections();
                continue;
            }
            if (message instanceof NetworkMessage) {
                this.handleNetworkMessage((NetworkMessage)message);
                continue;
            }
            if (message instanceof NetConfigMessage) {
                this.handleConfigMessage((NetConfigMessage)message);
                continue;
            }
            if (!(message instanceof KernelMessage)) continue;
            this.handleHook((KernelMessage)message);
        }
    }

    private void refreshConnections() {
        Collection<ConnectionHandler> collection = this.getAllHandlers();
        for (ConnectionHandler connectionHandler : collection) {
            this.sendObject(REFRESH, connectionHandler);
        }
    }

    private void sendDistantMessage(Message message) {
        ConnectionHandler connectionHandler = super.getConnectionHandler(message.getReceiver().getKernel().getID());
        if (connectionHandler == null) {
            this.sendDisconnectedKernelInformation(message.getReceiver().getKernel());
        } else {
            this.sendObject(message, connectionHandler);
        }
    }

    private void sendObject(Object object, ConnectionHandler connectionHandler) {
        try {
            connectionHandler.sendObject(object);
        }
        catch (IOException iOException) {
            this.debug("Impossible to send Distant Message : " + iOException.getClass().getName() + " : " + iOException.getMessage() + " removing handler");
            this.removeConnectionHandler(connectionHandler.getDistantKernel().getID());
            this.sendDisconnectedKernelInformation(connectionHandler.getDistantKernel());
            System.gc();
        }
        catch (UnreachableKernel unreachableKernel) {
            this.debug("Impossible to send Distant Message : " + unreachableKernel.getClass().getName() + " : " + unreachableKernel.getMessage() + " removing handler");
            this.removeConnectionHandler(connectionHandler.getDistantKernel().getID());
            this.sendDisconnectedKernelInformation(connectionHandler.getDistantKernel());
            System.gc();
        }
    }

    void receiveIncomming() {
        try {
            Socket socket = this.server.accept();
            this.openServerInputOutputStreams(socket);
            DynamicObject dynamicObject = this.receiveDynamicObject();
            if (dynamicObject == null) {
                return;
            }
            if (dynamicObject.getObject() instanceof Message) {
                this.injectMessage((Message)dynamicObject.getObject());
            } else if (dynamicObject.getObject() instanceof Vector) {
                this.debug("Vector Received! - sync");
                this.requestSynch(dynamicObject);
            } else if (dynamicObject.getObject() instanceof String) {
                if (this.handleDistantInformation(dynamicObject)) {
                    this.launchNormalCommAgent(socket, dynamicObject.getKernelAddress());
                    return;
                }
            } else {
                this.debug("Unknwon object received");
            }
            socket.close();
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.debug("ClassNotFoundException caught : " + classNotFoundException.getMessage());
        }
        catch (IOException iOException) {
            this.debug("IOException caught : " + iOException.getMessage());
        }
    }

    private void openServerInputOutputStreams(Socket socket) {
        try {
            this.serverout = new DataOutputStream(socket.getOutputStream());
            this.serverin = new DataInputStream(new BufferedInputStream(socket.getInputStream()));
        }
        catch (IOException iOException) {
            this.debug("IOException caught : " + iOException.getMessage());
        }
    }

    private boolean handleDistantInformation(DynamicObject dynamicObject) {
        String string = (String)dynamicObject.getObject();
        if (string.equals(DISCONECTION)) {
            this.removeConnectionHandler(dynamicObject.getDistantKernelID());
            this.sendDisconnectedKernelInformation(dynamicObject.getKernelAddress());
        } else if (string.equals(REFRESH)) {
            this.debug(REFRESH);
        } else if (string.equals(START_NORMAL_COMM)) {
            return true;
        }
        return false;
    }

    private DynamicObject receiveDynamicObject() throws IOException, ClassNotFoundException {
        Object object = this.serverReceiveObject();
        if (!(object instanceof KernelAddress)) {
            this.debug("Dynamic Object error... ERROR");
            return null;
        }
        KernelAddress kernelAddress = (KernelAddress)object;
        object = this.serverReceiveObject();
        DynamicObject dynamicObject = new DynamicObject(kernelAddress, object);
        return dynamicObject;
    }

    private Object serverReceiveObject() throws IOException, ClassNotFoundException {
        this.debug("Waiting incomming data");
        int n = this.serverin.readInt();
        this.debug("R:done " + n + " preparing array");
        if (n < 0) {
            return null;
        }
        byte[] byArray = new byte[n];
        this.serverin.readFully(byArray);
        Object object = Codec.decode(byArray);
        this.bytesReceived(n);
        return object;
    }

    private void requestSynch(DynamicObject dynamicObject) {
        Vector vector = (Vector)dynamicObject.getObject();
        Object var3_3 = null;
        Vector vector2 = new Vector();
        Enumeration enumeration = vector.elements();
        String string = (String)enumeration.nextElement();
        AgentAddress agentAddress = (AgentAddress)vector.get(3);
        vector2.add(vector.get(1));
        vector2.add(vector.get(2));
        vector2.add(vector.get(3));
        vector2.add(this.getProtocol());
        vector2.add(vector.get(4));
        if (string.equals("TRANSMIT_SOCKET_INFO")) {
            this.debug("  ---------SocketCom------- TRANSMIT_SOCKET_INFO ---- ");
            this.debug("Adding pending sync");
            this._pendingSync.add(dynamicObject.getDistantKernelID());
            this.sendMessage(community, "networking", "router", new NetworkMessage(0, vector2));
            this.fowardToKernel((Message)new NetworkRequest(3, (Object)agentAddress));
        }
        if (string.equals("ACK_SOCKET_INFO")) {
            this.debug("  ---------SocketCom--------- ACK_SOCKET_INFO ---- ");
            this.sendMessage(community, "networking", "router", new NetworkMessage(0, vector2));
            this.fowardToKernel((Message)new NetworkRequest(3, (Object)agentAddress));
        }
    }

    private Vector buildSynch(char c, HashSet hashSet) {
        Vector<Object> vector = new Vector<Object>();
        if (c == 'c') {
            vector.addElement("TRANSMIT_SOCKET_INFO");
        } else if (c == 'r') {
            vector.addElement("ACK_SOCKET_INFO");
        }
        vector.addElement(this.getAddress().getKernel());
        vector.addElement(this.localSocketKernel);
        vector.addElement(this.myKernel);
        vector.add(hashSet);
        return vector;
    }

    public void end() {
        this.informDisconection();
    }
}

