/*
 * Decompiled with CFR 0.152.
 */
package madkit.netcomm;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.HashSet;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import madkit.kernel.KernelAddress;
import madkit.netcomm.CommunicatorAgent;
import madkit.netcomm.SSLConfigurator;
import madkit.netcomm.SocketKernel;

class SimpleSSLAgent
extends CommunicatorAgent {
    private SSLSocket sslSocket;

    public SimpleSSLAgent(KernelAddress kernelAddress, Socket socket, SocketKernel socketKernel) {
        super(kernelAddress, socket, socketKernel);
    }

    public SimpleSSLAgent(KernelAddress kernelAddress, Socket socket, SocketKernel socketKernel, HashSet hashSet) {
        super(kernelAddress, socket, socketKernel, (HashSet)hashSet.clone());
    }

    protected void openInputOutputStreams(Socket socket) {
        SSLSocketFactory sSLSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
        try {
            SSLSocket sSLSocket = (SSLSocket)sSLSocketFactory.createSocket(socket, socket.getInetAddress().getHostName(), socket.getPort(), true);
            if (this.dKernels == null) {
                sSLSocket.setUseClientMode(false);
            } else {
                sSLSocket.setUseClientMode(true);
            }
            sSLSocket.startHandshake();
            this.doInputOutputOpen(sSLSocket);
        }
        catch (IOException iOException) {
            this.debug("IOException caught " + iOException.getMessage());
            this.closeSocket();
        }
    }

    private void doInputOutputOpen(SSLSocket sSLSocket) {
        try {
            this.out = new DataOutputStream(sSLSocket.getOutputStream());
            this.in = new DataInputStream(new BufferedInputStream(sSLSocket.getInputStream()));
        }
        catch (IOException iOException) {
            this.debug("IOException caught " + iOException);
        }
        this.debug("Communication Secured :-)");
    }

    protected String getProtocol() {
        return "simplesslprotocol";
    }

    static {
        SSLConfigurator.configure();
    }
}

