/*
 * Decompiled with CFR 0.152.
 */
package madkit.netcomm;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import java.util.Vector;
import madkit.kernel.AgentAddress;
import madkit.kernel.KernelAddress;
import madkit.netcomm.MadkitNetworkAgent;
import madkit.netcomm.NetConfigMessage;
import madkit.netcomm.NetworkMessage;
import madkit.netcomm.SocketKernel;
import madkit.netcomm.UDPServerAgent;

class BroadCastClient
extends MadkitNetworkAgent {
    private MulticastSocket socket;
    private DatagramPacket packet;
    private InetAddress addressGroup;
    private boolean acceptBroadcast = NetConfigMessage.isAcceptBroadCast();
    private boolean alive = true;

    public BroadCastClient() {
        try {
            this.addressGroup = InetAddress.getByName(UDPServerAgent.MADKIT_BROADCAST_ADDR_GROUP);
        }
        catch (UnknownHostException unknownHostException) {
            this.debug("UnknownHostException caught " + unknownHostException.toString());
        }
        int n = 0;
        while (n < 5) {
            try {
                this.socket = new MulticastSocket(UDPServerAgent.DEFAULT__BROADCAST_PORT + n);
                this.socket.joinGroup(this.addressGroup);
                byte[] byArray = new byte[1024];
                this.packet = new DatagramPacket(byArray, byArray.length);
                n = 5;
            }
            catch (IOException iOException) {
                ++n;
            }
        }
    }

    protected void handleNetworkMessage(NetworkMessage networkMessage) {
    }

    protected void handleConfigMessage(NetConfigMessage netConfigMessage) {
        this.acceptBroadcast = NetConfigMessage.isAcceptBroadCast();
        this.setDebug(NetConfigMessage.isDebug());
        if (!this.acceptBroadcast) {
            this.println("BroadCastClient not accepting messages");
        }
    }

    public void activate() {
        super.activate();
        this.requestRole(community, "networking", "broadcastclient", memberCard);
        this.debug("BroadcastClient active");
    }

    public void live() {
        while (this.alive) {
            try {
                this.socket.receive(this.packet);
                if (this.acceptBroadcast) {
                    boolean bl = true;
                    this.debug("receiving broadcast");
                    this.exitImmediatlyOnKill();
                    byte[] byArray = this.packet.getData();
                    String string = new String(byArray);
                    if (string.startsWith(UDPServerAgent.MADKIT_PROTO)) {
                        int n = string.lastIndexOf(47) + 1;
                        String string2 = string.substring(n);
                        StringTokenizer stringTokenizer = new StringTokenizer(string2, ":", false);
                        String string3 = stringTokenizer.nextToken();
                        if (string3.equals(this.myKernel.getKernel().getID())) {
                            this.debug("broadcast from localkernel");
                            bl = false;
                        }
                        if (bl) {
                            String string4 = stringTokenizer.nextToken();
                            String string5 = stringTokenizer.nextToken();
                            int n2 = Integer.valueOf(string5);
                            this.sendConnectionRequest(string4, n2, new KernelAddress(string4 + ":" + string3));
                        }
                    } else {
                        this.debug("unknown broadcast received: " + string);
                    }
                }
            }
            catch (IOException iOException) {
                this.closeSocket();
            }
            catch (Exception exception) {
                // empty catch block
            }
            Thread.yield();
        }
    }

    private void closeSocket() {
        this.alive = false;
        if (!this.socket.isClosed()) {
            this.socket.close();
        }
    }

    private void sendConnectionRequest(String string, int n, KernelAddress kernelAddress) {
        this.debug("broadcast request received by " + string + ":" + n);
        AgentAddress agentAddress = this.getAgentWithRole(community, "networking", "router");
        Vector<Object> vector = new Vector<Object>();
        vector.add(0, null);
        vector.add(1, kernelAddress);
        vector.add(2, new SocketKernel(string, n));
        this.sendMessage(agentAddress, new NetworkMessage(8, vector));
    }

    public void end() {
        this.closeSocket();
        this.println("BroadcastClient Closed");
    }
}

