/*
 * Decompiled with CFR 0.152.
 */
package madkit.netcomm;

import java.io.IOException;
import java.net.Socket;
import java.util.Vector;
import madkit.kernel.AgentAddress;
import madkit.kernel.KernelAddress;
import madkit.kernel.KernelMessage;
import madkit.kernel.Message;
import madkit.netcomm.InputProcessor;
import madkit.netcomm.NetConfigMessage;
import madkit.netcomm.NetworkMessage;
import madkit.netcomm.P2PAgent;

class BasicCommAgent
extends P2PAgent {
    static final String handledProtocol = "basiccommprotocol";
    private InputProcessor _input;
    private Socket _socket;
    private boolean alive = true;
    private KernelAddress _distantKernel;
    private int _dynamicPort;

    public BasicCommAgent(Socket socket, KernelAddress kernelAddress, int n) {
        this._socket = socket;
        this._distantKernel = kernelAddress;
        this._dynamicPort = n;
        this.openInputOutputStreams(this._socket);
        this._input = new InputProcessor(this);
        this._input.start();
    }

    protected void closeSocket() {
        try {
            this.alive = false;
            if (!this._socket.isClosed()) {
                this._socket.close();
            }
            if (!this._input.isStopped()) {
                this._input.stop();
            }
            this.sendDisconnectedKernelInformation(this._distantKernel);
        }
        catch (IOException iOException) {
            this.debug("IOException caught : " + iOException.getMessage());
        }
    }

    protected String getProtocol() {
        return handledProtocol.toString();
    }

    protected void handleNetworkMessage(NetworkMessage networkMessage) {
        switch (networkMessage.getType()) {
            case 9: {
                this.closeSocket();
                break;
            }
            case 6: {
                this.sendDistantMessage((Message)networkMessage.getArgument());
                break;
            }
            default: {
                this.debug("unknown networkmessage type " + networkMessage.getType());
            }
        }
    }

    private void sendDistantMessage(Message message) {
        this.sendObject(message);
    }

    public void activate() {
        super.activate();
        this.sendMessage(this.getAgentWithRole("system", "kernel"), (Message)new KernelMessage(22, 12));
    }

    public void live() {
        while (this.alive) {
            Message message = this.waitNextMessage();
            this.exitImmediatlyOnKill();
            if (!this.alive) {
                return;
            }
            if (message instanceof NetworkMessage) {
                this.handleNetworkMessage((NetworkMessage)message);
                continue;
            }
            if (message instanceof NetConfigMessage) {
                this.handleConfigMessage((NetConfigMessage)message);
                continue;
            }
            if (!(message instanceof KernelMessage)) continue;
            this.handleKernelMessage((KernelMessage)message);
        }
    }

    private void handleKernelMessage(KernelMessage kernelMessage) {
        switch (kernelMessage.getType()) {
            case 12: {
                this.debug("Shares no community");
                if (this.sharesCommunity((String)kernelMessage.getArgument())) break;
                Vector<Object> vector = new Vector<Object>();
                vector.add(this._socket);
                vector.add(this._distantKernel);
                vector.add(new Integer(this._dynamicPort));
                break;
            }
        }
    }

    void receiveIncomming() {
        try {
            Object object = super.receiveObject();
            if (object instanceof Message) {
                this.injectMessage((Message)object);
            } else {
                this.debug("Unknown object received");
            }
        }
        catch (IOException iOException) {
            this.closeSocket();
            this.debug("IOException caught : " + iOException.getMessage());
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.closeSocket();
            this.debug("ClassNotFoundException caught : " + classNotFoundException.getMessage());
        }
    }

    protected boolean sharesCommunity(String string) {
        AgentAddress[] agentAddressArray = this.getAgentsWithRole("communities", string, "site");
        for (int i = 0; i < agentAddressArray.length; ++i) {
            if (!this._distantKernel.getID().equals(agentAddressArray[i])) continue;
            return true;
        }
        return false;
    }

    public void end() {
        this.closeSocket();
    }
}

