/*
 * Decompiled with CFR 0.152.
 */
package madkit.netcomm;

import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import madkit.kernel.AgentAddress;
import madkit.kernel.KernelMessage;
import madkit.netcomm.P2PAgent;
import madkit.netcomm.handlers.ConnectionHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractDynamicConnectionAgent
extends P2PAgent {
    private Hashtable<String, ConnectionHandler> _handlers = new Hashtable();

    AbstractDynamicConnectionAgent() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean addConnectionHandler(String string, ConnectionHandler connectionHandler) {
        boolean bl;
        Hashtable<String, ConnectionHandler> hashtable = this._handlers;
        synchronized (hashtable) {
            if (this._handlers.keySet().contains(string)) {
                this.debug("not adding handler..  kenel id already here ");
                bl = false;
            } else {
                this.debug("new handler added");
                this._handlers.put(string, connectionHandler);
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionHandler getConnectionHandler(String string) {
        ConnectionHandler connectionHandler;
        Hashtable<String, ConnectionHandler> hashtable = this._handlers;
        synchronized (hashtable) {
            connectionHandler = this._handlers.get(string);
        }
        return connectionHandler;
    }

    protected void handleHook(KernelMessage kernelMessage) {
        Object object;
        if (kernelMessage.getType() == 15) {
            switch (kernelMessage.getOperation()) {
                case 11: {
                    object = (String)kernelMessage.getArgument();
                    this.startNomalCommIfNeeded((String)object, false);
                    break;
                }
                default: {
                    this.debug("unkwon kernel message received");
                }
            }
        }
        if (kernelMessage.getType() == 13) {
            switch (kernelMessage.getOperation()) {
                case 27: {
                    object = null;
                    if (kernelMessage.getType() != 13) break;
                    object = (Map)kernelMessage.getArgument();
                    Map map = (Map)object.get("communities");
                    Set set = map.keySet();
                    for (String string : set) {
                        if (string.equals("public")) continue;
                        this.startNomalCommIfNeeded(string, true);
                    }
                    break;
                }
            }
        }
    }

    private void startNomalCommIfNeeded(String string, boolean bl) {
        Collection<AgentAddress> collection = this.sharesCommunity(string);
        if (collection != null && this.canHandleNormalConnection()) {
            for (AgentAddress agentAddress : collection) {
                if (!bl) {
                    this.requestNormalConnection(agentAddress);
                    continue;
                }
                ConnectionHandler connectionHandler = this.getConnectionHandler(agentAddress.getKernel().getID());
                if (!connectionHandler.isActiveMode()) continue;
                this.requestNormalConnection(agentAddress);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection<AgentAddress> sharesCommunity(String string) {
        AgentAddress[] agentAddressArray = this.getAgentsWithRole("communities", string, "site");
        String string2 = this.myKernel.getKernel().getID();
        boolean bl = false;
        for (int i = 0; i < agentAddressArray.length && !bl; ++i) {
            bl = string2.equals(agentAddressArray[i].getKernel().getID());
        }
        if (!bl) {
            return null;
        }
        Vector<AgentAddress> vector = new Vector<AgentAddress>();
        Hashtable<String, ConnectionHandler> hashtable = this._handlers;
        synchronized (hashtable) {
            for (int i = 0; i < agentAddressArray.length; ++i) {
                if (!this._handlers.containsKey(agentAddressArray[i].getKernel().getID())) continue;
                if (!agentAddressArray[i].getKernel().getID().equals(this.myKernel.getKernel().getID())) {
                    vector.add(agentAddressArray[i]);
                    continue;
                }
                this.debug("My Kernel is part of the routes... ??");
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeConnectionHandler(String string) {
        Hashtable<String, ConnectionHandler> hashtable = this._handlers;
        synchronized (hashtable) {
            this._handlers.remove(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection<ConnectionHandler> getAllHandlers() {
        Vector<ConnectionHandler> vector = new Vector<ConnectionHandler>();
        Hashtable<String, ConnectionHandler> hashtable = this._handlers;
        synchronized (hashtable) {
            vector.addAll(this._handlers.values());
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isHandlersEmpty() {
        boolean bl;
        Hashtable<String, ConnectionHandler> hashtable = this._handlers;
        synchronized (hashtable) {
            bl = this._handlers.isEmpty();
        }
        return bl;
    }

    protected abstract boolean canHandleNormalConnection();

    protected abstract void requestNormalConnection(AgentAddress var1);
}

