/*
 * Decompiled with CFR 0.152.
 */
package madkit.bsh;

import bsh.EvalError;
import bsh.Interpreter;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import madkit.kernel.AbstractAgent;
import madkit.kernel.Agent;
import madkit.kernel.Message;
import madkit.messages.ControlMessage;
import madkit.utils.agents.LanguageController;

public class BeanShellController
extends LanguageController {
    public static final String DATE = "16/04/2002";
    public static final String VERSION = "1.0";
    boolean okForLive = false;
    boolean okForDoIt = false;
    Interpreter interp = new Interpreter();

    public void setOkForLive(boolean bl) {
        this.okForLive = bl;
    }

    public boolean getOkForLive() {
        return this.okForLive;
    }

    public void setOkForDoIt(boolean bl) {
        this.okForDoIt = bl;
    }

    public boolean getOkForDoIt() {
        return this.okForDoIt;
    }

    public Interpreter getInterpret() {
        return this.interp;
    }

    public BeanShellController(AbstractAgent abstractAgent) {
        super(abstractAgent);
    }

    public BeanShellController(AbstractAgent abstractAgent, String string) {
        super(abstractAgent, string);
    }

    boolean methodExist(String string) {
        String[] stringArray = this.interp.getNameSpace().getMethodNames();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equals(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    public void activate() {
        this.thisAgent.createGroup(false, "bsh", null, null);
        try {
            this.interp.eval("import madkit.kernel.*;");
            this.interp.eval("import madkit.messages.*;");
            this.interp.eval("import madkit.bsh.*");
            this.interp.eval("import madkit.utils.graphics.*;");
            this.interp.eval("import madkit.utils.common.*;");
            this.interp.eval("import madkit.utils.agents.*;");
            this.interp.set("self", (Object)this.thisAgent);
            this.interp.set("myController", (Object)this);
            this.interp.set("me", (Object)this.thisAgent.getAddress());
            this.interp.eval("void print(s){self.print(s);}");
            this.interp.eval("void println(s){self.println(s);}");
        }
        catch (EvalError evalError) {
            this.println("BeanShell error while activating the agent");
        }
        this.println("BeanShellLib, integration of BeanShell (the light Java interpreter) into Madkit");
        this.println("Version 1.0 - 16/04/2002 - Copyright (C) 2002 MadKit team");
        this.thisAgent.activate();
        this.loadFile(this.getLibFile());
        this.loadFile(this.getBehaviorFile());
        try {
            if (this.methodExist("activate")) {
                this.interp.eval("activate();");
            }
        }
        catch (EvalError evalError) {
            this.println("BeanShell error doing activate()");
            evalError.printStackTrace();
        }
    }

    protected void handleControlMessage(ControlMessage controlMessage) {
        String string = controlMessage.getAction();
        this.println("<< ControlMessage: " + string);
        try {
            if (string.equals("dir")) {
                this.interp.eval("dir()");
            } else if (string.equals("eval")) {
                this.interp.eval(controlMessage.getContent());
                this.println("OK");
                this.okForLive = true;
            } else {
                super.handleControlMessage(controlMessage);
            }
        }
        catch (EvalError evalError) {
            this.println("BeanShell error doing " + string);
            evalError.printStackTrace(System.err);
        }
    }

    protected void handleMessage(Message message) {
        if (message instanceof ControlMessage) {
            this.handleControlMessage((ControlMessage)message);
        }
    }

    public void live() {
        block2: while (true) {
            try {
                while (true) {
                    if (this.methodExist("live") && this.okForLive) {
                        this.exitImmediatlyOnKill();
                        this.interp.eval("live()");
                        break block2;
                    }
                    Message message = ((Agent)this.thisAgent).waitNextMessage();
                    if (!(message instanceof ControlMessage)) continue;
                    this.handleControlMessage((ControlMessage)message);
                }
            }
            catch (EvalError evalError) {
                this.println("BeanShell error doing live()");
                evalError.printStackTrace(System.err);
                this.setOkForLive(false);
                continue;
            }
            break;
        }
    }

    public void end() {
        try {
            if (this.methodExist("end")) {
                this.interp.eval("end()");
            }
        }
        catch (EvalError evalError) {
            this.println("BeanShell error doing end()");
            evalError.printStackTrace(System.err);
        }
        this.thisAgent.end();
    }

    public void doIt() {
        try {
            if (!this.okForDoIt && this.methodExist("doIt")) {
                this.setOkForDoIt(true);
            }
            if (this.okForDoIt) {
                this.interp.eval("doIt()");
            }
        }
        catch (EvalError evalError) {
            this.println("BeanShell error doing doIt()");
            evalError.printStackTrace(System.err);
        }
    }

    public void loadFile(String string) {
        FileReader fileReader = null;
        if (string != null) {
            try {
                fileReader = new FileReader(string);
            }
            catch (IOException iOException) {
                this.println("BeanShell file not found " + string);
                return;
            }
            try {
                this.interp.eval((Reader)fileReader, this.interp.getNameSpace(), string);
            }
            catch (EvalError evalError) {
                this.println("BeanShell error while importing " + string);
                evalError.printStackTrace(System.err);
            }
        }
    }
}

