/*
 * Decompiled with CFR 0.152.
 */
package madkit.system;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JPanel;
import madkit.kernel.AgentAddress;
import madkit.system.AgentEvent;
import madkit.system.AgentSpy;
import madkit.system.GraphicBody;
import madkit.system.GraphicDown;
import madkit.system.GraphicGroupObserverGUI;
import madkit.system.GraphicHeader;
import madkit.system.GraphicLeft;

class GraphicGroupObserverGUIPane
extends JPanel
implements MouseMotionListener,
MouseListener {
    protected LinkedList agents = null;
    protected LinkedList events = null;
    protected GraphicHeader graphicHeader;
    protected GraphicBody graphicBody;
    protected GraphicLeft graphicLeft;
    protected GraphicDown graphicDown;
    protected int agentH;
    protected int agentW;
    protected int staticStep;
    protected int margeX;
    protected int margeY;
    protected int newCol;
    protected int currentCol;
    protected HashMap toSpy;
    protected GraphicGroupObserverGUI gui;
    protected AgentEvent currentEvent;

    public GraphicGroupObserverGUIPane(GraphicGroupObserverGUI graphicGroupObserverGUI) {
        super(new BorderLayout());
        this.gui = graphicGroupObserverGUI;
        this.toSpy = (HashMap)graphicGroupObserverGUI.getMap().get("toSpy");
        JPanel jPanel = new JPanel(new BorderLayout());
        this.graphicHeader = new GraphicHeader(this);
        jPanel.add((Component)this.graphicHeader, "North");
        this.graphicBody = new GraphicBody(this);
        jPanel.add((Component)this.graphicBody, "Center");
        this.add((Component)jPanel, "Center");
        this.graphicLeft = new GraphicLeft(this);
        this.add((Component)this.graphicLeft, "West");
        this.graphicDown = new GraphicDown(this);
        this.add((Component)this.graphicDown, "South");
        this.agentW = 80;
        this.agentH = 60;
        this.staticStep = 10;
        this.margeX = 10;
        this.margeY = 10;
        this.currentCol = -1;
        this.agents = new LinkedList();
        this.events = new LinkedList();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.agents.size() > 0) {
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setColor(Color.LIGHT_GRAY);
            float[] fArray = new float[]{10.0f, 5.0f, 5.0f, 5.0f};
            graphics2D.setStroke(new BasicStroke(1.5f, 0, 0, 10.0f, fArray, 0.0f));
            graphics2D.drawLine(this.graphicLeft.getWidth(), this.agentH, this.agents.size() * this.agentW + this.graphicLeft.getWidth(), this.agentH);
            graphics2D.drawLine(this.graphicLeft.getWidth(), this.getHeight() - this.graphicDown.getHeight(), this.agents.size() * this.agentW + this.graphicLeft.getWidth(), this.getHeight() - this.graphicDown.getHeight());
            int n = 0;
            graphics2D.drawLine(this.graphicLeft.getWidth(), 0, this.graphicLeft.getWidth(), this.getHeight() - this.graphicDown.getHeight());
            for (AgentSpy agentSpy : this.agents) {
                int n2 = ++n * this.agentW + this.graphicLeft.getWidth();
                graphics2D.drawLine(n2, 0, n2, this.getHeight() - this.graphicDown.getHeight());
            }
            graphics2D.setStroke(stroke);
            int n3 = this.margeY + this.events.size() * this.staticStep + this.agentH;
            int[] nArray = new int[]{this.graphicLeft.getWidth(), this.graphicLeft.getWidth() - 8, this.graphicLeft.getWidth() - 8};
            int[] nArray2 = new int[]{n3, n3 - 6, n3 + 6};
            graphics2D.setColor(Color.red);
            graphics2D.fill(new Polygon(nArray, nArray2, 3));
            graphics2D.setColor(Color.black);
            graphics2D.draw(new Polygon(nArray, nArray2, 3));
            graphics2D.drawLine(this.graphicLeft.getWidth(), n3, this.agents.size() * this.agentW + this.graphicLeft.getWidth(), n3);
        }
        if (this.currentCol >= 0) {
            int n = this.newCol * this.agentW + this.graphicLeft.getWidth();
            int n4 = this.currentCol * this.agentW + this.graphicLeft.getWidth();
            graphics2D.setColor(Color.red);
            graphics2D.draw(new Rectangle(n4 + this.margeX / 2, this.margeY / 2, this.agentW - this.margeX, this.getHeight() - this.margeY - this.graphicDown.getHeight()));
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setStroke(new BasicStroke(2.0f));
            graphics2D.setColor(Color.blue);
            graphics2D.drawLine(n, this.margeX, n, this.getHeight() - this.margeY - this.graphicDown.getHeight());
            graphics2D.setStroke(stroke);
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.currentCol >= 0) {
            this.newCol = (int)Math.round((double)(mouseEvent.getX() - this.graphicLeft.getWidth()) / (double)this.agentW);
            this.newCol = Math.min(this.newCol, this.agents.size());
            this.newCol = Math.max(this.newCol, 0);
            this.repaint();
        } else {
            this.mousePressed(mouseEvent);
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        int n = mouseEvent.getX() - this.graphicLeft.getWidth();
        int n2 = n / this.agentW;
        this.currentCol = n >= 0 && n2 < this.agents.size() ? n2 : -1;
        this.newCol = this.currentCol;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.currentCol >= 0) {
            if (this.newCol > this.currentCol) {
                --this.newCol;
            }
            if (this.newCol != this.currentCol) {
                Object e = this.agents.remove(this.currentCol);
                this.agents.add(this.newCol, e);
            }
            this.currentCol = -1;
            this.repaint();
        }
    }

    protected synchronized void addAgentFirst(AgentSpy agentSpy) {
        this.agents.addFirst(agentSpy);
        Dimension dimension = this.getSize();
        dimension.width += this.getAgentWidth();
        this.setSize(dimension);
        this.validate();
    }

    protected synchronized void addAgentLast(AgentSpy agentSpy) {
        this.agents.addLast(agentSpy);
        Dimension dimension = this.getSize();
        dimension.width += this.getAgentWidth();
        this.setSize(dimension);
        this.validate();
    }

    protected synchronized void removeAgent(AgentSpy agentSpy) {
        if (this.agents.remove(agentSpy)) {
            Dimension dimension = this.getSize();
            dimension.width -= this.getAgentWidth();
            this.setSize(dimension);
            this.validate();
        }
    }

    protected synchronized void addEvent(AgentEvent agentEvent) {
        if (this.events.add(agentEvent)) {
            Dimension dimension = this.getSize();
            dimension.height += this.getStaticStep();
            this.setSize(dimension);
            this.validate();
        }
    }

    protected synchronized void removeEvent(AgentEvent agentEvent) {
        if (this.events.remove(agentEvent)) {
            Dimension dimension = this.getSize();
            dimension.height -= this.getStaticStep();
            this.setSize(dimension);
            this.validate();
        }
    }

    public synchronized void addExistingAgent(AgentAddress agentAddress, HashMap hashMap) {
        if (this.spy(hashMap)) {
            AgentSpy agentSpy = this.haveAgent(agentAddress);
            if (agentSpy == null) {
                agentSpy = new AgentSpy(this, agentAddress);
                agentSpy.addMap(this.toSpy);
                agentSpy.addMap(hashMap);
                agentSpy.setComeEvent(null);
                if (((Boolean)this.gui.getMap().get("addFirst")).booleanValue()) {
                    this.addAgentFirst(agentSpy);
                } else {
                    this.addAgentLast(agentSpy);
                }
            } else {
                agentSpy.addMap(hashMap);
            }
            this.repaint();
        }
    }

    public void addMemberRole(AgentEvent agentEvent, HashMap hashMap) {
        if (this.spy(hashMap)) {
            AgentSpy agentSpy = this.haveAgent(agentEvent.getSource());
            if (agentSpy == null) {
                agentSpy = new AgentSpy(this, agentEvent.getSource());
                agentSpy.addMap(this.toSpy);
                agentSpy.addMap(hashMap);
                agentSpy.setComeEvent(agentEvent);
                if (((Boolean)this.gui.getMap().get("addFirst")).booleanValue()) {
                    this.addAgentFirst(agentSpy);
                } else {
                    this.addAgentLast(agentSpy);
                }
            } else {
                if (!agentSpy.Spied()) {
                    agentSpy.setComeEvent(agentEvent);
                }
                if (agentSpy.getNbMap() <= 0) {
                    agentSpy.addMap(this.toSpy);
                }
                agentSpy.addMap(hashMap);
            }
            this.addEvent(agentEvent);
            this.repaint();
        }
    }

    public void removeFrom(AgentEvent agentEvent, HashMap hashMap) {
        AgentSpy agentSpy = this.haveAgent(agentEvent.getSource());
        if (agentSpy != null) {
            agentSpy.removeMaps(hashMap);
            if (agentSpy.Spied()) {
                if (agentSpy.getNbMap() <= 0) {
                    agentSpy.setQuitEvent(agentEvent);
                }
                this.addEvent(agentEvent);
            }
            this.repaint();
        }
    }

    public void removeAllFrom(AgentEvent agentEvent, HashMap hashMap) {
        Iterator iterator = this.agents.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            AgentSpy agentSpy = (AgentSpy)iterator.next();
            if (agentSpy == null) continue;
            bl = true;
            agentSpy.removeMaps(hashMap);
            if (!agentSpy.Spied() || agentSpy.getNbMap() > 0) continue;
            agentSpy.setQuitEvent(agentEvent);
        }
        if (bl) {
            this.addEvent(agentEvent);
            this.repaint();
        }
    }

    public void killAgent(AgentEvent agentEvent) {
        AgentSpy agentSpy = this.haveAgent(agentEvent.getSource());
        if (agentSpy != null) {
            if (agentSpy.Spied()) {
                agentSpy.setQuitEvent(agentEvent);
            }
            agentSpy.setKilled(true);
            this.addEvent(agentEvent);
            if (((Boolean)this.gui.getMap().get("autoRemove")).booleanValue()) {
                this.removeKilledAgent();
            }
        }
        this.repaint();
    }

    public void addMessage(AgentEvent agentEvent) {
        AgentSpy agentSpy = this.haveAgent(agentEvent.getSource());
        AgentSpy agentSpy2 = this.haveAgent(agentEvent.getDest());
        if (agentSpy != null && agentSpy2 != null && agentSpy != agentSpy2 && agentSpy.Spied() && agentSpy2.Spied()) {
            this.addEvent(agentEvent);
        }
    }

    public void addBroadcastMessage(AgentEvent agentEvent) {
        AgentSpy agentSpy = this.haveAgent(agentEvent.getSource());
        if (agentSpy != null && agentSpy.Spied()) {
            this.addEvent(agentEvent);
        }
    }

    protected AgentSpy haveAgent(AgentAddress agentAddress) {
        for (AgentSpy agentSpy : this.agents) {
            if (!agentSpy.getAgentAddress().equals((Object)agentAddress)) continue;
            return agentSpy;
        }
        return null;
    }

    public boolean spy(HashMap hashMap) {
        for (Object k : this.toSpy.keySet()) {
            Object v = this.toSpy.get(k);
            if (v.equals(hashMap.get(k))) continue;
            return false;
        }
        return true;
    }

    public int getPos(AgentAddress agentAddress) {
        Iterator iterator = this.agents.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            AgentSpy agentSpy = (AgentSpy)iterator.next();
            if (agentSpy.getAgentAddress().equals((Object)agentAddress)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public synchronized void removeKilledAgent() {
        Object object;
        Iterator iterator = this.agents.iterator();
        while (iterator.hasNext()) {
            object = (AgentSpy)iterator.next();
            if (!((AgentSpy)object).isKilled()) continue;
            iterator.remove();
        }
        iterator = this.events.iterator();
        while (iterator.hasNext()) {
            object = (AgentEvent)iterator.next();
            if (((AgentEvent)object).valid(this)) continue;
            iterator.remove();
        }
        this.repaint();
    }

    public void setCurrentEvent(AgentEvent agentEvent) {
        this.currentEvent = agentEvent;
        this.repaint();
    }

    public AgentEvent getCurrentEvent() {
        return this.currentEvent;
    }

    public LinkedList getListAgent() {
        return this.agents;
    }

    public LinkedList getListEvent() {
        return this.events;
    }

    public int getAgentWidth() {
        return this.agentW;
    }

    public int getHeaderHeight() {
        return this.agentH;
    }

    public int getStaticStep() {
        return this.staticStep;
    }

    public int getMargeX() {
        return this.margeX;
    }

    public int getMargeY() {
        return this.margeY;
    }
}

