/*
 * Decompiled with CFR 0.152.
 */
package madkit.system;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import madkit.kernel.AgentAddress;
import madkit.system.AgentEvent;
import madkit.system.GraphicGroupObserverGUIPane;
import madkit.system.OPoint;

class AgentSpy {
    AgentAddress agentAddress;
    long start;
    long end;
    AgentEvent comeEvent;
    AgentEvent quitEvent;
    String name;
    ArrayList list;
    LinkedList beginEndEvent;
    int step;
    Color color;
    boolean killed;
    GraphicGroupObserverGUIPane parent;

    public AgentSpy(GraphicGroupObserverGUIPane graphicGroupObserverGUIPane, AgentAddress agentAddress) {
        this.agentAddress = agentAddress;
        this.parent = graphicGroupObserverGUIPane;
        this.start = -1L;
        this.end = -1L;
        this.comeEvent = null;
        this.quitEvent = null;
        this.list = new ArrayList();
        this.beginEndEvent = new LinkedList();
        this.color = agentAddress.isLocal() ? Color.cyan : Color.LIGHT_GRAY;
        this.killed = false;
    }

    public void addMap(HashMap hashMap) {
        this.list.add(hashMap);
    }

    public void removeMaps(HashMap hashMap) {
        Iterator iterator = this.list.iterator();
        while (iterator.hasNext()) {
            HashMap hashMap2 = (HashMap)iterator.next();
            if (!this.contain(hashMap2, hashMap)) continue;
            iterator.remove();
        }
    }

    public boolean contain(HashMap hashMap, HashMap hashMap2) {
        for (Object k : hashMap2.keySet()) {
            Object v = hashMap2.get(k);
            if (v.equals(hashMap.get(k))) continue;
            return false;
        }
        return true;
    }

    public AgentAddress getAgentAddress() {
        return this.agentAddress;
    }

    public void setName(AgentAddress agentAddress) {
        this.agentAddress = agentAddress;
    }

    public long getStart() {
        return this.start;
    }

    public void setStart(long l) {
        this.start = l;
    }

    public long getEnd() {
        return this.end;
    }

    public void setEnd(long l) {
        this.end = l;
    }

    public AgentEvent getComeEvent() {
        return this.comeEvent;
    }

    public void setComeEvent(AgentEvent agentEvent) {
        this.comeEvent = agentEvent;
        OPoint oPoint = new OPoint();
        oPoint.o1 = agentEvent;
        oPoint.o2 = null;
        this.beginEndEvent.add(oPoint);
    }

    public int getNbMap() {
        return this.list.size();
    }

    public AgentEvent getQuitEvent() {
        return this.quitEvent;
    }

    public void setQuitEvent(AgentEvent agentEvent) {
        this.quitEvent = agentEvent;
        OPoint oPoint = (OPoint)this.beginEndEvent.getLast();
        oPoint.o2 = agentEvent;
    }

    public void setKilled(boolean bl) {
        this.killed = bl;
    }

    public boolean isKilled() {
        return this.killed;
    }

    public boolean Spied() {
        return ((OPoint)this.beginEndEvent.getLast()).o2 == null;
    }

    public boolean SpiedAt(int n) {
        for (OPoint oPoint : this.beginEndEvent) {
            if (!(oPoint.o2 == null ? n >= this.parent.getListEvent().indexOf(oPoint.o1) : n >= this.parent.getListEvent().indexOf(oPoint.o1) && n <= this.parent.getListEvent().indexOf(oPoint.o2))) continue;
            return true;
        }
        return false;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void paint(Graphics2D graphics2D, GraphicGroupObserverGUIPane graphicGroupObserverGUIPane, int n) {
        int n2 = (int)(((double)n + 0.5) * (double)graphicGroupObserverGUIPane.getAgentWidth()) - 10;
        int n3 = graphicGroupObserverGUIPane.getListEvent().size();
        for (OPoint oPoint : this.beginEndEvent) {
            int n4 = graphicGroupObserverGUIPane.getListEvent().indexOf(oPoint.o1);
            int n5 = graphicGroupObserverGUIPane.getListEvent().indexOf(oPoint.o2);
            int n6 = graphicGroupObserverGUIPane.getMargeY() + n4 * graphicGroupObserverGUIPane.getStaticStep();
            int n7 = n5 >= 0 ? (n5 - n4) * graphicGroupObserverGUIPane.getStaticStep() : (n3 - n4) * graphicGroupObserverGUIPane.getStaticStep();
            graphics2D.setColor(this.color);
            graphics2D.fill(new Rectangle(n2, n6, 20, n7));
            graphics2D.setColor(Color.black);
            graphics2D.draw(new Rectangle(n2, n6, 20, n7));
        }
    }
}

