/*
 * Decompiled with CFR 0.152.
 */
package jsynedit.search;

import gnu.regexp.RESearchMatcher;
import javax.swing.text.Segment;
import jedit.syntax.SyntaxDocument;
import jedit.textarea.JEditTextArea;
import jsynedit.search.BoyerMooreSearchMatcher;
import jsynedit.search.SearchMatcher;
import jsynedit.search.UUtilities;

public class Search {
    public static SearchMatcher matcher;
    public static String replacePattern;
    public static String findPattern;
    public static String pythonScript;
    public static boolean useRegexp;
    public static boolean ignoreCase;
    public static boolean script;
    public static boolean reverseSearch;

    public static String getPythonScriptString() {
        return pythonScript;
    }

    public static void setPythonScriptString(String string) {
        pythonScript = string;
    }

    public static boolean getPythonScript() {
        return script;
    }

    public static void setPythonScript(boolean bl) {
        script = bl;
    }

    public static boolean getRegexp() {
        return useRegexp;
    }

    public static void setRegexp(boolean bl) {
        useRegexp = bl;
    }

    public static boolean getIgnoreCase() {
        return ignoreCase;
    }

    public static void setIgnoreCase(boolean bl) {
        ignoreCase = bl;
    }

    public static void setFindPattern(String string) {
        findPattern = string;
    }

    public static String getFindPattern() {
        return findPattern;
    }

    public static void setReplacePattern(String string) {
        replacePattern = string;
    }

    public static String getReplacePattern() {
        return replacePattern;
    }

    public static SearchMatcher getSearchMatcher() throws Exception {
        return Search.getSearchMatcher(true);
    }

    public static SearchMatcher getSearchMatcher(boolean bl) throws Exception {
        String string;
        if (findPattern == null || "".equals(findPattern)) {
            return null;
        }
        String string2 = string = replacePattern == null ? "" : replacePattern;
        matcher = useRegexp ? new RESearchMatcher(findPattern, string, ignoreCase, script, pythonScript) : new BoyerMooreSearchMatcher(findPattern, string, ignoreCase, reverseSearch && bl, script, pythonScript);
        return matcher;
    }

    public static boolean find(JEditTextArea jEditTextArea, int n) throws Exception {
        SearchMatcher searchMatcher = Search.getSearchMatcher(true);
        Segment segment = new Segment();
        SyntaxDocument syntaxDocument = jEditTextArea.getDocument();
        syntaxDocument.getText(n, syntaxDocument.getLength() - n, segment);
        int[] nArray = searchMatcher.nextMatch(segment);
        if (nArray != null) {
            jEditTextArea.select(n + nArray[0], n + nArray[1]);
            return true;
        }
        return false;
    }

    public static boolean replace(JEditTextArea jEditTextArea) {
        if (!jEditTextArea.isEditable()) {
            UUtilities.beep();
            return false;
        }
        int n = jEditTextArea.getSelectionStart();
        boolean bl = jEditTextArea.isSelectionRectangular();
        if (n == jEditTextArea.getSelectionEnd()) {
            UUtilities.beep();
            return false;
        }
        try {
            SearchMatcher searchMatcher = Search.getSearchMatcher(false);
            if (searchMatcher == null) {
                UUtilities.beep();
                return false;
            }
            String string = jEditTextArea.getSelectedText();
            String string2 = searchMatcher.substitute(string);
            if (string2 == null || string2.equals(string)) {
                return false;
            }
            jEditTextArea.setSelectedText(string2);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static int replaceAll(JEditTextArea jEditTextArea, int n, int n2) throws Exception {
        if (!jEditTextArea.isEditable()) {
            return 0;
        }
        SyntaxDocument syntaxDocument = jEditTextArea.getDocument();
        SearchMatcher searchMatcher = Search.getSearchMatcher(false);
        if (searchMatcher == null) {
            return 0;
        }
        int n3 = 0;
        Segment segment = new Segment();
        int n4 = n;
        while (true) {
            syntaxDocument.getText(n4, n2 - n4, segment);
            int[] nArray = searchMatcher.nextMatch(segment);
            if (nArray == null) break;
            int n5 = nArray[0] + n4;
            int n6 = nArray[1] - nArray[0];
            String string = syntaxDocument.getText(n5, n6);
            String string2 = searchMatcher.substitute(string);
            n2 -= string.length() - string2.length();
            if (string2 != null) {
                syntaxDocument.remove(n5, n6);
                syntaxDocument.insertString(n5, string2, null);
                ++n3;
                n4 += nArray[0] + string.length();
                continue;
            }
            n4 += n6;
        }
        return n3;
    }

    static {
        useRegexp = false;
        ignoreCase = true;
        script = false;
        reverseSearch = false;
    }
}

