/*
 * Decompiled with CFR 0.152.
 */
package jsynedit;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Vector;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import jsynedit.AbstractEditorPanel;
import jsynedit.EditorGroupDialog;
import jsynedit.EditorLeaveRoleDialog;
import jsynedit.EditorSetTargetDialog;
import jsynedit.JSynEditAgent;
import madkit.utils.graphics.GraphicUtils;

class EditorPanel
extends AbstractEditorPanel {
    JComboBox groupChooser;
    JComboBox roleChooser;
    boolean activeChooser = false;
    JLabel currentGroupLabel;
    JLabel currentRoleLabel;
    JCheckBoxMenuItem showMessagesItem;
    JCheckBoxMenuItem showOutMessagesItem;
    protected JPanel commandPanel;

    EditorPanel(JSynEditAgent jSynEditAgent) {
        super(jSynEditAgent);
        JMenuBar jMenuBar = this.getMenubar();
        JMenu jMenu = new JMenu("Actions");
        jMenuBar.add(jMenu);
        EditorPanel.addMenuItem(this, jMenu, "Create agent from script", "createAgentFromScript", 68, 68);
        EditorPanel.addMenuItem(this, jMenu, "Join group/role", "joingroup", 74, 74);
        EditorPanel.addMenuItem(this, jMenu, "Leave group/role", "requestLeaveRole", 74, 74);
        EditorPanel.addMenuItem(this, jMenu, "Set target", "setTarget", 84, 84);
        EditorPanel.addMenuItem(this, jMenu, "Send selection", "sendsel", 69, 69);
        EditorPanel.addMenuItem(this, jMenu, "Send buffer", "sendbuff", 66, 66);
        this.menuOptions.addSeparator();
        this.showMessagesItem = new JCheckBoxMenuItem("Show incoming messages");
        this.showMessagesItem.setActionCommand("showInMessages");
        this.showMessagesItem.setSelected(true);
        this.showMessagesItem.addActionListener(this);
        this.menuOptions.add(this.showMessagesItem);
        this.showOutMessagesItem = new JCheckBoxMenuItem("Show outgoing messages");
        this.showOutMessagesItem.setActionCommand("showOutMessages");
        this.showOutMessagesItem.setSelected(true);
        this.showOutMessagesItem.addActionListener(this);
        this.menuOptions.add(this.showOutMessagesItem);
        JToolBar jToolBar = this.getToolbar();
        jToolBar.addSeparator();
        this.addTool(jToolBar, "joingroup", "Join group", "/images/toolbars/joingroup.gif");
        this.addTool(jToolBar, "requestLeaveRole", "Leave role", "/images/toolbars/leaverole.gif");
        this.addTool(jToolBar, "setTarget", "Set target (group/role)", "/images/toolbars/settarget.gif");
        jToolBar.addSeparator();
        this.addTool(jToolBar, "sendbuff", "Send buffer", "/images/toolbars/sendbuf.gif");
        this.addTool(jToolBar, "sendsel", "Send selection", "/images/toolbars/sendsel.gif");
        JPanel jPanel = new JPanel(new BorderLayout());
        this.getContentPane().add((Component)jPanel, "South");
        this.currentGroupLabel = new JLabel("Target group: none");
        this.currentRoleLabel = new JLabel("Target role: none");
        jPanel.add((Component)this.currentGroupLabel, "West");
        jPanel.add((Component)this.currentRoleLabel, "East");
    }

    public void command(String string) {
        if (string.equals("sendbuff")) {
            this.evalBuffer();
        } else if (string.equals("sendsel")) {
            this.evalSelection();
        } else if (string.equals("setTarget")) {
            this.setTarget();
        } else if (string.equals("createAgentFromScript")) {
            if (this.getInputArea() != null) {
                String string2 = this.getInputArea().getCurrentFile();
                ((JSynEditAgent)this.ag).createAgentFromScript(string2);
            } else {
                System.err.println("No files");
            }
        } else if (string.equals("requestLeaveRole")) {
            this.requestLeaveRole();
        } else if (string.equals("joingroup")) {
            this.requestJoinGroup();
        } else if (string.equals("showInMessages")) {
            boolean bl = this.showMessagesItem.isSelected();
            ((JSynEditAgent)this.ag).showInMessages(bl);
        } else if (string.equals("showOutMessages")) {
            boolean bl = this.showOutMessagesItem.isSelected();
            ((JSynEditAgent)this.ag).showOutMessages(bl);
        } else {
            super.command(string);
        }
    }

    void showCurrentGroup(String string) {
        this.currentGroupLabel.setText("Target group: " + string);
    }

    void showCurrentRole(String string) {
        this.currentRoleLabel.setText("Target role: " + string);
    }

    void evalBuffer() {
        String string = this.inputArea.getText();
        ((JSynEditAgent)this.ag).sendString(string);
    }

    void evalSelection() {
        String string = this.inputArea.getSelectedText();
        ((JSynEditAgent)this.ag).sendString(string);
    }

    void setTarget() {
        new EditorSetTargetDialog((JSynEditAgent)this.ag, GraphicUtils.getRealFrameParent((Component)this));
    }

    void requestLeaveRole() {
        new EditorLeaveRoleDialog((JSynEditAgent)this.ag, GraphicUtils.getRealFrameParent((Component)this));
    }

    void requestJoinGroup() {
        ((JSynEditAgent)this.ag).requestJoinGroup();
        new EditorGroupDialog((JSynEditAgent)this.ag, GraphicUtils.getRealFrameParent((Component)this));
    }

    void joinGroup(Vector vector) {
        new EditorGroupDialog((JSynEditAgent)this.ag, GraphicUtils.getRealFrameParent((Component)this));
    }
}

