/*
 * Decompiled with CFR 0.152.
 */
package gnu.jbrowser;

import gnu.jbrowser.JBrowseParser;
import gnu.jbrowser.Options;
import gnu.jbrowser.UML;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class UMLTree
extends JTree {
    public UMLTree() {
        super.setModel(null);
        this.putClientProperty("JTree.lineStyle", "Angled");
        this.setVisibleRowCount(15);
    }

    public void display(Model model, Options options, JBrowseParser.Results results) {
        Options.Display display = options.getDisplayOptions();
        Options.Filter filter = options.getFilterOptions();
        this.setCellRenderer(new CellRenderer(display));
        model.setFilterOptions(filter);
        super.setModel(model);
        model.reload();
        this.expandRow(0);
        TreePath treePath = results.getTopLevelPath();
        if (treePath != null) {
            this.expandPath(treePath);
        }
    }

    public void updateVisibleToggled(Options options) {
        Model model = (Model)this.getModel();
        Options.Filter filter = options.getFilterOptions();
        TreePath treePath = this.getPathForRow(0);
        Enumeration<TreePath> enumeration = this.getDescendantToggledPaths(treePath);
        while (enumeration.hasMoreElements()) {
            treePath = enumeration.nextElement();
            Node node = (Node)treePath.getLastPathComponent();
            Object[] objectArray = node.getVisibleChildrenObject(filter);
            if (objectArray == null) continue;
            model.fireTreeNodesChanged(node, (int[])objectArray[0], (Object[])objectArray[1]);
        }
    }

    static class CellRenderer
    extends DefaultTreeCellRenderer {
        private static Font standardFont = new Font("Helvetica", 0, 12);
        private static Font italicFont = new Font("Helvetica", 2, 12);
        private boolean isUnderlined;
        private Options.DisplayIro options;
        private Options.DisplayIro inverseOptions;

        public CellRenderer(Options.DisplayIro displayIro) {
            this.options = displayIro;
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            Component component = super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            this.isUnderlined = false;
            if (component instanceof JLabel) {
                JLabel jLabel = (JLabel)component;
                jLabel.setToolTipText(null);
                jTree.setToolTipText(null);
                Node node = (Node)object;
                Object object2 = node.getUserObject();
                if (object2 != null && object2 instanceof UML.Element) {
                    UML.Element element = (UML.Element)object2;
                    UML.Type type = element.getElementType();
                    if (type != null) {
                        jLabel.setText(element.toString(this.options));
                        if (this.options.getAbstractItalic() && element.isAbstract()) {
                            jLabel.setFont(italicFont);
                        } else {
                            jLabel.setFont(standardFont);
                        }
                        if (this.options.getStaticUlined() && element.isStatic()) {
                            this.isUnderlined = true;
                        }
                        this.inverseOptions = this.options.getInverseOptions();
                        jLabel.setToolTipText(element.toString(this.inverseOptions) + " ");
                        jTree.setToolTipText(element.toString(this.inverseOptions) + " ");
                        ImageIcon imageIcon = type.getIcon();
                        if (imageIcon != null) {
                            jLabel.setIcon(imageIcon);
                        }
                    }
                } else {
                    jLabel.setFont(standardFont);
                }
            }
            return component;
        }

        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            if (this.isUnderlined) {
                int n = this.getIcon().getIconWidth() + Math.max(0, this.getIconTextGap() - 1);
                graphics.setColor(Color.black);
                graphics.drawLine(n, this.getHeight() - 2, this.getWidth() - 2, this.getHeight() - 2);
            }
        }
    }

    static class Node
    extends DefaultMutableTreeNode {
        private Object pos = null;

        public Node(UML.Element element) {
            super(element);
        }

        public Node(String string) {
            super(string);
        }

        public final void setPosition(Object object) {
            this.pos = object;
        }

        public final Object getPosition() {
            return this.pos;
        }

        public final void alphaSort() {
            ArrayList<Node> arrayList = new ArrayList<Node>();
            if (this.children != null && this.children.size() > 0) {
                HashMap<String, Node> hashMap = new HashMap<String, Node>(this.children.size());
                for (int i = 0; i < this.children.size(); ++i) {
                    Node node = (Node)this.children.get(i);
                    UML.Element element = node.getElement();
                    try {
                        UML.Operation operation = (UML.Operation)element;
                        Options.Display display = new Options.Display();
                        display.setShowArguments(true);
                        String string = operation.getName() + "(" + operation.listArgs(display) + ")";
                        hashMap.put(string, node);
                        continue;
                    }
                    catch (ClassCastException classCastException) {
                        if (element.isInterface() || element.isClass()) {
                            node.alphaSort();
                        }
                        arrayList.add(node);
                    }
                }
                Object[] objectArray = hashMap.keySet().toArray(new String[hashMap.size()]);
                Arrays.sort(objectArray);
                for (int i = 0; i < objectArray.length; ++i) {
                    arrayList.add((Node)hashMap.get(objectArray[i]));
                }
                this.children.removeAllElements();
                this.children.addAll(arrayList);
            }
        }

        public TreePath getPathFrom(Node node) {
            Enumeration<TreeNode> enumeration = this.pathFromAncestorEnumeration(node);
            Vector<Node> vector = new Vector<Node>();
            int n = 0;
            while (enumeration.hasMoreElements()) {
                ++n;
                Node node2 = (Node)enumeration.nextElement();
                vector.addElement(node2);
            }
            Object[] objectArray = new Node[vector.size()];
            vector.copyInto(objectArray);
            return new TreePath(objectArray);
        }

        public final boolean isVisible(Options.FilterIro filterIro) {
            if (this.userObject instanceof UML.Element) {
                return ((UML.Element)this.getUserObject()).isVisible(filterIro);
            }
            return true;
        }

        public final UML.Element getElement() {
            if (this.userObject instanceof UML.Element) {
                return (UML.Element)this.userObject;
            }
            return null;
        }

        public UML.Type getElementType() {
            if (this.userObject instanceof UML.Element) {
                return ((UML.Element)this.userObject).getElementType();
            }
            return null;
        }

        public void setName(String string) {
            if (this.userObject instanceof UML.Element) {
                ((UML.Element)this.userObject).setName(string);
            } else {
                this.userObject = string;
            }
        }

        public final int getVisibleIndex(Options.FilterIro filterIro) {
            Node node = (Node)this.getParent();
            if (node == null) {
                return -1;
            }
            Vector vector = node.children;
            int n = -1;
            for (int i = 0; i < vector.size(); ++i) {
                Node node2 = (Node)vector.elementAt(i);
                Object object = node2.userObject;
                if (((UML.Element)object).isVisible(filterIro)) {
                    ++n;
                    if (node2 == this) {
                        return n;
                    }
                }
                if (node2 != this) continue;
                return -1;
            }
            throw new ArrayIndexOutOfBoundsException("index unmatched");
        }

        public Object[] getVisibleChildrenObject(Options.FilterIro filterIro) {
            int n = this.getChildCount(filterIro);
            if (n > 0) {
                Object[] objectArray = new Object[n];
                int[] nArray = new int[n];
                int n2 = -1;
                for (int i = 0; i < this.children.size(); ++i) {
                    Node node = (Node)this.children.elementAt(i);
                    Object object = node.userObject;
                    if (!((UML.Element)object).isVisible(filterIro)) continue;
                    nArray[++n2] = n2;
                    objectArray[n2] = node;
                }
                return new Object[]{nArray, objectArray};
            }
            return null;
        }

        public final Node getChildAt(int n, Options.FilterIro filterIro) {
            if (this.children == null) {
                throw new ArrayIndexOutOfBoundsException("node has no children");
            }
            int n2 = -1;
            int n3 = -1;
            Enumeration enumeration = this.children.elements();
            while (enumeration.hasMoreElements()) {
                Object object = ((Node)enumeration.nextElement()).userObject;
                if (((UML.Element)object).isVisible(filterIro)) {
                    ++n3;
                }
                ++n2;
                if (n3 != n) continue;
                return (Node)this.children.elementAt(n2);
            }
            throw new ArrayIndexOutOfBoundsException("index unmatched");
        }

        public final int getChildCount(Options.FilterIro filterIro) {
            if (this.children == null) {
                return 0;
            }
            int n = 0;
            Enumeration enumeration = this.children.elements();
            while (enumeration.hasMoreElements()) {
                Object object = ((Node)enumeration.nextElement()).userObject;
                if (!((UML.Element)object).isVisible(filterIro)) continue;
                ++n;
            }
            return n;
        }
    }

    static class Model
    extends DefaultTreeModel {
        private Options.FilterIro filterOpt = null;

        public Model(TreeNode treeNode) {
            super(treeNode);
        }

        public void setFilterOptions(Options.FilterIro filterIro) {
            this.filterOpt = filterIro;
        }

        public Options.FilterIro getFilterOptions() {
            return this.filterOpt;
        }

        final void fireTreeNodesChanged(TreeNode treeNode, int[] nArray, Object[] objectArray) {
            super.fireTreeNodesChanged(this, this.getPathToRoot(treeNode), nArray, objectArray);
        }

        public Object getChild(Object object, int n) {
            if (this.filterOpt != null) {
                return ((Node)object).getChildAt(n, this.filterOpt);
            }
            return ((Node)object).getChildAt(n);
        }

        public int getChildCount(Object object) {
            if (this.filterOpt != null) {
                return ((Node)object).getChildCount(this.filterOpt);
            }
            return ((Node)object).getChildCount();
        }

        public boolean isLeaf(Object object) {
            return this.getChildCount(object) <= 0;
        }
    }
}

