/*
 * Decompiled with CFR 0.152.
 */
package gnu.java;

import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;

class JSLineBreaker {
    private static final int BEFORE = 0;
    private static final int AFTER = 1;
    private String[] prefs = new String[]{"().", "()", ").", "+=", "-=", "*=", "/=", "%=", "^=", "||", "&&", "==", "!=", ">=", "<=", "(", ")", "[", "]", "?", ":", ",", ";", "=", "<", ">", "+", "-", "*", "/", "&", "|", "^"};
    private static Hashtable prefTable = new Hashtable();
    private Vector brokenLineVector;
    private StringBuffer wsBuffer;
    private char quoteChar;
    private boolean isInQuote;
    private boolean isInComment;
    private boolean isNestedConnection = true;
    private boolean isCut;
    private boolean isLineComment;
    private int parenDepth;
    private int breakDepth;
    private int preferredLineLength = 70;
    private int lineLengthDeviation = 5;
    private LineBreak previousLineBreak = null;

    JSLineBreaker() {
        this.init();
    }

    void init() {
        this.brokenLineVector = new Vector();
        this.parenDepth = 0;
        this.breakDepth = 0;
        this.isInQuote = false;
        this.isInComment = false;
        this.isCut = false;
        this.isLineComment = false;
        this.wsBuffer = new StringBuffer();
    }

    void setPreferredLineLength(int n) {
        this.preferredLineLength = n;
    }

    void setLineLengthDeviation(int n) {
        this.lineLengthDeviation = n;
    }

    void setNestedConnection(boolean bl) {
        this.isNestedConnection = bl;
    }

    void breakLine(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        Stack stack = new Stack();
        String string2 = "";
        boolean bl = false;
        char c = ' ';
        char c2 = '\u0000';
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        int n = 0;
        if (string.trim().length() == 0) {
            this.brokenLineVector.addElement("");
            return;
        }
        c = string.charAt(0);
        int n2 = 0;
        if (!this.isLineComment) {
            this.isCut = false;
        }
        this.isLineComment = false;
        if (!this.isCut) {
            this.wsBuffer = new StringBuffer();
            while ((c == ' ' || c == '\t') && n2 < string.length() - 1) {
                this.wsBuffer.append(c);
                c = string.charAt(++n2);
            }
        }
        for (int i = n2; i < string.length(); ++i) {
            int n3;
            Object object;
            int n4;
            if (c != ' ' && c != '\t') {
                c2 = c;
            }
            c = string.charAt(i);
            if (bl) {
                stringBuffer.append(c);
                bl = false;
                continue;
            }
            if (!this.isInComment && !this.isLineComment && string.regionMatches(false, i, "\\\\", 0, 2)) {
                stringBuffer.append("\\\\");
                ++i;
                continue;
            }
            if (!this.isInComment && !this.isLineComment && c == '\\') {
                stringBuffer.append(c);
                bl = true;
                continue;
            }
            if (!this.isInQuote && !this.isInComment && !this.isLineComment && string.regionMatches(false, i, "//", 0, 2)) {
                this.isLineComment = true;
                stringBuffer.append("//");
                ++i;
                continue;
            }
            if (!this.isInQuote && !this.isInComment && !this.isLineComment && string.regionMatches(false, i, "/*", 0, 2)) {
                this.isInComment = true;
                stringBuffer.append("/*");
                ++i;
                continue;
            }
            if (!this.isInQuote && (this.isInComment || this.isLineComment) && string.regionMatches(false, i, "*/", 0, 2)) {
                this.isInComment = false;
                stringBuffer.append("*/");
                ++i;
                continue;
            }
            if (this.isInComment || this.isLineComment) {
                stringBuffer.append(c);
                continue;
            }
            if (c == '\"' || c == '\'') {
                if (!this.isInQuote) {
                    this.quoteChar = c;
                    this.isInQuote = true;
                } else if (this.quoteChar == c) {
                    this.isInQuote = false;
                    stringBuffer.append(c);
                    continue;
                }
            }
            if (this.isInQuote) {
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append(c);
            for (n4 = 0; n4 < this.prefs.length; ++n4) {
                object = this.prefs[n4];
                if (!string.regionMatches(false, i, (String)object, 0, ((String)object).length())) continue;
                n3 = 1;
                if (c == '(' || c == '[' || c == ')' || c == ']') {
                    if (!("(".equals(object) || c == '[' || c != ')' && c != ']')) {
                        --this.parenDepth;
                    }
                    this.breakDepth = ++this.parenDepth;
                    if (c == ')' || c == ']' || ((String)object).startsWith("()")) {
                        ++this.breakDepth;
                    }
                    n3 = c == '(' || c == '[' ? (c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z' || c2 >= '0' && c2 <= '9' || c2 == '.' ? 1 : 0) : 1;
                }
                if (((String)object).length() > 1) {
                    stringBuffer.append(((String)object).substring(1));
                    i += ((String)object).length() - 1;
                }
                this.registerLineBreak(stack, new LineBreak((String)object, stringBuffer.length() + n, this.breakDepth, n3));
                this.breakDepth = this.parenDepth;
                break;
            }
            n4 = stringBuffer.length() + this.wsBuffer.length() + string2.length() + (this.isCut ? 8 : 0);
            object = null;
            if (n4 > this.preferredLineLength && i < string.length() - this.lineLengthDeviation) {
                while (!stack.isEmpty()) {
                    object = (LineBreak)stack.elementAt(0);
                    if (((LineBreak)object).breakWhere - n >= 1) break;
                    object = null;
                    stack.removeElementAt(0);
                }
                if (object != null) {
                    stack.removeElementAt(0);
                }
            }
            if (object == null || (n3 = ((LineBreak)object).breakWhere - n - (((LineBreak)object).breakType == 0 ? ((LineBreak)object).breakStr.length() : 0)) < 8) continue;
            StringBuffer stringBuffer2 = new StringBuffer();
            String string3 = stringBuffer.toString();
            String string4 = string3.substring(0, n3);
            stringBuffer2.append(string4);
            this.addBrokenLine(this.wsBuffer.toString(), stringBuffer2.toString(), (LineBreak)object, this.breakDepth, this.isCut);
            n += n3;
            stringBuffer = new StringBuffer(string3.substring(n3));
            this.isCut = true;
        }
        StringBuffer stringBuffer3 = new StringBuffer();
        stringBuffer3.append(stringBuffer);
        this.addBrokenLine(this.wsBuffer.toString(), stringBuffer3.toString(), null, this.breakDepth, this.isCut);
    }

    private void registerLineBreak(Stack stack, LineBreak lineBreak) {
        LineBreak lineBreak2;
        while (!stack.isEmpty() && this.compare(lineBreak2 = (LineBreak)stack.peek(), lineBreak) < 0) {
            stack.pop();
        }
        stack.push(lineBreak);
    }

    private void addBrokenLine(String string, String string2, LineBreak lineBreak, int n, boolean bl) {
        boolean bl2 = false;
        string2 = string2.trim();
        if (this.previousLineBreak != null) {
            String string3 = (String)this.brokenLineVector.lastElement();
            if ((string2.length() + string3.length() <= this.preferredLineLength + this.lineLengthDeviation || string2.startsWith("{")) && (lineBreak == null || this.isNestedConnection && !",".equals(this.previousLineBreak.breakStr) || lineBreak.breakDepth < this.previousLineBreak.breakDepth || lineBreak.breakDepth == this.previousLineBreak.breakDepth && (!this.isNestedConnection && !",".equals(this.previousLineBreak.breakStr) || ",".equals(lineBreak.breakStr) || ";".equals(lineBreak.breakStr) || ")".equals(lineBreak.breakStr) || "]".equals(lineBreak.breakStr)))) {
                this.brokenLineVector.setElementAt(string3 + " " + string2, this.brokenLineVector.size() - 1);
                bl2 = true;
            }
        }
        if (!bl2) {
            if (bl && (this.previousLineBreak == null || !",".equals(this.previousLineBreak.breakStr) || this.previousLineBreak.breakDepth != 0)) {
                string2 = "        " + string2;
            }
            string2 = string + string2;
            this.brokenLineVector.addElement(string2);
        }
        this.previousLineBreak = lineBreak;
    }

    private int compare(LineBreak lineBreak, LineBreak lineBreak2) {
        int n;
        if (lineBreak.breakDepth < lineBreak2.breakDepth) {
            return 1;
        }
        if (lineBreak.breakDepth > lineBreak2.breakDepth) {
            return -1;
        }
        int n2 = (Integer)prefTable.get(lineBreak.breakStr);
        if (n2 < (n = ((Integer)prefTable.get(lineBreak2.breakStr)).intValue())) {
            return 1;
        }
        return -1;
    }

    boolean hasMoreBrokenLines() {
        return this.brokenLineVector.size() > 0;
    }

    String nextBrokenLine() {
        if (!this.hasMoreBrokenLines()) {
            String string = "";
            return "";
        }
        String string = (String)this.brokenLineVector.firstElement();
        this.brokenLineVector.removeElementAt(0);
        return string;
    }

    static {
        prefTable.put("()", new Integer(80));
        prefTable.put("().", new Integer(90));
        prefTable.put(").", new Integer(90));
        prefTable.put("(", new Integer(80));
        prefTable.put(")", new Integer(80));
        prefTable.put("[", new Integer(80));
        prefTable.put("]", new Integer(80));
        prefTable.put(",", new Integer(10));
        prefTable.put(";", new Integer(5));
        prefTable.put("=", new Integer(20));
        prefTable.put("+=", new Integer(20));
        prefTable.put("-=", new Integer(20));
        prefTable.put("*=", new Integer(20));
        prefTable.put("/=", new Integer(20));
        prefTable.put("|=", new Integer(20));
        prefTable.put("&=", new Integer(20));
        prefTable.put("^=", new Integer(20));
        prefTable.put("?", new Integer(25));
        prefTable.put(":", new Integer(25));
        prefTable.put("||", new Integer(30));
        prefTable.put("&&", new Integer(30));
        prefTable.put("==", new Integer(40));
        prefTable.put("!=", new Integer(40));
        prefTable.put(">=", new Integer(40));
        prefTable.put("<=", new Integer(40));
        prefTable.put(">", new Integer(40));
        prefTable.put("<", new Integer(40));
        prefTable.put("+", new Integer(50));
        prefTable.put("-", new Integer(50));
        prefTable.put("*", new Integer(60));
        prefTable.put("/", new Integer(60));
        prefTable.put("%", new Integer(60));
        prefTable.put("&", new Integer(70));
        prefTable.put("|", new Integer(70));
        prefTable.put("^", new Integer(70));
    }

    class LineBreak {
        String breakStr;
        int breakWhere;
        int breakDepth;
        int breakType;

        LineBreak(String string, int n, int n2, int n3) {
            this.breakStr = string;
            this.breakWhere = n;
            this.breakDepth = n2;
            this.breakType = n3;
        }

        void dump() {
            System.out.println("LB: str=" + this.breakStr + " wh=" + this.breakWhere + " dep=" + this.breakDepth + " tp=" + this.breakType);
        }
    }
}

