/*
 * Decompiled with CFR 0.152.
 */
package gnu.gui;

import java.awt.Color;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.FilteredImageSource;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;

public class JextButton
extends JButton {
    private MouseHandler _mouseListener;
    private ImageIcon grayedIcon;
    private ImageIcon coloredIcon;
    private Color nColor;
    private static Color commonHighlightColor = new Color(192, 192, 210);
    private static boolean rollover = true;
    private static boolean blockHighlightChange = false;

    public static void setRollover(boolean bl) {
        rollover = bl;
    }

    public static void setHighlightColor(Color color) {
        if (!blockHighlightChange) {
            commonHighlightColor = color;
        }
    }

    public static Color getHighlightColor() {
        return commonHighlightColor;
    }

    public static void blockHighlightChange() {
        blockHighlightChange = true;
    }

    public static void unBlockHighlightChange() {
        blockHighlightChange = false;
    }

    private void init() {
        this._mouseListener = new MouseHandler();
        if (rollover) {
            this.setBorderPainted(false);
            this.addMouseListener(this._mouseListener);
        } else {
            this.nColor = this.getBackground();
            this.addMouseListener(this._mouseListener);
        }
    }

    public JextButton() {
        this.init();
    }

    public JextButton(Icon icon) {
        super(icon);
        this.init();
    }

    public JextButton(String string) {
        super(string);
        this.init();
    }

    public JextButton(String string, Icon icon) {
        super(string, icon);
        this.init();
    }

    public void setGrayed(boolean bl) {
        if (this.coloredIcon == null) {
            this.coloredIcon = (ImageIcon)this.getIcon();
        }
        if (bl && this.getRolloverIcon() == null) {
            GrayFilter grayFilter = new GrayFilter(true, 35);
            Image image = Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(this.coloredIcon.getImage().getSource(), grayFilter));
            this.grayedIcon = new ImageIcon(image);
            this.setRolloverIcon(this.coloredIcon);
        }
        this.setIcon(bl ? this.grayedIcon : this.coloredIcon);
        this.setRolloverEnabled(bl);
    }

    protected void finalize() throws Throwable {
        this.removeMouseListener(this._mouseListener);
        super.finalize();
        this._mouseListener = null;
        this.grayedIcon = null;
        this.coloredIcon = null;
        this.nColor = null;
    }

    class MouseHandler
    extends MouseAdapter {
        MouseHandler() {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            if (JextButton.this.isEnabled()) {
                if (rollover) {
                    JextButton.this.setBorderPainted(true);
                } else {
                    JextButton.this.setBackground(commonHighlightColor);
                }
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (JextButton.this.isEnabled()) {
                if (rollover) {
                    JextButton.this.setBorderPainted(false);
                } else {
                    JextButton.this.setBackground(JextButton.this.nColor);
                }
            }
        }
    }
}

