/*
 * Decompiled with CFR 0.152.
 */
package madkit.utils.common;

import java.util.StringTokenizer;

public class Version {
    private final int _major;
    private final int _minor;
    private final int _release;

    public Version(int n, int n2, int n3) {
        this._major = n;
        this._minor = n2;
        this._release = n3;
    }

    public boolean isHigher(Version version) {
        if (this._major < version.getMajorVersion()) {
            return true;
        }
        if (this._minor < version.getMinorVersion()) {
            return true;
        }
        return this._release < version.getReleaseVersion();
    }

    public int getMajorVersion() {
        return this._major;
    }

    public int getMinorVersion() {
        return this._minor;
    }

    public int getReleaseVersion() {
        return this._release;
    }

    public String toString() {
        return this._major + "." + this._minor + "." + this._release;
    }

    public static Version valueOf(String string) {
        if (string.equalsIgnoreCase("null")) {
            string = "0.0.0";
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        int[] nArray = new int[3];
        for (int i = 0; i < 3; ++i) {
            String string2 = "";
            if (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
            }
            if (string2.equals("")) {
                string2 = "0";
            }
            nArray[i] = Integer.valueOf(string2);
        }
        return new Version(nArray[0], nArray[1], nArray[2]);
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Version) {
            Version version = (Version)object;
            return this._major == version.getMajorVersion() && this._minor == version.getMinorVersion() && this._release == version._release;
        }
        return false;
    }
}

