/*
 * Decompiled with CFR 0.152.
 */
package madkit.system;

import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import madkit.boot.Madkit;
import madkit.kernel.Utils;
import madkit.utils.common.PropertyFile;
import madkit.utils.common.Version;

public class PluginInformation
implements Serializable {
    public static final int UP_TO_DATE = 0;
    public static final int NEEDS_UPDATE = 1;
    public static final int NEW = 2;
    private String name;
    private Version version;
    private int size;
    private File directory;
    private String description;
    private String agentNames;
    private Collection actions = new Vector();
    private String docPath;
    private String system;
    private String authorName;
    private File desktopFile;
    private File buildFile;
    private String docRef;
    private String category;
    private String depends;
    private Vector dependList;
    private String requires;
    private Vector requireList;

    public String getDepends() {
        return this.depends;
    }

    public void parseDepends() {
        this.dependList = new Vector();
        if (this.depends == null) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.depends, ", ");
        while (stringTokenizer.hasMoreTokens()) {
            this.dependList.add(stringTokenizer.nextToken());
        }
    }

    public Vector getDependList() {
        return this.dependList;
    }

    synchronized void addDepend(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            this.dependList.add(stringArray[i]);
        }
        this.compileDepends();
    }

    public synchronized void addDepend(String string) {
        this.dependList.add(string);
        this.compileDepends();
    }

    void compileDepends() {
        String string = "";
        Iterator iterator = this.dependList.iterator();
        while (iterator.hasNext()) {
            string = string + iterator.next();
            if (!iterator.hasNext()) continue;
            string = string + ", ";
        }
        this.depends = string;
    }

    public synchronized void removeDepend(String string) {
        this.dependList.remove(string);
        this.compileDepends();
    }

    public String getRequires() {
        return this.requires;
    }

    public void parseRequires() {
        this.requireList = new Vector();
        if (this.requires == null) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.requires, ", ");
        while (stringTokenizer.hasMoreTokens()) {
            this.requireList.add(stringTokenizer.nextToken());
        }
    }

    public Vector getRequireList() {
        return this.requireList;
    }

    public synchronized void addRequire(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            this.requireList.add(stringArray[i]);
        }
        this.compileRequire();
    }

    public synchronized void addRequire(String string) {
        this.requireList.add(string);
        this.requires = this.requires + ", " + string;
    }

    void compileRequire() {
        String string = "";
        Iterator iterator = this.requireList.iterator();
        while (iterator.hasNext()) {
            string = string + iterator.next();
            if (!iterator.hasNext()) continue;
            string = string + ", ";
        }
        this.requires = string;
    }

    public synchronized void removeRequire(String string) {
        this.requireList.remove(string);
        this.compileRequire();
    }

    protected PluginInformation(File file) {
        this.directory = file;
    }

    public String getDocPath() {
        return this.docPath;
    }

    public final String getAuthorName() {
        return this.authorName;
    }

    public final void setAuthorName(String string) {
        this.authorName = string;
    }

    public String getSystem() {
        return this.system;
    }

    public void setSystem(String string) {
        this.system = string;
    }

    public final String getDescription() {
        return this.description;
    }

    public final void setDescription(String string) {
        this.description = string;
    }

    public final File getDirectory() {
        return this.directory;
    }

    public final File getDesktopIniFile() {
        return this.desktopFile;
    }

    public final File getBuildFile() {
        return this.desktopFile;
    }

    public final String getName() {
        return this.name;
    }

    public final int getSize() {
        return this.size;
    }

    public final Version getVersion() {
        return this.version;
    }

    public final void setVersion(Version version) {
        this.version = version;
    }

    public final void setVersion(String string) {
        this.setVersion(Version.valueOf((String)string));
    }

    public final String getDocFile() {
        return this.docRef;
    }

    public final String getCategory() {
        return this.category;
    }

    public final String getAgentNames() {
        return this.agentNames;
    }

    boolean updateDesktopIniFile() {
        if (this.directory != null && this.directory.isDirectory()) {
            this.name = Utils.getFileNameFromPath((String)this.directory.getPath());
            File file = new File(this.directory, "desktop.ini");
            if (!file.isFile()) {
                return false;
            }
            this.desktopFile = file;
            return true;
        }
        return false;
    }

    boolean updateInfo() {
        if (this.directory != null && this.directory.isDirectory()) {
            this.name = Utils.getFileNameFromPath((String)this.directory.getPath());
            File file = new File(this.directory, this.name + ".properties");
            if (!file.isFile()) {
                if (Madkit.debug) {
                    System.out.println("Warning: the plugin " + this.name + " is not a correct plugin");
                }
                return false;
            }
            File file2 = new File(this.directory, "build.xml");
            if (file2.isFile()) {
                this.buildFile = file2;
            }
            PropertyFile propertyFile = new PropertyFile();
            propertyFile.loadFrom(file);
            this.updateInfo(propertyFile);
            this.updateDesktopIniFile();
            return true;
        }
        System.err.println("Warning: the plugin " + this.getName() + " does not seem to have been correctly installed");
        return false;
    }

    void updateInfo(PropertyFile propertyFile) {
        File file;
        this.name = propertyFile.getProperty("madkit.plugin.name");
        this.agentNames = propertyFile.getProperty("madkit.plugin.agents");
        this.authorName = propertyFile.getProperty("madkit.plugin.author");
        this.version = Version.valueOf((String)propertyFile.getProperty("madkit.plugin.version"));
        this.description = propertyFile.getProperty("madkit.plugin.description");
        this.depends = propertyFile.getProperty("madkit.plugin.depend");
        this.requires = propertyFile.getProperty("madkit.plugin.requires");
        this.docRef = propertyFile.getProperty("madkit.plugin.docfile");
        this.system = propertyFile.getProperty("madkit.plugin.system");
        if (this.system == null || this.system.equals("${system.plugin}")) {
            this.system = "false";
        }
        this.category = propertyFile.getProperty("madkit.plugin.category");
        if (this.docRef != null && this.docRef != "${docfile}" && (file = new File(this.directory, "docs" + File.separator + this.docRef)).isFile()) {
            this.docPath = file.getPath();
        }
        this.parseDepends();
        this.parseRequires();
    }

    public String toString() {
        return this.getName() + ": " + this.getDescription() + ", " + this.getAuthorName() + ", " + this.getVersion();
    }
}

