/*
 * Decompiled with CFR 0.152.
 */
package madkit.system;

import java.text.SimpleDateFormat;
import java.util.Date;
import madkit.kernel.AGRTrio;
import madkit.kernel.Agent;
import madkit.kernel.AgentAddress;
import madkit.kernel.KernelMessage;
import madkit.kernel.Message;
import madkit.system.OrganizationTracerGUI;

public class OrganizationTracer
extends Agent {
    AgentAddress mykernel;
    boolean debug = true;
    OrganizationTracerGUI gui;
    boolean parseTime = true;

    public boolean getParseTime() {
        return this.parseTime;
    }

    public void setParseTime(boolean bl) {
        this.parseTime = bl;
    }

    public void initGUI() {
        this.gui = new OrganizationTracerGUI();
        this.setGUIObject(this.gui);
    }

    public void activate() {
        this.println("Activated");
        this.createGroup(false, "system", "system agents", null);
        this.requestRole("system", "tracer", null);
        this.mykernel = this.getAgentWithRole("system", "kernel");
        this.sendMessage(this.mykernel, (Message)new KernelMessage(22, 4));
        this.sendMessage(this.mykernel, (Message)new KernelMessage(22, 5));
        this.sendMessage(this.mykernel, (Message)new KernelMessage(22, 6));
        this.sendMessage(this.mykernel, (Message)new KernelMessage(22, 7));
    }

    public void live() {
        while (true) {
            Message message;
            if (!((message = this.waitNextMessage()) instanceof KernelMessage)) {
                continue;
            }
            this.handleMessage((KernelMessage)message);
        }
    }

    protected String showTime() {
        Date date = new Date();
        if (this.parseTime) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss SSSS");
            return simpleDateFormat.format(date);
        }
        return Long.toString(date.getTime());
    }

    protected void handleMessage(KernelMessage kernelMessage) {
        AGRTrio aGRTrio;
        if (kernelMessage.getOperation() == 4) {
            aGRTrio = (AGRTrio)kernelMessage.getArgument();
            if (this.hasGUI()) {
                this.gui.addMessage(aGRTrio.getAgent().getName(), "found_group", aGRTrio.getGroup(), "", this.showTime());
            } else {
                this.println("FOUND_GROUP <" + aGRTrio.getGroup() + "> by " + aGRTrio.getAgent().getName());
            }
        }
        if (kernelMessage.getOperation() == 5) {
            aGRTrio = (AGRTrio)kernelMessage.getArgument();
            if (this.hasGUI()) {
                this.gui.addMessage(aGRTrio.getAgent().getName(), "leave_group", aGRTrio.getGroup(), "", this.showTime());
            } else {
                this.println("LEAVE_GROUP <" + aGRTrio.getGroup() + "> by " + aGRTrio.getAgent().getName());
            }
        }
        if (kernelMessage.getOperation() == 6) {
            aGRTrio = (AGRTrio)kernelMessage.getArgument();
            if (this.hasGUI()) {
                this.gui.addMessage(aGRTrio.getAgent().getName(), "add_member_role", aGRTrio.getGroup(), aGRTrio.getRole(), this.showTime());
            } else {
                this.println("ADD_MEMBER_ROLE <" + aGRTrio.getGroup() + "> by " + aGRTrio.getAgent().getName());
            }
        }
        if (kernelMessage.getOperation() == 7) {
            aGRTrio = (AGRTrio)kernelMessage.getArgument();
            if (this.hasGUI()) {
                this.gui.addMessage(aGRTrio.getAgent().getName(), "remove_member_role", aGRTrio.getGroup(), aGRTrio.getRole(), this.showTime());
            } else {
                this.println("REMOVE_MEMBER_ROLE <" + aGRTrio.getGroup() + "> by " + aGRTrio.getAgent().getName());
            }
        }
    }
}

