/*
 * Decompiled with CFR 0.152.
 */
package madkit.system;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import madkit.kernel.AGRTrio;
import madkit.kernel.Agent;
import madkit.kernel.AgentAddress;
import madkit.kernel.KernelAddress;
import madkit.kernel.KernelMessage;
import madkit.kernel.Message;
import madkit.system.GroupObserverGUI;

public class GroupObserver
extends Agent {
    AgentAddress mykernel;
    boolean debug = true;
    GroupObserverGUI gui;
    String targetGroup;
    Vector agents;
    Hashtable orgdump;
    boolean showMessages = false;
    boolean parseTime = true;

    void setShowMessageState(boolean bl) {
        this.showMessages = bl;
    }

    public boolean getParseTime() {
        return this.parseTime;
    }

    public void setParseTime(boolean bl) {
        this.parseTime = bl;
    }

    public void initGUI() {
        this.gui = new GroupObserverGUI(this);
        this.setGUIObject(this.gui);
    }

    public void activate() {
        this.requestRole("public", "system", "tracer", null);
        this.mykernel = this.getAgentWithRole("system", "kernel");
        this.sendMessage(this.mykernel, (Message)new KernelMessage(14, 27));
        this.sendMessage(this.mykernel, (Message)new KernelMessage(22, 1));
        this.sendMessage(this.mykernel, (Message)new KernelMessage(22, 2));
        this.sendMessage(this.mykernel, (Message)new KernelMessage(22, 4));
        this.sendMessage(this.mykernel, (Message)new KernelMessage(22, 5));
        this.sendMessage(this.mykernel, (Message)new KernelMessage(22, 6));
        this.sendMessage(this.mykernel, (Message)new KernelMessage(22, 7));
        this.sendMessage(this.mykernel, (Message)new KernelMessage(22, 3));
        this.sendMessage(this.mykernel, (Message)new KernelMessage(22, 13));
        this.sendMessage(this.mykernel, (Message)new KernelMessage(22, 8));
        this.sendMessage(this.mykernel, (Message)new KernelMessage(22, 9));
        this.sendMessage(this.mykernel, (Message)new KernelMessage(22, 10));
        this.sendMessage(this.mykernel, (Message)new KernelMessage(22, 11));
        this.sendMessage(this.mykernel, (Message)new KernelMessage(22, 12));
    }

    public void enterGroup(String string) {
        if (this.targetGroup != null && !string.equals(this.targetGroup)) {
            this.leaveGroup(this.targetGroup);
        }
        if (string != null) {
            this.requestRole(string, "$MessageTracer", null);
            this.targetGroup = string;
        }
    }

    public void leaveGroups() {
        if (this.targetGroup != null) {
            this.leaveGroup(this.targetGroup);
            this.targetGroup = null;
        }
    }

    protected void requestDumpCommunities() {
        this.sendMessage(this.mykernel, (Message)new KernelMessage(14, 27));
    }

    protected Vector getAllGroups() {
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = this.orgdump.keys();
        while (enumeration.hasMoreElements()) {
            vector.addElement((String)enumeration.nextElement());
        }
        vector.removeElement("system");
        return vector;
    }

    public void live() {
        while (true) {
            Message message;
            if (!((message = this.waitNextMessage()) instanceof KernelMessage)) {
                continue;
            }
            this.handleMessage((KernelMessage)message);
        }
    }

    public Vector getAgents(String string) {
        if (string != null) {
            Vector<AgentAddress> vector = new Vector<AgentAddress>();
            String[] stringArray = this.getExistingRoles(this.targetGroup);
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                AgentAddress[] agentAddressArray = this.getAgentsWithRole(this.targetGroup, stringArray[i]);
                int n2 = agentAddressArray.length;
                for (int j = 0; j < n2; ++j) {
                    vector.addElement(agentAddressArray[j]);
                }
            }
            return vector;
        }
        return null;
    }

    protected String showTime() {
        Date date = new Date();
        if (this.parseTime) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss SSSS");
            return simpleDateFormat.format(date);
        }
        return Long.toString(date.getTime());
    }

    protected void handleMessage(KernelMessage kernelMessage) {
        Object object;
        if (kernelMessage.getOperation() == 22) {
            Hashtable hashtable = null;
            if (kernelMessage.getType() == 13) {
                hashtable = (Hashtable)kernelMessage.getArgument();
                Object object2 = kernelMessage.getSubject();
                if (!(object2 instanceof String)) {
                    object2 = "public";
                }
                this.orgdump = hashtable;
                if (this.hasGUI()) {
                    ((GroupObserverGUI)this.getGUIObject()).getTree().installOrg((String)object2, hashtable);
                }
            }
        } else if (kernelMessage.getOperation() == 27) {
            Map map = null;
            if (kernelMessage.getType() == 13) {
                map = (Map)kernelMessage.getArgument();
                if (this.hasGUI()) {
                    ((GroupObserverGUI)this.getGUIObject()).getTree().installCommunities(map);
                }
            }
        } else if (kernelMessage.getOperation() == 1) {
            Message message = (Message)kernelMessage.getArgument();
            if (this.hasGUI()) {
                if (this.showMessages) {
                    String string;
                    if (!(this.targetGroup == null || this.agents == null || this.agents.contains(message.getSender()) && this.agents.contains(message.getReceiver()))) {
                        return;
                    }
                    String string2 = message.getClass().getName();
                    string2 = string2.substring(string2.lastIndexOf(46) + 1);
                    if (this.parseTime) {
                        Date date = message.getCreationDate();
                        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss SSSS");
                        string = simpleDateFormat.format(date);
                    } else {
                        string = Long.toString(message.getCreationDate().getTime());
                    }
                    this.gui.addMessage(message.getSender().getName(), message.getReceiver().getName(), string2, message.toString(), string);
                }
            } else {
                this.println("Trace" + message);
            }
        } else if (kernelMessage.getOperation() == 2) {
            ArrayList arrayList = (ArrayList)kernelMessage.getArgument();
            String string = (String)arrayList.get(0);
            String string3 = (String)arrayList.get(1);
            Message message = (Message)arrayList.get(2);
            String string4 = message.getClass().getName();
            string4 = string4.substring(string4.lastIndexOf(46) + 1);
            if (this.hasGUI() && this.showMessages) {
                String string5;
                if (this.targetGroup != null && this.agents != null && !this.targetGroup.equals(string) && this.agents.contains(message.getSender())) {
                    return;
                }
                if (this.parseTime) {
                    Date date = message.getCreationDate();
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss SSSS");
                    string5 = simpleDateFormat.format(date);
                } else {
                    string5 = Long.toString(message.getCreationDate().getTime());
                }
                this.gui.addMessage(message.getSender().getName(), "<" + string + "," + string3 + ">", string4, message.toString(), string5);
            }
        } else if (kernelMessage.getOperation() == 11) {
            String string = (String)kernelMessage.getArgument();
            this.requestDumpCommunities();
        } else if (kernelMessage.getOperation() == 12) {
            String string = (String)kernelMessage.getArgument();
            if (this.hasGUI()) {
                this.gui.getTree().deleteCommunity(string);
            } else {
                this.println("REMOVE_COMMUNITY <" + string + "> ");
            }
        } else if (kernelMessage.getOperation() == 4) {
            this.agents = this.getAgents(this.targetGroup);
            AGRTrio aGRTrio = (AGRTrio)kernelMessage.getArgument();
            if (this.hasGUI()) {
                String string = aGRTrio.getGroup();
                String string6 = aGRTrio.getCommunity();
                this.gui.getTree().createGroup(string6, string, aGRTrio.getAgent().toString());
                this.gui.addAction(aGRTrio.getAgent().getName(), "createGroup", string6, string, "", this.showTime());
            } else {
                this.println("CREATE_GROUP <" + aGRTrio.getGroup() + "> by " + aGRTrio.getAgent().getName());
            }
        } else if (kernelMessage.getOperation() == 6) {
            this.agents = this.getAgents(this.targetGroup);
            AGRTrio aGRTrio = (AGRTrio)kernelMessage.getArgument();
            if (this.hasGUI()) {
                String string = aGRTrio.getGroup();
                String string7 = aGRTrio.getRole();
                String string8 = aGRTrio.getCommunity();
                this.gui.getTree().enterRole(string8, string, string7, aGRTrio.getAgent().toString());
                this.gui.addAction(aGRTrio.getAgent().getName(), "add_member_role", string8, string, string7, this.showTime());
            } else {
                this.println("ADD_MEMBER_ROLE <" + aGRTrio.getGroup() + "> by " + aGRTrio.getAgent().getName());
            }
        } else if (kernelMessage.getOperation() == 7) {
            this.agents = this.getAgents(this.targetGroup);
            AGRTrio aGRTrio = (AGRTrio)kernelMessage.getArgument();
            if (this.hasGUI()) {
                String string = aGRTrio.getGroup();
                String string9 = aGRTrio.getRole();
                String string10 = aGRTrio.getCommunity();
                this.gui.getTree().leaveRole(string10, string, string9, aGRTrio.getAgent().toString());
                this.gui.addAction(aGRTrio.getAgent().getName(), "remove_member_role", string10, string, string9, this.showTime());
            } else {
                this.println("REMOVE_MEMBER_ROLE <" + aGRTrio.getGroup() + "> by " + aGRTrio.getAgent().getName());
            }
        } else if (kernelMessage.getOperation() == 5) {
            this.agents = this.getAgents(this.targetGroup);
            AGRTrio aGRTrio = (AGRTrio)kernelMessage.getArgument();
            if (this.hasGUI()) {
                String string = aGRTrio.getGroup();
                String string11 = aGRTrio.getCommunity();
                this.gui.getTree().leaveGroup(string11, string, aGRTrio.getAgent().toString());
                this.gui.addAction(aGRTrio.getAgent().getName(), "leave_group", string11, string, "", this.showTime());
            } else {
                this.println("LEAVE_GROUP <" + aGRTrio.getGroup() + "> by " + aGRTrio.getAgent().getName());
            }
        } else if (kernelMessage.getOperation() == 3) {
            Object object3 = kernelMessage.getArgument();
            AgentAddress agentAddress = null;
            if (object3 instanceof AGRTrio) {
                agentAddress = ((AGRTrio)object3).getAgent();
            } else if (object3 instanceof AgentAddress) {
                agentAddress = (AgentAddress)object3;
            }
            if (this.hasGUI() && agentAddress != null) {
                this.gui.addAction(agentAddress.getName(), "kill_agent", "", "", "", this.showTime());
                this.gui.getTree().killAgent(agentAddress.toString());
            } else {
                this.println("KILL_AGENT " + agentAddress.getName());
            }
        } else if (kernelMessage.getOperation() == 9) {
            Object object4 = kernelMessage.getArgument();
            if (object4 instanceof KernelAddress) {
                String string = ((KernelAddress)object4).getHost();
                this.gui.setMessageDisplay("connection to " + string);
            }
        } else if (kernelMessage.getOperation() == 10 && (object = kernelMessage.getArgument()) instanceof KernelAddress) {
            String string = ((KernelAddress)object).getHost();
            this.gui.setMessageDisplay("disconnected from " + string);
        }
    }
}

