/*
 * Decompiled with CFR 0.152.
 */
package madkit.system;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import madkit.kernel.AgentAddress;
import madkit.kernel.KernelMessage;
import madkit.kernel.Message;
import madkit.kernel.StringMessage;
import madkit.system.EditorPanel;
import madkit.utils.agents.AbstractEditorAgent;

public class EditorAgent
extends AbstractEditorAgent {
    String targetCommunity = "public";
    String targetGroup;
    String targetRole;
    Hashtable orgdump;
    String fileToEdit = null;
    boolean showInMessages = true;
    boolean showOutMessages = true;
    AgentAddress mykernel;

    void showInMessages(boolean bl) {
        this.showInMessages = bl;
    }

    void showOutMessages(boolean bl) {
        this.showOutMessages = bl;
    }

    public EditorAgent() {
    }

    public EditorAgent(String string) {
        this.fileToEdit = string;
    }

    public void initGUI() {
        this.display = new EditorPanel(this);
        this.setGUIObject(this.display);
        if (this.fileToEdit != null) {
            this.display.setCurrentFile(this.fileToEdit);
            this.display.readFile(this.fileToEdit);
        }
    }

    public void enterGroupRole(String string, String string2, String string3, String string4) {
        ((EditorPanel)this.display).print(":: Request role " + string3 + " in " + string2 + " within " + string);
        int n = this.requestRole(string, string2, string3, string4);
        if (n == 1) {
            ((EditorPanel)this.display).println(" with success");
        } else {
            ((EditorPanel)this.display).println(" and failed");
        }
    }

    public void setTargetCommunity(String string) {
        this.targetCommunity = string;
        ((EditorPanel)this.display).showCurrentCommunity(string);
    }

    public void setTargetGroup(String string) {
        this.targetGroup = string;
        ((EditorPanel)this.display).showCurrentGroup(string);
    }

    public void setTargetRole(String string) {
        this.targetRole = string;
        ((EditorPanel)this.display).showCurrentRole(string);
    }

    public void setTarget(String string, String string2) {
        this.setTarget(null, string, string2);
    }

    public void setTarget(String string, String string2, String string3) {
        if (string == null) {
            string = "public";
        }
        this.targetCommunity = string;
        if (string2 == null) {
            return;
        }
        this.targetGroup = string2;
        this.targetRole = string3;
        ((EditorPanel)this.display).showCurrentCommunity(string);
        ((EditorPanel)this.display).showCurrentGroup(string2);
        ((EditorPanel)this.display).showCurrentRole(string3);
    }

    public void leaveGR(String string, String string2, String string3) {
        if (string2 == null) {
            return;
        }
        this.leaveRole(string, string2, string3);
    }

    public void activate() {
        this.createGroup(false, "system", null, null);
        this.mykernel = this.getAgentWithRole("system", "kernel");
        if (this.mykernel == null) {
            System.err.println("ERROR : invalid kernel agent: " + this.mykernel);
        }
        this.sendMessage(this.mykernel, (Message)new KernelMessage(14, 22));
    }

    public void handleMessage(Message message) {
        String string = null;
        if (message instanceof StringMessage) {
            string = ((StringMessage)message).getString();
            if (this.showInMessages) {
                ((EditorPanel)this.display).println("<< receiving message from " + message.getSender() + ">> \n" + string);
            } else {
                ((EditorPanel)this.display).print(string);
            }
        }
        if (message instanceof KernelMessage) {
            Hashtable hashtable = null;
            KernelMessage kernelMessage = (KernelMessage)message;
            if (kernelMessage.getType() == 13) {
                this.orgdump = hashtable = (Hashtable)kernelMessage.getArgument();
            }
        }
    }

    protected void requestJoinGroup() {
        this.sendMessage(this.mykernel, (Message)new KernelMessage(14, 22));
    }

    protected Vector getAllGroups() {
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = this.orgdump.keys();
        while (enumeration.hasMoreElements()) {
            vector.addElement((String)enumeration.nextElement());
        }
        vector.removeElement("system");
        return vector;
    }

    protected void joinGroupInteractively(Hashtable hashtable) {
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            vector.addElement((String)enumeration.nextElement());
        }
        ((EditorPanel)this.display).joinGroup(vector);
    }

    public String[] askGetGroups() {
        return this.getExistingGroups();
    }

    public String[] askGetRoles(String string) {
        return this.getExistingRoles(string);
    }

    public String[] askGetOwnRoles(String string) {
        return this.getExistingRoles(string);
    }

    protected void clearRole() {
        if (this.targetRole != null && this.targetGroup != null) {
            this.leaveRole(this.targetGroup, this.targetRole);
        }
        this.targetRole = null;
        ((EditorPanel)this.display).showCurrentRole("none");
    }

    public void live() {
        while (true) {
            Message message = this.waitNextMessage();
            this.handleMessage(message);
        }
    }

    public void sendString(String string) {
        if (this.showOutMessages) {
            ((EditorPanel)this.display).println(">> " + string);
        }
        if (this.getRecipient() != null) {
            this.sendMessage(this.getRecipient(), (Message)new StringMessage(string));
        }
        if (this.targetGroup != null && this.targetRole != null) {
            AgentAddress[] agentAddressArray = this.getAgentsWithRole(this.targetCommunity, this.targetGroup, this.targetRole);
            for (int i = 0; i < agentAddressArray.length; ++i) {
                if (agentAddressArray[i].equals((Object)this.getAddress())) continue;
                this.sendMessage(agentAddressArray[i], (Message)new StringMessage(string));
            }
        }
    }
}

