/*
 * Decompiled with CFR 0.152.
 */
package madkit.docbrowser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import madkit.docbrowser.NavigationBar;

class JBrowseButton
extends JPanel
implements ActionListener {
    public static final int BACK_BROWSE = 0;
    public static final int FORWARD_BROWSE = 1;
    public static final int RELOAD_BROWSE = 2;
    public static final String BIG_ICON = "big";
    private int _type;
    private String _icon_size = "big";
    private boolean _showText = true;
    private String _buttonText = "?";
    private Vector _stack = new Vector();
    private JButton _button;
    private String _currentURL;
    private NavigationBar _browser;
    private JBrowseButton _forward;

    public JBrowseButton(NavigationBar navigationBar, int n) {
        this(navigationBar, n, BIG_ICON);
    }

    public JBrowseButton(NavigationBar navigationBar, int n, String string) {
        this._type = n;
        this._icon_size = string;
        this._browser = navigationBar;
        String string2 = "leftarrow_";
        switch (this._type) {
            case 0: {
                this._buttonText = "Back";
                string2 = "leftarrow_";
                break;
            }
            case 1: {
                this._buttonText = "Forward";
                string2 = "rightarrow_";
                break;
            }
            case 2: {
                this._buttonText = "Reload";
                string2 = "reload_";
                break;
            }
        }
        ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("/images/" + string2 + this._icon_size + ".png"));
        this._button = new JButton(imageIcon);
        this._button.setToolTipText(this._buttonText);
        this._button.addActionListener(this);
        this.setLayout(new BorderLayout());
        this.add((Component)this._button, "Center");
        this.checkEnable();
    }

    private void checkEnable() {
        if (this._type == 0 || this._type == 1) {
            this._button.setEnabled(!this._stack.isEmpty());
        } else {
            this._button.setEnabled(true);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        switch (this._type) {
            case 0: {
                String string = (String)this._stack.remove(0);
                this._forward.addToStack(this._currentURL);
                this._browser.changePage(string, this._type);
                break;
            }
            case 1: {
                this._browser.changePage((String)this._stack.remove(0), this._type);
                break;
            }
            case 2: {
                this._browser.changePage(this._currentURL, this._type);
                break;
            }
        }
        this.checkEnable();
    }

    void addToStack(String string) {
        this._stack.add(0, string);
        this.checkEnable();
    }

    public void pageChanged(String string) {
        if (this._type == 0 && this._currentURL != null) {
            this._stack.add(0, this._currentURL);
        }
        this._currentURL = string.toString();
        this.checkEnable();
    }

    void reset() {
        this._stack = new Vector();
        this.checkEnable();
    }

    void setCurrentPage(String string) {
        this._currentURL = string.toString();
    }

    public void setForwardButton(JBrowseButton jBrowseButton) {
        this._forward = jBrowseButton;
    }
}

