/*
 * Decompiled with CFR 0.152.
 */
package turtlekit.simulations.soccer;

import java.awt.Color;
import turtlekit.kernel.Turtle;
import turtlekit.simulations.soccer.Ball;

public abstract class Player
extends Turtle {
    boolean ballHolder = false;
    int xInit;
    int yInit;
    int shootPower;
    int xGoal;
    int yGoal;
    Ball ball;
    boolean nearerBall = false;
    double distFB = 60.0;
    Player otherNearest;
    Player whoNearest;
    Player[] teamNearest;

    public void init() {
    }

    public Player(int n, int n2, int n3, Ball ball) {
        super("play");
        this.xInit = n;
        this.yInit = n2;
        this.shootPower = n3;
        this.ballHolder = false;
        this.ball = ball;
        this.teamNearest = new Player[3];
        this.yGoal = 75;
    }

    void move() {
        for (int i = 0; i < 4; ++i) {
            if (this.countTurtlesAt(this.dx(), this.dy()) <= 0 && this.getPatchColorAt(this.dx(), this.dy()) != Color.black) continue;
            if (Math.random() > 0.5) {
                this.turnRight(Math.random() * 90.0);
                continue;
            }
            this.turnLeft(Math.random() * 90.0);
        }
        if (this.countTurtlesAt(this.dx(), this.dy()) == 0 && this.getPatchColorAt(this.dx(), this.dy()) != Color.black) {
            this.fd(1);
        }
    }

    double distFromBall() {
        return this.distance(this.ball.xcor(), this.ball.ycor());
    }

    void computeDistFromBall() {
        double d = this.distFromBall();
        this.nearerBall = d < this.distFB;
        this.distFB = d;
    }

    void goForGoal() {
        this.setHeading(this.towards(this.xGoal, this.ycor()));
        if (Math.random() < 0.5) {
            this.turnLeft(Math.random() * 30.0);
        } else {
            this.turnRight(Math.random() * 30.0);
        }
    }

    void goForBall() {
        double d = this.ball.getHeading();
        if (this.ball.speed < 1 || this.distFB < 5.0) {
            this.setHeading(this.towards(this.ball.xcor(), this.ball.ycor()));
        } else {
            double d2 = this.distFB;
            if (d > 337.5 && d < 360.0 || d > 0.0 && d < 22.5) {
                this.setHeading(this.towards((double)this.ball.xcor() + d2, this.ball.ycor()));
            } else if (d > 22.5 && d < 67.5) {
                this.setHeading(this.towards((double)this.ball.xcor() + d2, (double)this.ball.ycor() + d2));
            } else if (d > 67.5 && d < 112.5) {
                this.setHeading(this.towards(this.ball.xcor(), (double)this.ball.ycor() + d2));
            } else if (d > 112.5 && d < 157.5) {
                this.setHeading(this.towards((double)this.ball.xcor() - d2, (double)this.ball.ycor() + d2));
            } else if (d > 157.5 && d < 202.5) {
                this.setHeading(this.towards((double)this.ball.xcor() - d2, this.ball.ycor()));
            } else if (d > 202.5 && d < 247.5) {
                this.setHeading(this.towards((double)this.ball.xcor() - d2, (double)this.ball.ycor() - d2));
            } else if (d > 247.5 && d < 292.5) {
                this.setHeading(this.towards(this.ball.xcor(), (double)this.ball.ycor() - d2));
            } else if (d > 292.5 && d < 337.5) {
                this.setHeading(this.towards((double)this.ball.xcor() + d2, (double)this.ball.ycor() - d2));
            }
        }
    }

    void repositioner() {
        this.setHeading(this.towards((double)this.xInit + Math.random() * 30.0 - 15.0, (double)this.yInit + Math.random() * 30.0 - 15.0));
    }

    void computeNearestFromBall() {
        double d = 1000.0;
        for (int i = 0; i < 22; ++i) {
            Player player = (Player)this.getTurtleWithID(i);
            if (!(player.distFromBall() < d)) continue;
            this.whoNearest = player;
            d = player.distFromBall();
        }
    }

    abstract void computeTeamateAndNearest();

    void shoot(int n, int n2, int n3) {
        if (this.mySelf() < 11) {
            this.setColor(Color.red);
        } else {
            this.setColor(Color.blue);
        }
        this.ballHolder = false;
        this.ball.holden = false;
        this.ball.holder = null;
        this.ball.speed = (int)(Math.random() * (double)n3);
        if (this.ball.speed < 5) {
            this.ball.speed = 5;
        }
        if (this.ball.speed > 8) {
            this.ball.speed = 8;
        }
        if (Math.random() < 0.5) {
            this.ball.setHeading(this.towards(n, n2) + Math.random() * 15.0);
        } else {
            this.ball.setHeading(this.towards(n, n2) - Math.random() * 15.0);
        }
    }

    public String dribble() {
        if (this.ballHolder) {
            double d;
            this.computeDistFromBall();
            this.computeTeamateAndNearest();
            if (this.distance(this.xGoal, this.yGoal) < 25.0) {
                this.shoot(this.xGoal, this.yGoal, this.shootPower);
                return "play";
            }
            double d2 = this.towards(this.otherNearest.xcor(), this.otherNearest.ycor());
            if (this.getHeading() - d2 > 90.0 || this.getHeading() - d2 < -90.0 || this.distance(this.otherNearest.xcor(), this.otherNearest.ycor()) > 6.0) {
                this.goForGoal();
                this.setHeading(this.getHeading() + Math.random() * 20.0 - 10.0);
                this.move();
                return "dribble";
            }
            if (Math.random() > 0.7) {
                this.goForGoal();
                this.move();
                return "dribble";
            }
            int n = 0;
            for (int i = 2; i >= 0; --i) {
                double d3 = this.towards(this.teamNearest[i].xcor(), this.teamNearest[i].ycor());
                if (!(d3 > 90.0) || !(d3 < 270.0) || !(d3 - d2 > 20.0) && !(d3 - d2 < -20.0)) continue;
                n = i;
                break;
            }
            if ((d = this.distance(this.teamNearest[n].xcor(), this.teamNearest[n].ycor())) < (double)this.shootPower) {
                this.shoot(this.teamNearest[n].xcor(), this.teamNearest[n].ycor(), (int)d);
            } else {
                this.shoot(this.teamNearest[n].xcor(), this.teamNearest[n].ycor(), this.shootPower);
            }
        }
        return "play";
    }
}

