/*
 * Decompiled with CFR 0.152.
 */
package turtlekit.simulations.soccer;

import java.awt.Color;
import turtlekit.simulations.soccer.Ball;
import turtlekit.simulations.soccer.Player;

public class BluePlayer
extends Player {
    public BluePlayer(int n, int n2, int n3, Ball ball) {
        super(n, n2, n3, ball);
        this.xGoal = 25;
    }

    boolean takeBall() {
        if (this.distFromBall() < 1.2) {
            if (this.ball.holden && Math.random() < 0.25) {
                return false;
            }
            this.ball.takenBy(this);
            this.ballHolder = true;
            this.setColor(Color.cyan);
            return true;
        }
        return false;
    }

    void computeTeamateAndNearest() {
        int n;
        double d = 1000.0;
        int[] nArray = new int[]{-1, -1, -1};
        for (n = 0; n < 3; ++n) {
            for (int i = 11; i < 22; ++i) {
                Player player;
                if (i == this.mySelf() || i == nArray[0] || i == nArray[1] || (player = (Player)this.getTurtleWithID(i)) == null || !(this.distance(player.xcor(), player.ycor()) < d)) continue;
                d = this.distance(player.xcor(), player.ycor());
                this.teamNearest[n] = player;
                nArray[n] = i;
            }
            d = 1000.0;
        }
        d = 1000.0;
        for (n = 0; n < 11; ++n) {
            Player player = (Player)this.getTurtleWithID(n);
            if (player == null || !(this.distance(player.xcor(), player.ycor()) < d)) continue;
            d = this.distance(player.xcor(), player.ycor());
            this.otherNearest = player;
        }
    }

    public String play() {
        this.computeNearestFromBall();
        this.computeDistFromBall();
        this.computeTeamateAndNearest();
        if (this.whoNearest == this || this.whoNearest.mySelf() < 11 && this.nearerBall && this.distFB < 15.0) {
            this.goForBall();
            this.move();
            if (this.takeBall()) {
                return "dribble";
            }
            return "play";
        }
        if (this.whoNearest.mySelf() < 11 || this.distance(this.xInit, this.yInit) > 50.0) {
            if (Math.random() < 0.7) {
                this.repositioner();
            }
            this.move();
            return "play";
        }
        if (Math.random() > 0.2) {
            this.goForGoal();
        } else {
            this.randomHeading();
        }
        this.move();
        return "play";
    }

    public void setup() {
        this.moveTo(this.xInit, this.yInit);
        this.setColor(Color.blue);
        this.playRole("bluePlayer");
    }
}

