/*
 * Decompiled with CFR 0.152.
 */
package turtlekit.simulations.soccer;

import java.awt.Color;
import turtlekit.kernel.Turtle;
import turtlekit.simulations.soccer.Player;

public class Ball
extends Turtle {
    private static final long serialVersionUID = -7299755301727117498L;
    boolean holden = false;
    int xInit;
    int yInit;
    int speed = 1;
    int slowDown = 10;
    Player holder = null;
    Player lastHolder = null;
    int teamBall = 0;
    public int status = -1;

    public Ball() {
        super("move");
    }

    void takenBy(Player player) {
        if (this.holder != null) {
            if (this.holder.mySelf() < 11) {
                this.holder.setColor(Color.red);
            } else {
                this.holder.setColor(Color.blue);
            }
            this.holder.ballHolder = false;
        }
        this.holder = player;
        this.lastHolder = player;
        this.teamBall = this.holder.mySelf() < 11 ? 1 : 2;
        this.holden = true;
    }

    void step() {
        this.status = -1;
        if (this.getPatchColorAt(this.dx(), this.dy()) == Color.black) {
            if (this.xcor() > 178) {
                this.status = this.ycor() > 69 && this.ycor() < 80 ? 0 : 1;
            }
            if (this.xcor() < 20) {
                this.status = this.ycor() > 69 && this.ycor() < 80 ? 2 : 3;
            }
            if (this.ycor() < 24) {
                this.status = 3;
            }
            if (this.xcor() > 124) {
                this.status = 4;
            }
        }
        if (this.getPatchColorAt(this.dx(), this.dy()) == Color.darkGray) {
            this.setHeading(180.0 - this.getHeading());
        }
        if (this.status == -1) {
            this.fd(1);
        }
    }

    public String move() {
        if (this.holden) {
            this.setXY(this.holder.xcor(), this.holder.ycor());
        } else {
            for (int i = 0; i < this.speed; ++i) {
                this.step();
            }
        }
        this.speed = (int)((double)this.speed - (double)this.speed * ((double)this.slowDown / 100.0));
        return "move";
    }

    public void setup() {
        this.playRole("ball");
        this.setColor(Color.white);
        this.moveTo(99, 87);
        this.setHeading(0.0);
        for (int i = 0; i < 100; ++i) {
            this.fd(1);
            this.turnRight(5.0);
            this.setPatchColor(Color.white);
        }
        this.moveTo(100, 75);
        this.randomHeading();
    }
}

