/*
 * Decompiled with CFR 0.152.
 */
package turtlekit.simulations.hunt2CyanVsBlue;

import turtlekit.kernel.Launcher;
import turtlekit.kernel.PatchVariable;
import turtlekit.simulations.hunt2CyanVsBlue.Blue;
import turtlekit.simulations.hunt2CyanVsBlue.Cyan;
import turtlekit.simulations.hunt2CyanVsBlue.PredatorObserver;
import turtlekit.simulations.hunt2CyanVsBlue.PreyObserver;
import turtlekit.simulations.hunt2CyanVsBlue.ResourceManager;

public class HuntLauncher
extends Launcher {
    private int nbOfprey = 150;
    private int nbOfpredator = 150;
    private int predatorVision = 4;
    private int preyVision = 4;
    private int preyInitLife = 90;
    private int predatorInitLife = 90;
    private boolean withResource = true;
    private double density = 0.01;

    public HuntLauncher() {
        this.setCyclePause(10);
        this.setSimulationName("HUNT 2");
        this.setWidth(100);
        this.setHeight(100);
        this.setCellSize(5);
    }

    public void setNbOfprey(int n) {
        this.nbOfprey = n;
    }

    public int getNbOfprey() {
        return this.nbOfprey;
    }

    public void setPredatorVision(int n) {
        this.predatorVision = n;
    }

    public int getPredatorVision() {
        return this.predatorVision;
    }

    public void setNbOfpredator(int n) {
        this.nbOfpredator = n;
    }

    public int getNbOfpredator() {
        return this.nbOfpredator;
    }

    protected void initializePatchVariables() {
        PatchVariable patchVariable = new PatchVariable("resource");
        patchVariable.setDiffuseCoef(0.0);
        patchVariable.setEvapCoef(0.0);
        this.addPatchVariable(patchVariable);
    }

    public void addSimulationAgents() {
        this.setCyclePause(10);
        if (this.withResource) {
            this.addObserver(new ResourceManager(this.density), false);
        }
        this.addObserver(new PreyObserver(1000), true);
        this.addObserver(new PredatorObserver(2000), true);
        for (int i = 0; i < this.nbOfpredator; ++i) {
            Cyan cyan = new Cyan(this.predatorVision, this.predatorInitLife);
            this.addTurtle(cyan);
            Blue blue = new Blue(this.predatorVision, this.predatorInitLife);
            this.addTurtle(blue);
        }
        this.addViewer(6);
    }

    public double getDensity() {
        return this.density;
    }

    public void setDensity(double d) {
        this.density = d;
    }

    public final boolean isWithResource() {
        return this.withResource;
    }

    public final void setWithResource(boolean bl) {
        this.withResource = bl;
    }

    public final int getPreyVision() {
        return this.preyVision;
    }

    public final void setPreyVision(int n) {
        this.preyVision = n;
    }

    public final int getPreyInitLife() {
        return this.preyInitLife;
    }

    public final void setPreyInitLife(int n) {
        this.preyInitLife = n;
    }

    public final int getPredatorInitLife() {
        return this.predatorInitLife;
    }

    public final void setPredatorInitLife(int n) {
        this.predatorInitLife = n;
    }
}

