/*
 * Decompiled with CFR 0.152.
 */
package turtlekit.simulations.hunt2;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import turtlekit.kernel.Launcher;
import turtlekit.kernel.PatchVariable;
import turtlekit.kernel.Turtle;
import turtlekit.simulations.hunt2.PredatorObserver;
import turtlekit.simulations.hunt2.PreyObserver;
import turtlekit.simulations.hunt2.ResourceManager;

public class HuntLauncher
extends Launcher {
    private int nbOfprey = 150;
    private int nbOfpredator = 25;
    private int predatorVision = 4;
    private int preyVision = 4;
    private int preyInitLife = 90;
    private int predatorInitLife = 90;
    private boolean withResource = true;
    private double density = 0.01;
    public static String team1Class = "Cyan";
    public static String team2Class = "Black";

    public HuntLauncher() {
        this.setCyclePause(10);
        this.setSimulationName("HUNT 2");
        this.setWidth(100);
        this.setHeight(100);
        this.setCellSize(5);
    }

    public void setNbOfprey(int n) {
        this.nbOfprey = n;
    }

    public int getNbOfprey() {
        return this.nbOfprey;
    }

    public void setPredatorVision(int n) {
        this.predatorVision = n;
    }

    public int getPredatorVision() {
        return this.predatorVision;
    }

    public void setNbOfpredator(int n) {
        this.nbOfpredator = n;
    }

    public int getNbOfpredator() {
        return this.nbOfpredator;
    }

    protected void initializePatchVariables() {
        PatchVariable patchVariable = new PatchVariable("resource");
        patchVariable.setDiffuseCoef(0.0);
        patchVariable.setEvapCoef(0.0);
        this.addPatchVariable(patchVariable);
    }

    public void addSimulationAgents() {
        this.setCyclePause(10);
        if (this.withResource) {
            this.addObserver(new ResourceManager(this.density), false);
        }
        this.addObserver(new PreyObserver(1000), true);
        this.addObserver(new PredatorObserver(2000), true);
        try {
            Constructor<?> constructor = Class.forName(((Object)((Object)this)).getClass().getPackage().getName() + "." + team1Class).getConstructor(Integer.TYPE, Integer.TYPE);
            Constructor<?> constructor2 = Class.forName(((Object)((Object)this)).getClass().getPackage().getName() + "." + team2Class).getConstructor(Integer.TYPE, Integer.TYPE);
            for (int i = 0; i < this.nbOfpredator; ++i) {
                this.addTurtle((Turtle)constructor.newInstance(this.predatorVision, this.predatorInitLife));
                this.addTurtle((Turtle)constructor2.newInstance(this.predatorVision, this.predatorInitLife));
            }
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        this.addViewer(6);
    }

    public double getDensity() {
        return this.density;
    }

    public void setDensity(double d) {
        this.density = d;
    }

    public final boolean isWithResource() {
        return this.withResource;
    }

    public final void setWithResource(boolean bl) {
        this.withResource = bl;
    }

    public final int getPreyVision() {
        return this.preyVision;
    }

    public final void setPreyVision(int n) {
        this.preyVision = n;
    }

    public final int getPreyInitLife() {
        return this.preyInitLife;
    }

    public final void setPreyInitLife(int n) {
        this.preyInitLife = n;
    }

    public final int getPredatorInitLife() {
        return this.predatorInitLife;
    }

    public final void setPredatorInitLife(int n) {
        this.predatorInitLife = n;
    }

    public static final String getTeam1Class() {
        return team1Class;
    }

    public static final String getTeam2Class() {
        return team2Class;
    }
}

