/*
 * Decompiled with CFR 0.152.
 */
package turtlekit.simulations.hunt;

import java.awt.Color;
import turtlekit.kernel.Turtle;

public class Predator
extends Turtle {
    int visionRadius;

    public Predator(int n) {
        super("live");
        this.visionRadius = n;
    }

    public void setup() {
        this.playRole("predator");
        this.randomHeading();
        this.setColor(Color.red);
        if (this.countTurtlesHere() > 0) {
            this.fd(1);
        }
    }

    public String live() {
        this.setHeading(this.towardsAPrey(this.visionRadius));
        this.move();
        return "live";
    }

    void move() {
        if (this.countTurtlesAt(this.dx(), this.dy()) > 0) {
            this.turnRight(50.0);
        }
        if (this.countTurtlesAt(this.dx(), this.dy()) > 0) {
            this.turnLeft(100.0);
        }
        if (this.countTurtlesAt(this.dx(), this.dy()) == 0) {
            this.fd(1);
        } else {
            this.turnRight(50.0);
        }
    }

    double towardsAPrey(int n) {
        for (int i = -n; i <= n; ++i) {
            for (int j = -n; j <= n; ++j) {
                Turtle[] turtleArray;
                if (i == 0 && j == 0 || (turtleArray = this.turtlesAt(i, j)) == null || turtleArray.length <= 0 || !turtleArray[0].isPlayingRole("prey")) continue;
                return this.towards(turtleArray[0].xcor(), turtleArray[0].ycor());
            }
        }
        return Math.random() * 180.0;
    }
}

