/*
 * Decompiled with CFR 0.152.
 */
package org.python.util;

import java.util.Properties;
import java.util.Vector;
import org.python.core.Options;

class CommandLineOptions {
    public String filename = null;
    public boolean jar = false;
    public boolean interactive = true;
    public boolean notice = true;
    private boolean fixInteractive = false;
    public boolean help = false;
    public boolean version = false;
    public String[] argv;
    public Properties properties;
    public String command;
    public Vector warnoptions = new Vector();
    public String encoding;

    public void setProperty(String string, String string2) {
        this.properties.put(string, string2);
    }

    public boolean parse(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length && stringArray[n].startsWith("-")) {
            String string = stringArray[n];
            if (string.equals("--help")) {
                this.help = true;
                return false;
            }
            if (string.equals("--version")) {
                this.version = true;
                return false;
            }
            if (string.equals("-")) {
                if (!this.fixInteractive) {
                    this.interactive = false;
                }
                this.filename = "-";
            } else if (string.equals("-i")) {
                this.fixInteractive = true;
                this.interactive = true;
            } else if (string.equals("-jar")) {
                this.jar = true;
                if (!this.fixInteractive) {
                    this.interactive = false;
                }
            } else if (string.equals("-v")) {
                ++Options.verbose;
            } else if (string.equals("-vv")) {
                Options.verbose += 2;
            } else if (string.equals("-vvv")) {
                Options.verbose += 3;
            } else if (string.equals("-S")) {
                Options.importSite = false;
            } else {
                String string2;
                if (string.equals("-c")) {
                    this.command = stringArray[++n];
                    if (this.fixInteractive) break;
                    this.interactive = false;
                    break;
                }
                if (string.equals("-W")) {
                    this.warnoptions.addElement(stringArray[++n]);
                } else if (string.equals("-E")) {
                    this.encoding = stringArray[++n];
                } else if (string.startsWith("-D")) {
                    string2 = null;
                    String string3 = null;
                    int n2 = string.indexOf("=");
                    if (n2 == -1) {
                        String string4 = stringArray[++n];
                        string2 = string.substring(2, string.length());
                        string3 = string4;
                    } else {
                        string2 = string.substring(2, n2);
                        string3 = string.substring(n2 + 1, string.length());
                    }
                    this.setProperty(string2, string3);
                } else {
                    string2 = stringArray[n];
                    if (string2.startsWith("--")) {
                        string2 = string2.substring(2);
                    } else if (string2.startsWith("-")) {
                        string2 = string2.substring(1);
                    }
                    System.err.println("jython: illegal option -- " + string2);
                    return false;
                }
            }
            ++n;
        }
        this.notice = this.interactive;
        if (this.filename == null && n < stringArray.length && this.command == null) {
            this.filename = stringArray[n++];
            if (!this.fixInteractive) {
                this.interactive = false;
            }
            this.notice = false;
        }
        if (this.command != null) {
            this.notice = false;
        }
        int n3 = stringArray.length - n + 1;
        this.argv = new String[n3];
        this.argv[0] = this.filename != null ? this.filename : "";
        int n4 = 1;
        while (n4 < n3) {
            this.argv[n4] = stringArray[n];
            ++n4;
            ++n;
        }
        return true;
    }

    public CommandLineOptions() {
        this.properties = new Properties();
    }
}

