/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.python.core.Options;
import org.python.core.PackageManager;

public abstract class CachedJarsPackageManager
extends PackageManager {
    private boolean indexModified;
    private Hashtable jarfiles;
    private File cachedir;

    protected void message(String string) {
    }

    protected void warning(String string) {
    }

    protected void comment(String string) {
    }

    protected void debug(String string) {
    }

    protected boolean filterByName(String string, boolean bl) {
        return string.indexOf(36) != -1;
    }

    protected boolean filterByAccess(String string, int n) {
        return (n & 1) != 1;
    }

    private static String vectorToString(Vector vector) {
        int n = vector.size();
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append((String)vector.elementAt(n2));
            if (n2 < n - 1) {
                stringBuffer.append(",");
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    private void addZipEntry(Hashtable hashtable, ZipEntry zipEntry, ZipInputStream zipInputStream) throws IOException {
        int n;
        String string = zipEntry.getName();
        if (!string.endsWith(".class")) {
            return;
        }
        char c = '/';
        int n2 = string.lastIndexOf(c);
        if (n2 == -1) {
            n2 = string.lastIndexOf(92);
            c = '\\';
        }
        String string2 = n2 == -1 ? "" : string.substring(0, n2).replace(c, '.');
        String string3 = string.substring(n2 + 1, string.length() - 6);
        if (this.filterByName(string3, false)) {
            return;
        }
        Vector[] vectorArray = (Vector[])hashtable.get(string2);
        if (vectorArray == null) {
            vectorArray = new Vector[]{new Vector(), new Vector()};
            hashtable.put(string2, vectorArray);
        }
        if ((n = PackageManager.checkAccess(zipInputStream)) != -1 && !this.filterByAccess(string, n)) {
            vectorArray[0].addElement(string3);
        } else {
            vectorArray[1].addElement(string3);
        }
    }

    private Hashtable getZipPackages(InputStream inputStream) throws IOException {
        ZipEntry zipEntry;
        Hashtable hashtable = new Hashtable();
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            this.addZipEntry(hashtable, zipEntry, zipInputStream);
            zipInputStream.closeEntry();
        }
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            Vector[] vectorArray = (Vector[])hashtable.get(k);
            String string = CachedJarsPackageManager.vectorToString(vectorArray[0]);
            if (vectorArray[1].size() > 0) {
                string = string + '@' + CachedJarsPackageManager.vectorToString(vectorArray[1]);
            }
            hashtable.put(k, string);
        }
        return hashtable;
    }

    public void addJarToPackages(URL uRL) {
        this.addJarToPackages(uRL, null, false);
    }

    public void addJarToPackages(URL uRL, boolean bl) {
        this.addJarToPackages(uRL, null, bl);
    }

    public void addJarToPackages(File file) {
        this.addJarToPackages(null, file, false);
    }

    public void addJarToPackages(File file, boolean bl) {
        this.addJarToPackages(null, file, bl);
    }

    private void addJarToPackages(URL uRL, File file, boolean bl) {
        try {
            Object object;
            Object object2;
            boolean bl2 = this.jarfiles != null;
            URLConnection uRLConnection = null;
            boolean bl3 = true;
            if (file == null) {
                uRLConnection = uRL.openConnection();
                if (uRLConnection.getURL().getProtocol().equals("file")) {
                    object2 = uRL.getFile();
                    object2 = ((String)object2).replace('/', File.separatorChar);
                    file = new File((String)object2);
                } else {
                    bl3 = false;
                }
            }
            if (bl3 && !file.exists()) {
                return;
            }
            object2 = null;
            long l = 0L;
            String string = null;
            JarXEntry jarXEntry = null;
            boolean bl4 = false;
            if (bl2) {
                if (bl3) {
                    l = file.lastModified();
                    string = file.getCanonicalPath();
                } else {
                    l = uRLConnection.getLastModified();
                    string = uRL.toString();
                }
                jarXEntry = (JarXEntry)this.jarfiles.get(string);
                if (jarXEntry == null) {
                    this.message("processing new jar, '" + string + "'");
                    if (bl3) {
                        object = file.getName();
                    } else {
                        object = uRL.getFile();
                        int n = ((String)object).lastIndexOf(47);
                        if (n != -1) {
                            object = ((String)object).substring(n + 1);
                        }
                    }
                    object = ((String)object).substring(0, ((String)object).length() - 4);
                    jarXEntry = new JarXEntry((String)object);
                    this.jarfiles.put(string, jarXEntry);
                    bl4 = true;
                }
                if (l != 0L && jarXEntry.mtime == l) {
                    object2 = this.readCacheFile(jarXEntry, string);
                }
            }
            if (object2 == null) {
                boolean bl5 = bl2 = bl2 && bl;
                if (bl2) {
                    this.indexModified = true;
                    if (jarXEntry.mtime != 0L) {
                        this.message("processing modified jar, '" + string + "'");
                    }
                    jarXEntry.mtime = l;
                }
                object = uRLConnection == null ? new BufferedInputStream(new FileInputStream(file)) : uRLConnection.getInputStream();
                object2 = this.getZipPackages((InputStream)object);
                if (bl2) {
                    this.writeCacheFile(jarXEntry, string, (Hashtable)object2, bl4);
                }
            }
            this.addPackages((Hashtable)object2, string);
        }
        catch (IOException iOException) {
            this.warning("skipping bad jar, '" + (file != null ? file.toString() : uRL.toString()) + "'");
        }
    }

    private void addPackages(Hashtable hashtable, String string) {
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = (String)hashtable.get(string2);
            int n = string3.indexOf(64);
            if (n >= 0 && Options.respectJavaAccessibility) {
                string3 = string3.substring(0, n);
            }
            this.makeJavaPackage(string2, string3, string);
        }
    }

    private Hashtable readCacheFile(JarXEntry jarXEntry, String string) {
        String string2 = jarXEntry.cachefile;
        long l = jarXEntry.mtime;
        this.debug("reading cache, '" + string + "'");
        try {
            DataInputStream dataInputStream = this.inOpenCacheFile(string2);
            String string3 = dataInputStream.readUTF();
            long l2 = dataInputStream.readLong();
            if (!string3.equals(string) || l2 != l) {
                this.comment("invalid cache file: " + string2 + ", " + string + ":" + string3 + ", " + l + ":" + l2);
                this.deleteCacheFile(string2);
                return null;
            }
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            try {
                while (true) {
                    String string4 = dataInputStream.readUTF();
                    String string5 = dataInputStream.readUTF();
                    hashtable.put(string4, string5);
                }
            }
            catch (EOFException eOFException) {
                dataInputStream.close();
                return hashtable;
            }
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private void writeCacheFile(JarXEntry jarXEntry, String string, Hashtable hashtable, boolean bl) {
        try {
            DataOutputStream dataOutputStream = this.outCreateCacheFile(jarXEntry, bl);
            dataOutputStream.writeUTF(string);
            dataOutputStream.writeLong(jarXEntry.mtime);
            this.comment("rewriting cachefile for '" + string + "'");
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                String string3 = (String)hashtable.get(string2);
                dataOutputStream.writeUTF(string2);
                dataOutputStream.writeUTF(string3);
            }
            dataOutputStream.close();
        }
        catch (IOException iOException) {
            this.warning("can't write cache file for '" + string + "'");
        }
    }

    protected void initCache() {
        this.indexModified = false;
        this.jarfiles = new Hashtable();
        try {
            DataInputStream dataInputStream = this.inOpenIndex();
            if (dataInputStream == null) {
                return;
            }
            try {
                while (true) {
                    String string = dataInputStream.readUTF();
                    String string2 = dataInputStream.readUTF();
                    long l = dataInputStream.readLong();
                    this.jarfiles.put(string, new JarXEntry(string2, l));
                }
            }
            catch (EOFException eOFException) {
                dataInputStream.close();
            }
        }
        catch (IOException iOException) {
            this.warning("invalid index file");
        }
    }

    public void saveCache() {
        if (this.jarfiles == null || !this.indexModified) {
            return;
        }
        this.indexModified = false;
        this.comment("writing modified index file");
        try {
            DataOutputStream dataOutputStream = this.outOpenIndex();
            Enumeration enumeration = this.jarfiles.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                JarXEntry jarXEntry = (JarXEntry)this.jarfiles.get(string);
                dataOutputStream.writeUTF(string);
                dataOutputStream.writeUTF(jarXEntry.cachefile);
                dataOutputStream.writeLong(jarXEntry.mtime);
            }
            dataOutputStream.close();
        }
        catch (IOException iOException) {
            this.warning("can't write index file");
        }
    }

    protected DataInputStream inOpenIndex() throws IOException {
        File file = new File(this.cachedir, "packages.idx");
        if (!file.exists()) {
            return null;
        }
        DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
        return dataInputStream;
    }

    protected DataOutputStream outOpenIndex() throws IOException {
        File file = new File(this.cachedir, "packages.idx");
        return new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
    }

    protected DataInputStream inOpenCacheFile(String string) throws IOException {
        return new DataInputStream(new BufferedInputStream(new FileInputStream(string)));
    }

    protected void deleteCacheFile(String string) {
        new File(string).delete();
    }

    protected DataOutputStream outCreateCacheFile(JarXEntry jarXEntry, boolean bl) throws IOException {
        File file = null;
        if (bl) {
            int n = 1;
            String string = "";
            String string2 = jarXEntry.cachefile;
            while ((file = new File(this.cachedir, string2 + string + ".pkc")).exists()) {
                string = "$" + n;
                ++n;
            }
            jarXEntry.cachefile = file.getCanonicalPath();
        } else {
            file = new File(jarXEntry.cachefile);
        }
        return new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
    }

    protected boolean useCacheDir(File file) {
        if (file == null) {
            return false;
        }
        if (!file.isDirectory() && !file.mkdirs()) {
            this.warning("can't create package cache dir, '" + file + "'");
            return false;
        }
        this.cachedir = file;
        return true;
    }

    public static class JarXEntry {
        public String cachefile;
        public long mtime;

        public JarXEntry(String string) {
            this.cachefile = string;
        }

        public JarXEntry(String string, long l) {
            this.cachefile = string;
            this.mtime = l;
        }
    }
}

