/*
 * Decompiled with CFR 0.152.
 */
package org.python.compiler;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import org.python.compiler.Bytes;

public class ConstantPool {
    Hashtable constants = new Hashtable();
    int index = 0;
    DataOutputStream tdata;
    ByteArrayOutputStream pool = new ByteArrayOutputStream();
    ByteArrayOutputStream tarray = new ByteArrayOutputStream();
    int[] sizes;

    public void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.index + 1);
        dataOutputStream.write(this.pool.toByteArray());
    }

    public int addConstant(int n) throws IOException {
        Bytes bytes = new Bytes(this.tarray);
        this.tarray.reset();
        Integer n2 = (Integer)this.constants.get(bytes);
        if (n2 == null) {
            this.pool.write(bytes.data);
            n2 = new Integer(this.index);
            this.constants.put(bytes, n2);
            if (this.index + 1 >= this.sizes.length) {
                int[] nArray = new int[this.sizes.length * 2];
                System.arraycopy(this.sizes, 0, nArray, 0, this.sizes.length);
                this.sizes = nArray;
            }
            this.sizes[this.index + 1] = n;
            this.index += n;
        }
        return n2 + 1;
    }

    public int UTF8(String string) throws IOException {
        this.tdata.writeByte(1);
        this.tdata.writeUTF(string);
        return this.addConstant(1);
    }

    public int Class(String string) throws IOException {
        int n = this.UTF8(string);
        this.tdata.writeByte(7);
        this.tdata.writeShort(n);
        return this.addConstant(1);
    }

    public int Fieldref(String string, String string2, String string3) throws IOException {
        int n = this.Class(string);
        int n2 = this.NameAndType(string2, string3);
        this.tdata.writeByte(9);
        this.tdata.writeShort(n);
        this.tdata.writeShort(n2);
        int n3 = 1;
        if (string3.equals("D") || string3.equals("J")) {
            n3 = 2;
        }
        int n4 = this.addConstant(1);
        this.sizes[n4] = n3;
        return n4;
    }

    public static int sigSize(String string, boolean bl) {
        int n = 0;
        int n2 = 0;
        char[] cArray = string.toCharArray();
        int n3 = cArray.length;
        boolean bl2 = false;
        boolean bl3 = false;
        while (++n2 < n3) {
            switch (cArray[n2]) {
                case ')': {
                    if (!bl) {
                        return n;
                    }
                    bl2 = true;
                    break;
                }
                case '[': {
                    bl3 = true;
                    break;
                }
                case 'V': {
                    break;
                }
                case 'D': 
                case 'J': {
                    if (bl3) {
                        n = bl2 ? ++n : --n;
                        bl3 = false;
                        break;
                    }
                    if (bl2) {
                        n += 2;
                        break;
                    }
                    n -= 2;
                    break;
                }
                case 'L': {
                    while (cArray[++n2] != ';') {
                    }
                }
                default: {
                    n = bl2 ? ++n : --n;
                    bl3 = false;
                }
            }
        }
        return n;
    }

    public int Methodref(String string, String string2, String string3) throws IOException {
        int n = this.Class(string);
        int n2 = this.NameAndType(string2, string3);
        this.tdata.writeByte(10);
        this.tdata.writeShort(n);
        this.tdata.writeShort(n2);
        int n3 = this.addConstant(1);
        this.sizes[n3] = ConstantPool.sigSize(string3, true);
        return n3;
    }

    public int InterfaceMethodref(String string, String string2, String string3) throws IOException {
        int n = this.Class(string);
        int n2 = this.NameAndType(string2, string3);
        this.tdata.writeByte(11);
        this.tdata.writeShort(n);
        this.tdata.writeShort(n2);
        int n3 = this.addConstant(1);
        this.sizes[n3] = ConstantPool.sigSize(string3, true);
        return n3;
    }

    public int String(String string) throws IOException {
        int n = this.UTF8(string);
        this.tdata.writeByte(8);
        this.tdata.writeShort(n);
        return this.addConstant(1);
    }

    public int Integer(int n) throws IOException {
        this.tdata.writeByte(3);
        this.tdata.writeInt(n);
        return this.addConstant(1);
    }

    public int Float(float f) throws IOException {
        this.tdata.writeByte(4);
        this.tdata.writeFloat(f);
        return this.addConstant(1);
    }

    public int Long(long l) throws IOException {
        this.tdata.writeByte(5);
        this.tdata.writeLong(l);
        return this.addConstant(2);
    }

    public int Double(double d) throws IOException {
        this.tdata.writeByte(6);
        this.tdata.writeDouble(d);
        return this.addConstant(2);
    }

    public int NameAndType(String string, String string2) throws IOException {
        int n = this.UTF8(string);
        int n2 = this.UTF8(string2);
        this.tdata.writeByte(12);
        this.tdata.writeShort(n);
        this.tdata.writeShort(n2);
        return this.addConstant(1);
    }

    public static void main(String[] stringArray) throws Exception {
        ConstantPool constantPool = new ConstantPool();
        System.out.println("c: " + constantPool.Class("org/python/core/PyString"));
        System.out.println("c: " + constantPool.Class("org/python/core/PyString"));
        int n = 0;
        while (n < stringArray.length) {
            System.out.println(stringArray[n] + ": " + ConstantPool.sigSize(stringArray[n], true));
            ++n;
        }
    }

    public ConstantPool() {
        this.tdata = new DataOutputStream(this.tarray);
        this.sizes = new int[256];
    }
}

