/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import org.apache.tools.ant.AntTypeDefinition;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ComponentHelper;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TaskContainer;
import org.apache.tools.ant.UnknownElement;
import org.apache.tools.ant.taskdefs.AntlibDefinition;

public class PreSetDef
extends AntlibDefinition
implements TaskContainer {
    private UnknownElement nestedTask;
    private String name;

    public void setName(String name) {
        this.name = name;
    }

    public void addTask(Task nestedTask) {
        if (this.nestedTask != null) {
            throw new BuildException("Only one nested element allowed");
        }
        if (!(nestedTask instanceof UnknownElement)) {
            throw new BuildException("addTask called with a task that is not an unknown element");
        }
        this.nestedTask = (UnknownElement)nestedTask;
    }

    public void execute() {
        String componentName;
        if (this.nestedTask == null) {
            throw new BuildException("Missing nested element");
        }
        if (this.name == null) {
            throw new BuildException("Name not specified");
        }
        this.name = ProjectHelper.genComponentName(this.getURI(), this.name);
        ComponentHelper helper = ComponentHelper.getComponentHelper(this.getProject());
        AntTypeDefinition def = helper.getDefinition(componentName = ProjectHelper.genComponentName(this.nestedTask.getNamespace(), this.nestedTask.getTag()));
        if (def == null) {
            throw new BuildException("Unable to find typedef " + componentName);
        }
        MyAntTypeDefinition newDef = new MyAntTypeDefinition(def, this.nestedTask);
        newDef.setName(this.name);
        helper.addDataTypeDefinition(newDef);
    }

    private static class MyAntTypeDefinition
    extends AntTypeDefinition {
        private AntTypeDefinition parent;
        private UnknownElement element;

        public MyAntTypeDefinition(AntTypeDefinition parent, UnknownElement el) {
            this.parent = parent;
            this.element = el;
        }

        public void setClass(Class clazz) {
            throw new BuildException("Not supported");
        }

        public void setClassName(String className) {
            throw new BuildException("Not supported");
        }

        public String getClassName() {
            return this.parent.getClassName();
        }

        public void setAdapterClass(Class adapterClass) {
            throw new BuildException("Not supported");
        }

        public void setAdaptToClass(Class adaptToClass) {
            throw new BuildException("Not supported");
        }

        public void setClassLoader(ClassLoader classLoader) {
            throw new BuildException("Not supported");
        }

        public ClassLoader getClassLoader() {
            return this.parent.getClassLoader();
        }

        public Class getExposedClass(Project project) {
            return this.parent.getExposedClass(project);
        }

        public Class getTypeClass(Project project) {
            return this.parent.getTypeClass(project);
        }

        public void checkClass(Project project) {
            this.parent.checkClass(project);
        }

        public Object create(Project project) {
            Object o = this.parent.create(project);
            if (o == null) {
                return null;
            }
            this.element.configure(o);
            return o;
        }

        public boolean sameDefinition(AntTypeDefinition other, Project project) {
            if (other == null) {
                return false;
            }
            if (other.getClass() != this.getClass()) {
                return false;
            }
            MyAntTypeDefinition otherDef = (MyAntTypeDefinition)other;
            if (!this.parent.sameDefinition(otherDef.parent, project)) {
                return false;
            }
            return this.element.similar(otherDef.element);
        }

        public boolean similarDefinition(AntTypeDefinition other, Project project) {
            if (other == null) {
                return false;
            }
            if (!other.getClass().getName().equals(this.getClass().getName())) {
                return false;
            }
            MyAntTypeDefinition otherDef = (MyAntTypeDefinition)other;
            if (!this.parent.similarDefinition(otherDef.parent, project)) {
                return false;
            }
            return this.element.similar(otherDef.element);
        }
    }
}

