/*
 * Decompiled with CFR 0.152.
 */
package madkit.distributedbees;

import java.awt.Color;
import java.awt.Point;
import madkit.distributedbees.Bee;
import madkit.kernel.ReferenceableAgent;

public class QueenBee
extends Bee
implements ReferenceableAgent {
    int screenWidth;
    int screenHeight;
    int border = 20;
    int haut;
    int bas;
    int gauche;
    int droite;
    Bee[] monEssaim;
    int index = 0;

    public QueenBee(int n, int n2, Color color) {
        this.screenWidth = n;
        this.screenHeight = n2;
        this.beeColor = color;
        this.MaxAcc = 5;
        this.MaxVel = 12;
        this.p.x = this.RangedRdm(this.border, this.screenWidth - this.border);
        this.p.y = this.RangedRdm(this.border, this.screenHeight - this.border);
        this.oldp.x = this.p.x;
        this.oldp.y = this.p.y;
        this.dX = this.randomFromRange(this.MaxAcc);
        this.dY = this.randomFromRange(this.MaxAcc);
        this.haut = this.border;
        this.bas = this.screenHeight - this.border;
        this.gauche = this.border;
        this.droite = this.screenWidth - this.border;
    }

    public void initSwarm(int n) {
        this.monEssaim = new Bee[n];
    }

    public void addBee(Bee bee) {
        this.monEssaim[this.index] = bee;
        if (this.index < this.monEssaim.length) {
            ++this.index;
        }
    }

    public void buzz() {
        this.oldp.x = this.p.x;
        this.oldp.y = this.p.y;
        this.dX += this.randomFromRange(this.MaxAcc);
        this.dY += this.randomFromRange(this.MaxAcc);
        if (this.dX > this.MaxVel) {
            this.dX = this.MaxVel;
        } else if (this.dX < -this.MaxVel) {
            this.dX = -this.MaxVel;
        }
        if (this.dY > this.MaxVel) {
            this.dY = this.MaxVel;
        } else if (this.dY < -this.MaxVel) {
            this.dY = -this.MaxVel;
        }
        this.p.x += this.dX;
        this.p.y += this.dY;
        if (this.p.x < this.border || this.p.x > this.screenWidth - this.border) {
            this.dX = -this.dX;
            this.p.x += this.dX;
        }
        if (this.p.y < this.border || this.p.y > this.screenHeight - this.border) {
            this.dY = -this.dY;
            this.p.y += this.dY;
        }
        for (int i = 0; i < this.monEssaim.length; ++i) {
            this.monEssaim[i].buzz();
        }
    }

    public void moveTo(Point point) {
        this.oldp.x = this.p.x;
        this.oldp.y = this.p.y;
        if (point != null) {
            this.p.x = point.x;
            this.p.y = point.y;
        }
        for (int i = 0; i < this.monEssaim.length; ++i) {
            this.monEssaim[i].buzz();
        }
    }

    public void moveToImmediatly(Point point) {
        this.p.x = point.x;
        this.p.y = point.y;
    }

    public void carre() {
        int n;
        int n2 = n = this.MaxVel / 2;
        int n3 = n;
        this.oldp.x = this.p.x;
        this.oldp.y = this.p.y;
        while (n2 * n3 > 0) {
            if (this.p.x >= this.droite) {
                this.p.x = this.droite;
                this.p.y += n3;
                if (this.p.y >= this.bas) {
                    n3 = this.p.y - this.bas;
                    this.p.y = this.bas;
                    this.p.x -= n3;
                }
                n3 = 0;
                continue;
            }
            if (this.p.x <= this.gauche) {
                this.p.x = this.gauche;
                this.p.y -= n3;
                if (this.p.y <= this.haut) {
                    n3 = this.haut - this.p.y;
                    this.p.y = this.haut;
                    this.p.x += n3;
                }
                n3 = 0;
                continue;
            }
            if (this.p.y <= this.haut) {
                this.p.y = this.haut;
                this.p.x += n2;
                if (this.p.x >= this.droite) {
                    n2 = this.p.x - this.droite;
                    this.p.x = this.droite;
                    this.p.y -= n2;
                }
                n2 = 0;
                continue;
            }
            if (this.p.y >= this.bas) {
                this.p.y = this.bas;
                this.p.x -= n2;
                if (this.p.x <= this.gauche) {
                    n2 = this.gauche - this.p.x;
                    this.p.x = this.gauche;
                    this.p.y += n2;
                }
                n2 = 0;
                continue;
            }
            this.p.x += n2;
            this.p.y += n3;
            n2 = 0;
        }
        for (int i = 0; i < this.monEssaim.length; ++i) {
            this.monEssaim[i].buzz();
        }
    }

    public void activatedByControler() {
        System.err.println("Queen BEE = activatedByControler()");
        this.leaveRole("bees", "bee");
    }

    public void activatedByScheduler() {
        this.requestRole("buzz", "bees", "bee", null);
    }

    public void activate() {
        this.requestRole("buzz", "bees", "queen", null);
        this.requestRole("buzz", "bees", this.beeColor.toString() + "Queen", null);
    }

    public void die() {
        this.killAgent(this);
    }

    public void end() {
        for (int i = 0; i < this.monEssaim.length; ++i) {
            this.monEssaim[i] = null;
        }
    }

    public int getSwarmSize() {
        return this.monEssaim.length + 1;
    }
}

