/*
 * Decompiled with CFR 0.152.
 */
package madkit.distributedbees;

import java.awt.Color;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import madkit.distributedbees.InputListenerGUI;
import madkit.distributedbees.PointMessage;
import madkit.kernel.AbstractAgent;
import madkit.kernel.Message;
import madkit.kernel.ReferenceableAgent;
import madkit.kernel.StringMessage;

public abstract class InputListener
extends AbstractAgent
implements MouseMotionListener,
MouseListener,
KeyListener,
ReferenceableAgent {
    boolean mouseAction = false;
    InputListenerGUI myControlBoard;
    protected Color myColor;
    protected PointMessage positionMessage = new PointMessage();
    protected StringMessage purposeMsg = new StringMessage("");
    private int mouseMessageNumber = 0;
    private int destroyedMessagesRatio = 3;

    public void setMouseAction(boolean bl) {
        this.mouseAction = bl;
    }

    public boolean getMouseAction() {
        return this.mouseAction;
    }

    public void setDestroyedMessagesRatio(int n) {
        this.destroyedMessagesRatio = n > 0 ? n : 1;
    }

    public int getDestroyedMessagesRatio() {
        return this.destroyedMessagesRatio;
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.mouseAction) {
            this.positionMessage.setPoint(mouseEvent.getPoint());
            this.broadcastMessage("buzz", "simulation", this.myColor.toString() + "Controler", this.positionMessage);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.mouseAction) {
            if (this.mouseMessageNumber == 0) {
                this.positionMessage.setPoint(mouseEvent.getPoint());
                this.broadcastMessage("buzz", "simulation", this.myColor.toString() + "Controler", this.positionMessage);
            }
            this.mouseMessageNumber = (this.mouseMessageNumber + 1) % this.destroyedMessagesRatio;
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        System.err.println("inputListener = ds keyPressed(KeyEvent e)");
    }

    public void keyReleased(KeyEvent keyEvent) {
        System.err.println("inputListener = ds keyPressed(KeyEvent e)");
    }

    public void purposeMessage(String string) {
        this.purposeMsg.setString(string);
        this.broadcastMessage("buzz", "simulation", this.myColor.toString() + "Controler", (Message)this.purposeMsg);
        if (string.equals("moveTo")) {
            this.println("Click on the Interactive TV !");
            this.mouseAction = true;
        } else {
            this.mouseAction = false;
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
        System.err.println("inputListener = ds keyTyped(KeyEvent e)");
        char c = keyEvent.getKeyChar();
        if (Character.isUpperCase(c)) {
            c = Character.toLowerCase(c);
        }
        if (c == 'c') {
            this.purposeMessage("carre");
        }
        if (c == 'a') {
            this.purposeMessage("buzz");
        }
        if (c == 'm') {
            this.purposeMessage("moveTo");
        }
    }

    public void changeColoredRole(Color color) {
        if (this.myColor != null) {
            this.leaveRole("simulation", this.myColor.toString() + "InputListener");
        }
        this.myColor = color;
        this.requestRole("buzz", "simulation", this.myColor.toString() + "InputListener", null);
    }

    public abstract void changeColoredView(Color var1, boolean var2);

    public String toString() {
        return "inputListener OKKKKKKKKKKKKKKK";
    }

    public void initGUI() {
        this.myControlBoard = new InputListenerGUI(this);
        this.setGUIObject(this.myControlBoard);
    }

    public void activate() {
        this.requestRole("buzz", "simulation", "inputListener", null);
        this.println("inputListener =  Activated\n");
    }

    public void end() {
        System.err.println("inputListener = DEAD");
    }
}

