/*
 * Decompiled with CFR 0.152.
 */
package warbot.kernel;

import warbot.kernel.Entity;
import warbot.kernel.Percept;
import warbot.kernel.WarbotEnvironment;

public abstract class MovableEntity
extends Entity {
    protected static final int MOVE = 1;
    private double coveredDistance = 0.0;
    double angle = 0.0;
    double angleCos = 1.0;
    double angleSin = 0.0;
    boolean moving = false;
    double speedFactor = 2.0;

    public double getCoveredDistance() {
        return this.coveredDistance;
    }

    MovableEntity(WarbotEnvironment warbotEnvironment, String string, String string2, int n, int n2, int n3) {
        super(warbotEnvironment, string, string2, n, n2, n3);
    }

    MovableEntity() {
    }

    public Percept makePercept(double d, double d2, double d3) {
        Percept percept = super.makePercept(d, d2, d3);
        percept.setHeading(this.getHeading());
        return percept;
    }

    void setMoving(boolean bl) {
        this.moving = bl;
    }

    final void doPhysicalMove() {
        this.setXY(this.x + this.speedFactor * this.angleCos, this.y + this.speedFactor * this.angleSin);
        this.coveredDistance = this.speedFactor;
    }

    protected void tryMove() {
        if (this.energy > 0 && this.myWorld.authorizeMove(this, this.newX(), this.newY())) {
            this.doPhysicalMove();
            this.moving = true;
        }
    }

    final double newX() {
        return this.x + this.angleCos;
    }

    final double newY() {
        return this.y + this.angleSin;
    }

    final double getCosAlpha() {
        return this.angleCos;
    }

    final double getSinAlpha() {
        return this.angleSin;
    }

    void update() {
        this.setMoving(false);
        this.getShot = false;
        this.coveredDistance = 0.0;
    }

    public final void setHeading(double d) {
        this.angle = d % 360.0;
        if (this.angle < 0.0) {
            this.angle += 360.0;
        }
        this.angleSin = Math.sin(Math.PI * this.angle / 180.0);
        this.angleCos = Math.cos(Math.PI * this.angle / 180.0);
    }

    public final double getHeading() {
        return this.angle;
    }

    public final boolean moving() {
        return this.moving;
    }
}

