/*
 * Decompiled with CFR 0.152.
 */
package warbot.kernel;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import warbot.kernel.BasicBody;
import warbot.kernel.Brain;
import warbot.kernel.GEntity;

public class GBasicBody
extends GEntity {
    static int userRectWidth = 100;
    static int userRectHeight = 15;
    static Font fmess = new Font("Serif", 0, 10);

    public void paint(Graphics graphics) {
        Brain brain;
        int n;
        super.paint(graphics);
        BasicBody basicBody = (BasicBody)this.getSElement();
        Point point = this.getCenter();
        if (basicBody.getShowDetect()) {
            n = basicBody.getDetectingRange();
            graphics.setColor(Color.RED);
            graphics.drawOval(point.x - n, point.y - n, 2 * n, 2 * n);
        }
        if (basicBody.getShowEnergyLevel()) {
            if (basicBody.initialEnergy == 0) {
                basicBody.initialEnergy = basicBody.getEnergy();
            }
            this.drawEnergyLevel(graphics, basicBody.getEnergy(), basicBody.initialEnergy);
        }
        n = basicBody.getResourceLevel();
        if (basicBody.showResourceLevel() && n > 0) {
            this.drawResourceLevel(graphics, n);
        }
        if ((brain = basicBody.getBrain()) != null) {
            int n2 = 0;
            n2 = brain.getMessageBoxSize();
            if (n2 > 0) {
                graphics.drawString("" + n2, point.x + basicBody.getRadius() + 2, point.y);
            }
        }
        graphics.setColor(Color.blue);
        graphics.drawLine(point.x, point.y, (int)((double)point.x + 20.0 * basicBody.angleCos), (int)((double)point.y + 20.0 * basicBody.angleSin));
        if (basicBody.isShowUserMessage()) {
            this.drawUserMessage(graphics, basicBody.getUserMessage());
        }
    }

    void drawEnergyLevel(Graphics graphics, int n, int n2) {
        double d = (double)this.width / (double)n2;
        int n3 = (int)Math.round(d * (double)n);
        int n4 = this.width - n3;
        graphics.setColor(Color.GREEN);
        graphics.fillRect(this.x, this.y - 5, n3, 3);
        graphics.setColor(Color.red);
        graphics.fillRect(this.x + n3, this.y - 5, n4, 3);
    }

    void drawResourceLevel(Graphics graphics, int n) {
        if (n < 400) {
            graphics.setColor(Color.GRAY);
        } else {
            graphics.setColor(Color.MAGENTA);
        }
        int n2 = n / 50;
        graphics.fillRect(this.x, this.y - 10, n2, 3);
    }

    void showLine(int n, int n2, int n3, int n4, Color color) {
        BasicBody basicBody = (BasicBody)this.getSElement();
        if (basicBody.isShowMessages()) {
            Graphics graphics = this.getEditor().getGraphics();
            graphics.setColor(color);
            graphics.drawLine(n, n2, n3, n4);
        }
    }

    void drawUserMessage(Graphics graphics, String string) {
        if (string != null) {
            int n;
            FontMetrics fontMetrics = graphics.getFontMetrics(fmess);
            int n2 = fontMetrics.getAscent();
            int n3 = fontMetrics.getDescent();
            int n4 = n2 + n3 + 4;
            if (string.length() > 24) {
                string = string.substring(0, 24) + "..";
            }
            int n5 = (n = fontMetrics.stringWidth(string)) < userRectWidth ? n : userRectWidth;
            graphics.setColor(Color.black);
            graphics.drawRect(this.x - 20, this.y - 10 - n4, n5 + 5, n4);
            graphics.drawLine(this.x, this.y, this.x - 18, this.y - 10);
            graphics.setFont(fmess);
            graphics.drawString(string, this.x - 18, this.y - 10 - n4 + n2 + 2);
        }
    }
}

