/*
 * Decompiled with CFR 0.152.
 */
package warbot.kernel;

import SEdit.SArrow;
import SEdit.SNode;
import java.awt.Point;
import java.awt.Toolkit;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.ImageIcon;
import warbot.kernel.Percept;
import warbot.kernel.WarbotEnvironment;

public abstract class Entity
extends SNode
implements Serializable {
    transient WarbotEnvironment myWorld = null;
    protected static final int NULL = 0;
    protected int actionIn = 5;
    protected int speed = 0;
    protected int action = 0;
    protected double x = 0.0;
    protected double y = 0.0;
    protected int xdisplay;
    protected int ydisplay;
    protected int displaySize;
    protected int detectingRange = 0;
    protected int energy = 0;
    protected int initialEnergy = 0;
    protected int radius = 0;
    String name = "entity";
    String team = "";
    protected boolean showDetect = false;
    protected boolean showEnergyLevel = true;
    boolean getShot = false;
    transient ImageIcon myGif = null;
    String simulationGroup = "Warbot";

    public Vector getInArrows() {
        return null;
    }

    public Vector getOutArrows() {
        return null;
    }

    protected void addOutArrow(SArrow sArrow) {
    }

    protected void addInArrow(SArrow sArrow) {
    }

    protected boolean isConnectable(SArrow sArrow, boolean bl) {
        return false;
    }

    void setSimulationGroup(String string) {
        this.simulationGroup = string;
    }

    public Percept makePercept(double d, double d2, double d3) {
        Percept percept = new Percept(this, d, d2, d3);
        return percept;
    }

    Entity(WarbotEnvironment warbotEnvironment, String string, String string2, int n, int n2, int n3) {
        this.myWorld = warbotEnvironment;
        this.name = string;
        this.team = string2;
        this.setRadius(n);
        this.energy = n2;
        this.initialEnergy = n2;
        this.detectingRange = n3;
        this.createDefaultImage();
    }

    Entity() {
    }

    void createDefaultImage() {
        ImageIcon imageIcon;
        this.myGif = imageIcon = new ImageIcon(Toolkit.getDefaultToolkit().createImage(ClassLoader.getSystemResource("warbot/kernel/images/" + this.team + this.name + ".gif")).getScaledInstance(this.radius * 2, this.radius * 2, 4));
    }

    ImageIcon getImage() {
        return this.myGif;
    }

    final void setXY(double d, double d2) {
        this.x = d;
        this.y = d2;
        this.xdisplay = this.xcor() - this.radius;
        this.ydisplay = this.ycor() - this.radius;
        this.getGObject().setCenter((int)Math.round(d), (int)Math.round(d2));
    }

    public final double getX() {
        return this.x;
    }

    public final void setX(double d) {
        this.x = d;
    }

    final int xcor() {
        return (int)this.x;
    }

    public final double getY() {
        return this.y;
    }

    public final void setY(double d) {
        this.y = d;
    }

    final int ycor() {
        return (int)this.y;
    }

    public void setRadius(int n) {
        this.radius = n;
        this.displaySize = this.radius * 2;
    }

    public final void setDetectingRange(int n) {
        this.detectingRange = n;
    }

    public final int getDetectingRange() {
        return this.detectingRange;
    }

    public final void setEnvironmentAgent(WarbotEnvironment warbotEnvironment) {
        this.myWorld = warbotEnvironment;
    }

    public final WarbotEnvironment getEnvironmentAgent() {
        return this.myWorld;
    }

    public final void setEnergy(int n) {
        this.energy = n;
    }

    public final String getTeam() {
        return this.team;
    }

    public final void setTeam(String string) {
        this.team = string;
    }

    public final String getName() {
        return this.name;
    }

    public final void setName(String string) {
        this.name = string;
    }

    public final void setShowDetect(boolean bl) {
        this.showDetect = bl;
    }

    public final boolean getShowDetect() {
        return this.showDetect;
    }

    public void toggleShowDetect() {
        this.showDetect = !this.showDetect;
    }

    public final void setShowEnergyLevel(boolean bl) {
        this.showEnergyLevel = bl;
    }

    public final boolean getShowEnergyLevel() {
        return this.showEnergyLevel;
    }

    public void toggleShowEnergyLevel() {
        this.showEnergyLevel = !this.showEnergyLevel;
    }

    public void init() {
        super.init();
        if (this.x == 0.0 && this.y == 0.0) {
            this.updateCoordinatesFromGObject();
        }
    }

    void updateCoordinatesFromGObject() {
        if (this.getGObject() != null) {
            Point point = this.getGObject().getCenter();
            this.x = point.x;
            this.y = point.y;
        }
    }

    public final void setSpeed(int n) {
        this.speed = n;
        if (this.actionIn > this.speed) {
            this.actionIn = this.speed;
        }
    }

    public final int getSpeed() {
        return this.speed;
    }

    final boolean willAct() {
        if (this.speed > 0) {
            --this.actionIn;
            if (this.actionIn == 0) {
                this.actionIn = this.speed;
                return true;
            }
        }
        return false;
    }

    void doIt() {
        this.update();
        if (this.action != 0) {
            this.doAction();
        }
        if (this.energy <= 0) {
            this.delete();
        }
    }

    void update() {
        this.getShot = false;
    }

    abstract void doAction();

    public final boolean getShot() {
        return this.getShot;
    }

    public int getRadius() {
        return this.radius;
    }

    public final int getEnergy() {
        return this.energy;
    }

    public void delete() {
        this.myWorld.removeEntity(this);
        super.delete();
    }

    public String toString() {
        return super.toString() + "  x= " + this.xcor() + ", y= " + this.ycor() + " ,radius= " + this.radius;
    }

    final boolean contains(int n, int n2) {
        return Math.pow(n - this.xcor(), 2.0) + Math.pow(n2 - this.ycor(), 2.0) <= Math.pow(this.radius, 2.0);
    }

    void getMissileShot(int n) {
        this.energy -= n;
        this.getShot = true;
        if (this.energy < 0) {
            this.delete();
        }
    }

    protected boolean dropEntity(Entity entity, double d) {
        return this.myWorld.dropEntity(this, entity, d);
    }

    protected final double distanceFrom(Entity entity) {
        if (entity != null) {
            return Math.sqrt(Math.pow(entity.getX() - this.x, 2.0) + Math.pow(entity.getY() - this.y, 2.0)) - (double)this.radius - (double)entity.getRadius();
        }
        return Double.MAX_VALUE;
    }

    protected final void decreaseEnergyLevel(int n) {
        this.energy -= n;
        if (this.energy < 0) {
            this.delete();
        }
    }

    protected void increaseEnergyLevel(int n) {
        this.energy += n;
    }
}

