/*
 * Decompiled with CFR 0.152.
 */
package warbot.kernel;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import madkit.kernel.AbstractAgent;
import madkit.kernel.Activator;
import warbot.kernel.BasicBody;
import warbot.kernel.Body;
import warbot.kernel.Brain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BrainActivator
extends Activator<Brain> {
    private List<Body> currentBodies;
    private List<BasicBody> bodiesActing = new ArrayList<BasicBody>();

    BrainActivator(String string) {
        super(string, "brain");
        this.currentBodies = new ArrayList<Body>();
    }

    public void initialize() {
        this.currentBodies.clear();
        for (Brain brain : this.getCurrentAgentsList()) {
            this.currentBodies.add(brain.getBody());
        }
    }

    public void update(AbstractAgent abstractAgent, boolean bl) {
        if (bl) {
            this.currentBodies.add(((Brain)abstractAgent).getBody());
        } else {
            this.currentBodies.remove(((Brain)abstractAgent).getBody());
        }
    }

    synchronized void executeBrains() {
        this.bodiesActing = new ArrayList<BasicBody>();
        Iterator<Body> iterator = this.currentBodies.listIterator();
        while (iterator.hasNext()) {
            BasicBody basicBody = (BasicBody)iterator.next();
            if (basicBody == null || basicBody.getBrain() == null || !basicBody.willAct()) continue;
            basicBody.action = 0;
            basicBody.createPerception();
            basicBody.getBrain().doIt();
            this.bodiesActing.add(basicBody);
        }
        for (BasicBody basicBody : this.bodiesActing) {
            basicBody.doIt();
        }
    }

    synchronized void executeBodies() {
        for (BasicBody basicBody : this.bodiesActing) {
            basicBody.doIt();
        }
    }
}

