/*
 * Decompiled with CFR 0.152.
 */
package madkit.kernel;

import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import madkit.kernel.AbstractAgent;
import madkit.kernel.Kernel;
import madkit.kernel.Role;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class Overlooker<A extends AbstractAgent> {
    private Role overlookedRole;
    final String community;
    final String group;
    final String role;

    Overlooker(String string, String string2, String string3) {
        this.community = string;
        this.group = string2;
        this.role = string3;
    }

    Overlooker(String string, String string2) {
        this(Kernel.DEFAULT_COMMUNITY, string, string2);
    }

    final synchronized void setOverlookedRole(Role role) {
        if (role != null) {
            this.overlookedRole = role;
            this.initialize();
        }
    }

    public abstract void initialize();

    void updateAgent(AbstractAgent abstractAgent, boolean bl) {
        this.update(abstractAgent, bl);
    }

    public abstract void update(AbstractAgent var1, boolean var2);

    public final ListIterator<A> getAgentsIterator() {
        return this.getCurrentAgentsList().listIterator();
    }

    public final List<A> getShuffledList() {
        List<A> list = this.getCurrentAgentsList();
        Collections.shuffle(list);
        return list;
    }

    public final synchronized List<A> getCurrentAgentsList() {
        return this.overlookedRole.getAgentsList();
    }

    public final int numberOfAgents() {
        return this.overlookedRole.getAgentsList().size();
    }

    public final synchronized A getAgentNb(int n) {
        return (A)this.overlookedRole.getAgentNb(n);
    }

    public final String getCommunity() {
        return this.community;
    }

    public final String getGroup() {
        return this.group;
    }

    public final String getRole() {
        return this.role;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " on <" + this.community + ";" + this.group + ";" + this.role + ">, agents " + "are " + this.getCurrentAgentsList().size();
    }
}

