/*
 * Decompiled with CFR 0.152.
 */
package madkit.kernel;

import madkit.kernel.AccessDeniedException;
import madkit.kernel.NotAMemberException;
import madkit.kernel.RoleAlreadyHandled;
import madkit.kernel.RoleNotHandled;

final class CGRException
extends Exception {
    private String community;
    private String group;
    private String role;
    private final int code;

    CGRException(int n, String string, String string2, String string3, Throwable throwable) {
        super(throwable);
        this.community = string;
        this.group = string2;
        this.role = string3;
        this.code = n;
    }

    final void setCommunity(String string) {
        this.community = string;
    }

    final void setGroup(String string) {
        this.group = string;
    }

    final void setRole(String string) {
        this.role = string;
    }

    public String getMessage() {
        return this.buildCGRMessage();
    }

    final String buildCGRMessage() {
        String string = this.getCause() instanceof RoleNotHandled ? " not handled" : (this.getCause() instanceof RoleAlreadyHandled ? " already handled" : (this.getCause() instanceof AccessDeniedException ? " access denied" : (this.getCause() instanceof NotAMemberException ? " not a member" : " does not exist")));
        string = string + " (set agent debug on for a trace)";
        if (this.role != null) {
            return " : Role <" + this.community + "," + this.group + "," + this.role + "> :" + string;
        }
        if (this.group != null) {
            return " Group <" + this.community + "," + this.group + "> :" + string;
        }
        return " Community <" + this.community + "> :" + string;
    }

    int getCode() {
        return this.code;
    }
}

